/*
 * Decompiled with CFR 0.152.
 */
package de.katzenpapst.amunra.helper;

import de.katzenpapst.amunra.block.BlockMetaPairHashable;
import de.katzenpapst.amunra.block.IMassiveBlock;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.IFluidBlock;

public class BlockMassHelper {
    private static Map<BlockMetaPairHashable, Float> blockMassMap = new HashMap<BlockMetaPairHashable, Float>();

    public static float getBlockMass(World world, Block block, int meta, int x, int y, int z) {
        if (block.isAir((IBlockAccess)world, x, y, z)) {
            return 0.0f;
        }
        if (block instanceof IMassiveBlock) {
            IMassiveBlock massiveBlock = (IMassiveBlock)block;
            return massiveBlock.getMass(world, x, y, z, meta);
        }
        BlockMetaPairHashable bmph = new BlockMetaPairHashable(block, (byte)meta);
        if (blockMassMap.containsKey((Object)bmph)) {
            return blockMassMap.get((Object)bmph).floatValue();
        }
        float guessedMass = BlockMassHelper.guessBlockMass(world, block, meta, x, y, z);
        blockMassMap.put(bmph, Float.valueOf(guessedMass));
        return guessedMass;
    }

    public static float guessBlockMass(World world, Block block, int meta, int x, int y, int z) {
        if (block instanceof IFluidBlock) {
            IFluidBlock fluidBlock = (IFluidBlock)block;
            return BlockMassHelper.getMassForFluid(fluidBlock.getFluid());
        }
        if (block instanceof BlockLiquid) {
            if (block == Blocks.field_150353_l) {
                return BlockMassHelper.getMassForFluid(FluidRegistry.LAVA);
            }
            return BlockMassHelper.getMassForFluid(FluidRegistry.WATER);
        }
        if (block == Blocks.field_150431_aC) {
            return (float)(meta + 1) * 0.025f;
        }
        if (block == Blocks.field_150395_bd) {
            return 0.01f;
        }
        return BlockMassHelper.getMassFromHardnessAndMaterial(block.func_149712_f(world, x, y, z), block.func_149688_o());
    }

    public static float getMassForFluid(Fluid fluid) {
        int density = fluid.getDensity();
        return (float)density / 1000.0f;
    }

    public static float getMassFromHardnessAndMaterial(float hardness, Material material) {
        float m = hardness;
        if (m < 0.1f) {
            m = 0.1f;
        } else if (m > 30.0f) {
            m = 30.0f;
        }
        if (material == Material.field_151575_d) {
            m /= 4.0f;
        }
        return m;
    }
}

