/*
 * Decompiled with CFR 0.152.
 */
package binnie.genetics.craftgui;

import binnie.Binnie;
import binnie.core.craftgui.IWidget;
import binnie.core.craftgui.controls.ControlText;
import binnie.core.craftgui.controls.core.Control;
import binnie.core.craftgui.controls.core.IControlValue;
import binnie.core.craftgui.geometry.IPoint;
import binnie.core.craftgui.minecraft.Window;
import binnie.core.genetics.BreedingSystem;
import binnie.core.genetics.Gene;
import binnie.genetics.craftgui.ControlGene;
import binnie.genetics.craftgui.WindowGeneBank;
import binnie.genetics.genetics.GeneTracker;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IChromosomeType;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ControlGeneScroll
extends Control
implements IControlValue<BreedingSystem> {
    private String filter = "";
    private BreedingSystem system = null;

    protected ControlGeneScroll(IWidget parent, float x, float y, float w, float h) {
        super(parent, x, y, w, h);
    }

    public void setFilter(String filter) {
        this.filter = filter.toLowerCase();
        this.refresh();
    }

    public void setGenes(BreedingSystem system) {
        this.system = system;
        this.refresh();
    }

    public void refresh() {
        this.deleteAllChildren();
        GeneTracker tracker = GeneTracker.getTracker(((Window)Window.get(this)).getWorld(), ((Window)Window.get(this)).getUsername());
        Map<IChromosomeType, List<IAllele>> genes = Binnie.Genetics.getChromosomeMap(this.system.getSpeciesRoot());
        int y = 0;
        boolean isNEI = ((WindowGeneBank)Window.get((IWidget)this)).isNei;
        for (Map.Entry<IChromosomeType, List<IAllele>> entry : genes.entrySet()) {
            ArrayList<IAllele> discovered = new ArrayList<IAllele>();
            for (IAllele allele : entry.getValue()) {
                Gene gene = new Gene(allele, entry.getKey(), this.system.getSpeciesRoot());
                if (!isNEI && !tracker.isSequenced(new Gene(allele, entry.getKey(), this.system.getSpeciesRoot())) || !gene.getName().toLowerCase().contains(this.filter)) continue;
                discovered.add(allele);
            }
            if (discovered.size() == 0) continue;
            int x = 0;
            new ControlText((IWidget)this, new IPoint(x, y), this.system.getChromosomeName(entry.getKey()));
            y += 12;
            for (IAllele allele : discovered) {
                if ((float)(x + 18) > this.getSize().x()) {
                    y += 20;
                    x = 0;
                }
                new ControlGene(this, x, y).setValue(new Gene(allele, entry.getKey(), this.system.getSpeciesRoot()));
                x += 18;
            }
            y += 24;
        }
        this.setSize(new IPoint(this.getSize().x(), y));
    }

    @Override
    public BreedingSystem getValue() {
        return this.system;
    }

    @Override
    public void setValue(BreedingSystem system) {
        this.setGenes(system);
    }
}

