/*
 * Decompiled with CFR 0.152.
 */
package binnie.botany.flower;

import binnie.botany.Botany;
import binnie.botany.CreativeTabBotany;
import binnie.core.util.I18N;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;

public class ItemInsulatedTube
extends Item {
    IIcon[] icons = new IIcon[3];

    public ItemInsulatedTube() {
        this.func_77655_b("insulatedTube");
        this.func_77637_a(CreativeTabBotany.instance);
        this.func_77627_a(true);
    }

    public static ItemStack getInsulateStack(ItemStack stack) {
        return Insulate.get(stack.func_77960_j()).getStack();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs tab, List list) {
        for (Material mat : Material.values()) {
            for (Insulate ins : Insulate.values()) {
                list.add(new ItemStack((Item)this, 1, mat.ordinal() + ins.ordinal() * 128));
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister register) {
        for (int i = 0; i < 3; ++i) {
            this.icons[i] = Botany.proxy.getIcon(register, "insulatedTube." + i);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public int func_82790_a(ItemStack stack, int pass) {
        if (pass == 0) {
            return 0xFFFFFF;
        }
        return pass == 1 ? Material.get(stack.func_77960_j()).getColor() : Insulate.get(stack.func_77960_j()).getColor();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List tooltip, boolean advanced) {
        super.func_77624_a(stack, player, tooltip, advanced);
        tooltip.add(Insulate.get(stack.func_77960_j()).getName());
    }

    public String func_77653_i(ItemStack stack) {
        return Material.get(stack.func_77960_j()).getName() + " " + I18N.localise("botany.tube.name");
    }

    public int getRenderPasses(int metadata) {
        return 3;
    }

    public IIcon getIcon(ItemStack stack, int pass) {
        return this.icons[pass % 3];
    }

    public boolean func_77623_v() {
        return true;
    }

    static enum Insulate {
        Clay(0xA1AACC, "clay"),
        Cobble(0x7B7B7B, "cobblestone"),
        Sand(15723189, "sand"),
        HardenedClay(9657411, "hardenedClay"),
        Stone(0x6D6D6D, "smoothStone"),
        Sandstone(12695945, "sandstone");

        protected int color;
        protected String name;

        private Insulate(int color, String name) {
            this.color = color;
            this.name = name;
        }

        public static Insulate get(int i) {
            return Insulate.values()[i / 128 % Insulate.values().length];
        }

        public int getColor() {
            return this.color;
        }

        public String getName() {
            return I18N.localise("botany.tube.insulate." + this.name);
        }

        public ItemStack getStack() {
            switch (this) {
                case Clay: {
                    return new ItemStack(Blocks.field_150435_aG);
                }
                case Cobble: {
                    return new ItemStack(Blocks.field_150347_e);
                }
                case HardenedClay: {
                    return new ItemStack(Blocks.field_150405_ch);
                }
                case Sand: {
                    return new ItemStack((Block)Blocks.field_150354_m);
                }
                case Sandstone: {
                    return new ItemStack(Blocks.field_150322_A);
                }
                case Stone: {
                    return new ItemStack(Blocks.field_150348_b);
                }
            }
            return null;
        }
    }

    static enum Material {
        Copper(14923662, "cooper"),
        Tin(14806772, "tin"),
        Bronze(14533238, "bronze"),
        Iron(0xD8D8D8, "iron");

        protected int color;
        protected String name;

        private Material(int color, String name) {
            this.color = color;
            this.name = name;
        }

        public static Material get(int i) {
            return Material.values()[i % Material.values().length];
        }

        public int getColor() {
            return this.color;
        }

        public String getName() {
            return I18N.localise("botany.tube." + this.name);
        }
    }
}

