/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.blocks;

import biomesoplenty.BiomesOPlenty;
import java.util.Arrays;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockStairs;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.util.IIcon;

public class BlockBOPStairs
extends BlockStairs {
    private static final String[] woodTypes = new String[]{"sacredoak", "cherry", "dark", "fir", "ethereal", "magic", "mangrove", "palm", "redwood", "willow", "pine", "hell_bark", "jacaranda", "mahogany"};
    private static final String[] stoneTypes = new String[]{"mudbrick"};
    private IIcon[] textures;
    private final Category category;

    public BlockBOPStairs(Block model, Category cat) {
        super(model, 0);
        this.category = cat;
        if (this.isWoodCategory(this.category.toString())) {
            this.func_149711_c(2.0f);
            this.func_149672_a(Block.field_149766_f);
        } else {
            this.func_149711_c(3.0f);
            this.func_149672_a(Block.field_149780_i);
        }
        this.field_149783_u = true;
        this.func_149647_a(BiomesOPlenty.tabBiomesOPlenty);
    }

    public void func_149651_a(IIconRegister iconRegister) {
        if (this.isStoneCategory(this.category.toString())) {
            this.textures = new IIcon[stoneTypes.length];
            for (int i = 0; i < stoneTypes.length; ++i) {
                this.textures[i] = iconRegister.func_94245_a("biomesoplenty:" + stoneTypes[i]);
            }
        } else {
            this.textures = new IIcon[woodTypes.length];
            for (int i = 0; i < woodTypes.length; ++i) {
                this.textures[i] = iconRegister.func_94245_a("biomesoplenty:plank_" + woodTypes[i]);
            }
        }
    }

    public boolean isWoodCategory(String block) {
        String type = Category.valueOf(block).type;
        return type == "wood";
    }

    public boolean isStoneCategory(String block) {
        String type = Category.valueOf(block).type;
        return type == "stone";
    }

    public static int getWoodCategoryAmount() {
        int woodCatNo = 0;
        for (Category cat : Category.values()) {
            if (!cat.values.contains("wood")) continue;
            ++woodCatNo;
        }
        return woodCatNo;
    }

    public static int getStoneCategoryAmount() {
        int woodCatNo = 0;
        for (Category cat : Category.values()) {
            if (!cat.values.contains("stone")) continue;
            ++woodCatNo;
        }
        return woodCatNo;
    }

    public IIcon func_149691_a(int side, int meta) {
        int adjCat = this.category.ordinal();
        if (this.isStoneCategory(this.category.toString())) {
            adjCat -= BlockBOPStairs.getWoodCategoryAmount();
        }
        return this.textures[adjCat];
    }

    public static enum Category {
        SACREDOAK("wood"),
        CHERRY("wood"),
        DARK("wood"),
        FIR("wood"),
        ETHEREAL("wood"),
        MAGIC("wood"),
        MANGROVE("wood"),
        PALM("wood"),
        REDWOOD("wood"),
        WILLOW("wood"),
        PINE("wood"),
        HELL_BARK("wood"),
        JACARANDA("wood"),
        MAHOGANY("wood"),
        MUD_BRICKS("stone");

        private final List<String> values;
        private String type;

        private Category(String type) {
            this.type = type;
            this.values = Arrays.asList(type);
        }
    }
}

