/*
 * Decompiled with CFR 0.152.
 */
package makeo.gadomancy.client.renderers.tile;

import java.awt.Color;
import java.util.Random;
import makeo.gadomancy.client.effect.EffectHandler;
import makeo.gadomancy.client.effect.fx.Orbital;
import makeo.gadomancy.client.models.ModelAuraPylon;
import makeo.gadomancy.client.models.ModelAuraPylonBottom;
import makeo.gadomancy.client.models.ModelAuraPylonTop;
import makeo.gadomancy.common.blocks.tiles.TileAuraPylon;
import makeo.gadomancy.common.blocks.tiles.TileAuraPylonTop;
import makeo.gadomancy.common.utils.SimpleResourceLocation;
import makeo.gadomancy.common.utils.Vector3;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.client.fx.ParticleEngine;
import thaumcraft.client.fx.particles.FXWisp;

public class RenderTileAuraPylon
extends TileEntitySpecialRenderer {
    public static final ModelBase MODEL_AURA_PYLON = new ModelAuraPylon();
    public static final ModelBase MODEL_AURA_PYLON_TOP = new ModelAuraPylonTop();
    public static final ModelBase MODEL_AURA_PYLON_BOTTOM = new ModelAuraPylonBottom();
    public static final SimpleResourceLocation PYLON_TEXTURE_TOP = new SimpleResourceLocation("models/aura_pylon_peak.png");
    public static final SimpleResourceLocation PYLON_TEXTURE = new SimpleResourceLocation("models/aura_pylon.png");
    public static final SimpleResourceLocation PYLON_TEXTURE_BOTTOM = new SimpleResourceLocation("models/aura_pylon_base.png");

    public void renderTileEntity(TileEntity tile, double x, double y, double z, float partTicks) {
        GL11.glPushMatrix();
        GL11.glTranslated((double)(x + 0.5), (double)(y - 0.5), (double)(z + 0.5));
        GL11.glPushMatrix();
        SimpleResourceLocation textureToBind = tile instanceof TileAuraPylonTop ? PYLON_TEXTURE_TOP : (((TileAuraPylon)tile).isInputTile() || ((TileAuraPylon)tile).isLowestTile() ? PYLON_TEXTURE_BOTTOM : PYLON_TEXTURE);
        this.func_147499_a(textureToBind);
        for (int i = 0; i < 4; ++i) {
            if (tile instanceof TileAuraPylonTop) {
                GL11.glPushMatrix();
                GL11.glRotatef((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                GL11.glTranslatef((float)0.0f, (float)-2.0f, (float)0.0f);
                MODEL_AURA_PYLON_TOP.func_78088_a(null, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0625f);
                GL11.glPopMatrix();
            } else if (((TileAuraPylon)tile).isInputTile() || ((TileAuraPylon)tile).isLowestTile()) {
                GL11.glPushMatrix();
                GL11.glRotatef((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                GL11.glTranslatef((float)0.0f, (float)-2.0f, (float)0.0f);
                MODEL_AURA_PYLON_BOTTOM.func_78088_a(null, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0625f);
                GL11.glPopMatrix();
            } else {
                MODEL_AURA_PYLON.func_78088_a(null, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0625f);
            }
            GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        }
        GL11.glPopMatrix();
        GL11.glPopMatrix();
        if (tile instanceof TileAuraPylonTop) {
            Aspect a;
            TileAuraPylonTop ta = (TileAuraPylonTop)tile;
            if (ta.orbital == null && tile.func_145831_w() != null) {
                ta.orbital = new Orbital(new Vector3((double)tile.field_145851_c + 0.5, (double)tile.field_145848_d + 0.7, (double)tile.field_145849_e + 0.5), tile.func_145831_w());
            }
            if (ta.orbital != null && !ta.orbital.registered) {
                EffectHandler.getInstance().registerOrbital(ta.orbital);
            }
            if (ta.shouldRenderEffect()) {
                a = ta.getAspect();
                if (a == null) {
                    a = Aspect.WEATHER;
                }
                Color c = new Color(a.getColor());
                if (tile.func_145831_w().field_73012_v.nextInt(12) == 0) {
                    if (a == Aspect.ENTROPY || a == Aspect.DARKNESS || a == Aspect.UNDEAD) {
                        this.spawnWispParticles((TileAuraPylonTop)tile, 5, 0.5f, false);
                    } else {
                        this.spawnWispParticles((TileAuraPylonTop)tile, c, 0.5f, false);
                    }
                }
                c = c.darker().darker();
                if (tile.func_145831_w().field_73012_v.nextInt(20) == 0) {
                    if (a == Aspect.ENTROPY || a == Aspect.DARKNESS || a == Aspect.UNDEAD) {
                        this.spawnWispParticles((TileAuraPylonTop)tile, 5, 0.25f, false);
                    } else {
                        this.spawnWispParticles((TileAuraPylonTop)tile, c, 0.25f, false);
                    }
                }
            }
            if (ta.orbital != null) {
                ta.orbital.lastRenderCall = System.currentTimeMillis();
            }
            if (ta.shouldRenderAuraEffect() && ta.getAspect() != null) {
                if (ta.orbital != null && ta.orbital.orbitalsSize() == 0 && (a = ta.getAspect()) != null) {
                    int col = a.getColor();
                    Color c = new Color(col |= 0x55000000, true);
                    Random rand = tile.func_145831_w().field_73012_v;
                    this.addNewOrbitalPoint(ta.orbital, rand, c);
                    this.addNewOrbitalPoint(ta.orbital, rand, c);
                    this.addNewOrbitalPoint(ta.orbital, rand, c);
                }
            } else if (ta.orbital != null && ta.orbital.orbitalsSize() > 0) {
                ta.orbital.clearOrbitals();
            }
        }
    }

    private void addNewOrbitalPoint(Orbital orbital, Random rand, Color color) {
        Orbital.OrbitalRenderProperties properties = new Orbital.OrbitalRenderProperties(Orbital.Axis.persisentRandomAxis(), rand.nextDouble() + 2.0);
        properties.setColor(color).setTicksForFullCircle(60 + rand.nextInt(40)).setOffsetTicks(rand.nextInt(80));
        properties.setSubParticleColor(color.brighter().brighter());
        orbital.addOrbitalPoint(properties);
    }

    private void spawnWispParticles(TileAuraPylonTop tile, int type, float size, boolean inner) {
        World worldObj = tile.func_145831_w();
        int xCoord = tile.field_145851_c;
        int yCoord = tile.field_145848_d;
        int zCoord = tile.field_145849_e;
        float offset1 = inner ? 0.4f : 0.3f;
        float offset2 = inner ? 0.2f : 0.4f;
        FXWisp ef = new FXWisp(worldObj, (double)((float)xCoord + 0.55f), (double)((float)yCoord + 0.7f), (double)((float)zCoord + 0.55f), (double)((float)xCoord + offset1 + worldObj.field_73012_v.nextFloat() * offset2), (double)((float)yCoord + 0.7f), (double)((float)zCoord + offset1 + worldObj.field_73012_v.nextFloat() * offset2), size, type);
        ef.setGravity(-0.04f);
        ef.shrink = true;
        ParticleEngine.instance.addEffect(worldObj, (EntityFX)ef);
    }

    private void spawnWispParticles(TileAuraPylonTop tile, Color c, float size, boolean inner) {
        World worldObj = tile.func_145831_w();
        int xCoord = tile.field_145851_c;
        int yCoord = tile.field_145848_d;
        int zCoord = tile.field_145849_e;
        float offset1 = inner ? 0.4f : 0.3f;
        float offset2 = inner ? 0.2f : 0.4f;
        float red = (float)c.getRed() / 255.0f;
        float green = (float)c.getGreen() / 255.0f;
        float blue = (float)c.getBlue() / 255.0f;
        FXWisp ef = new FXWisp(worldObj, (double)((float)xCoord + 0.55f), (double)((float)yCoord + 0.7f), (double)((float)zCoord + 0.55f), (double)((float)xCoord + offset1 + worldObj.field_73012_v.nextFloat() * offset2), (double)((float)yCoord + 0.7f), (double)((float)zCoord + offset1 + worldObj.field_73012_v.nextFloat() * offset2), size, red, green, blue);
        ef.setGravity(-0.04f);
        ef.shrink = true;
        ParticleEngine.instance.addEffect(worldObj, (EntityFX)ef);
    }

    public void func_147500_a(TileEntity tileEntity, double x, double y, double z, float partTicks) {
        this.renderTileEntity(tileEntity, x, y, z, partTicks);
    }
}

