/*
 * Decompiled with CFR 0.152.
 */
package forge.com.gitlab.cdagaming.craftpresence.utils.entity;

import forge.com.gitlab.cdagaming.craftpresence.CraftPresence;
import forge.com.gitlab.cdagaming.craftpresence.config.Config;
import forge.com.gitlab.cdagaming.craftpresence.config.element.ModuleData;
import forge.com.gitlab.cdagaming.craftpresence.impl.Module;
import forge.com.gitlab.cdagaming.craftpresence.utils.StringUtils;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.client.gui.GuiPlayerInfo;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.world.World;
import net.minecraft.world.storage.WorldInfo;

public class EntityUtils
implements Module {
    public boolean enabled = false;
    public List<String> ENTITY_NAMES = StringUtils.newArrayList();
    public List<String> DEFAULT_NAMES = StringUtils.newArrayList();
    public Map<String, String> PLAYER_BINDINGS = StringUtils.newHashMap();
    private boolean isInUse = false;
    private boolean hasScanned = false;
    private String CURRENT_TARGET_NAME;
    private String CURRENT_RIDING_NAME;
    private Entity CURRENT_TARGET;
    private Entity CURRENT_RIDING;

    public static String getName(Entity entity, boolean stripColors) {
        String result = "";
        if (entity != null) {
            result = StringUtils.getOrDefault(entity.func_145748_c_().func_150254_d(), entity.func_70005_c_());
        }
        if (stripColors) {
            result = StringUtils.stripColors(result);
        }
        return result;
    }

    public static String getName(Entity entity) {
        return EntityUtils.getName(entity, true);
    }

    public static String getWeather(World worldObj) {
        String name = "clear";
        if (worldObj != null) {
            WorldInfo info = worldObj.func_72912_H();
            name = info.func_76061_m() ? "thunder" : (info.func_76059_o() ? "rain" : "clear");
        }
        return name;
    }

    public static String getWeather(Entity entity) {
        return EntityUtils.getWeather(entity != null ? entity.field_70170_p : null);
    }

    @Override
    public void emptyData() {
        this.hasScanned = false;
        this.DEFAULT_NAMES.clear();
        this.ENTITY_NAMES.clear();
        this.PLAYER_BINDINGS.clear();
        this.clearClientData();
    }

    @Override
    public void clearClientData() {
        this.CURRENT_TARGET = null;
        this.CURRENT_RIDING = null;
        this.CURRENT_TARGET_NAME = null;
        this.CURRENT_RIDING_NAME = null;
        this.setInUse(false);
        CraftPresence.CLIENT.removeArguments("entity", "data.entity");
        CraftPresence.CLIENT.clearOverride("entity.target.message", "entity.target.icon", "entity.riding.message", "entity.riding.icon");
    }

    @Override
    public void onTick() {
        boolean needsUpdate;
        this.enabled = !CraftPresence.CONFIG.hasChanged ? CraftPresence.CONFIG.advancedSettings.enablePerEntity : this.enabled;
        boolean bl = needsUpdate = this.enabled && !this.hasScanned && this.canFetchData();
        if (needsUpdate) {
            this.scanForData();
            this.hasScanned = true;
        }
        if (this.enabled) {
            if (CraftPresence.player != null) {
                this.setInUse(true);
                this.updateData();
            } else if (this.isInUse()) {
                this.clearClientData();
            }
        } else if (this.isInUse()) {
            this.emptyData();
        }
    }

    @Override
    public void updateData() {
        boolean hasRidingChanged;
        Entity NEW_CURRENT_TARGET = CraftPresence.instance.field_71476_x != null && CraftPresence.instance.field_71476_x.field_72308_g != null ? CraftPresence.instance.field_71476_x.field_72308_g : null;
        Entity NEW_CURRENT_RIDING = CraftPresence.player.field_70154_o;
        boolean hasTargetChanged = !Objects.equals(NEW_CURRENT_TARGET, this.CURRENT_TARGET);
        boolean bl = hasRidingChanged = !Objects.equals(NEW_CURRENT_RIDING, this.CURRENT_RIDING);
        if (hasTargetChanged) {
            this.CURRENT_TARGET = NEW_CURRENT_TARGET;
            this.CURRENT_TARGET_NAME = EntityUtils.getName(this.CURRENT_TARGET);
            if (this.CURRENT_TARGET != null) {
                CraftPresence.CLIENT.syncTimestamp("data.entity.target.time");
                if (!this.DEFAULT_NAMES.contains(this.CURRENT_TARGET_NAME)) {
                    this.DEFAULT_NAMES.add(this.CURRENT_TARGET_NAME);
                }
                if (!this.ENTITY_NAMES.contains(this.CURRENT_TARGET_NAME)) {
                    this.ENTITY_NAMES.add(this.CURRENT_TARGET_NAME);
                }
            }
        }
        if (hasRidingChanged) {
            this.CURRENT_RIDING = NEW_CURRENT_RIDING;
            this.CURRENT_RIDING_NAME = EntityUtils.getName(this.CURRENT_RIDING);
            if (this.CURRENT_RIDING != null) {
                CraftPresence.CLIENT.syncTimestamp("data.entity.riding.time");
                if (!this.DEFAULT_NAMES.contains(this.CURRENT_RIDING_NAME)) {
                    this.DEFAULT_NAMES.add(this.CURRENT_RIDING_NAME);
                }
                if (!this.ENTITY_NAMES.contains(this.CURRENT_RIDING_NAME)) {
                    this.ENTITY_NAMES.add(this.CURRENT_RIDING_NAME);
                }
            }
        }
        if (hasTargetChanged || hasRidingChanged) {
            this.updatePresence();
        }
    }

    @Override
    public void updatePresence() {
        ModuleData defaultTargetData = CraftPresence.CONFIG.advancedSettings.entitySettings.targetData.get("default");
        ModuleData defaultRidingData = CraftPresence.CONFIG.advancedSettings.entitySettings.ridingData.get("default");
        ModuleData currentTargetData = CraftPresence.CONFIG.advancedSettings.entitySettings.targetData.get(this.CURRENT_TARGET_NAME);
        ModuleData currentRidingData = CraftPresence.CONFIG.advancedSettings.entitySettings.targetData.get(this.CURRENT_RIDING_NAME);
        String defaultTargetMessage = Config.isValidProperty(defaultTargetData, "textOverride") ? defaultTargetData.getTextOverride() : "";
        String defaultRidingMessage = Config.isValidProperty(defaultRidingData, "textOverride") ? defaultRidingData.getTextOverride() : "";
        String currentTargetMessage = Config.isValidProperty(currentTargetData, "textOverride") ? currentTargetData.getTextOverride() : defaultTargetMessage;
        String currentRidingMessage = Config.isValidProperty(currentRidingData, "textOverride") ? currentRidingData.getTextOverride() : defaultRidingMessage;
        String currentTargetIcon = Config.isValidProperty(currentTargetData, "iconOverride") ? currentTargetData.getIconOverride() : this.CURRENT_TARGET_NAME;
        String currentRidingIcon = Config.isValidProperty(currentRidingData, "iconOverride") ? currentRidingData.getIconOverride() : this.CURRENT_RIDING_NAME;
        String formattedTargetIcon = CraftPresence.CLIENT.imageOf("entity.target.icon", true, currentTargetIcon, CraftPresence.CONFIG.advancedSettings.entitySettings.fallbackEntityIcon);
        String formattedRidingIcon = CraftPresence.CLIENT.imageOf("entity.riding.icon", true, currentRidingIcon, CraftPresence.CONFIG.advancedSettings.entitySettings.fallbackEntityIcon);
        CraftPresence.CLIENT.syncArgument("entity.default.icon", CraftPresence.CONFIG.advancedSettings.entitySettings.fallbackEntityIcon);
        if (this.CURRENT_TARGET != null) {
            CraftPresence.CLIENT.syncArgument("data.entity.target.instance", this.CURRENT_TARGET);
            CraftPresence.CLIENT.syncArgument("data.entity.target.class", this.CURRENT_TARGET.getClass());
            CraftPresence.CLIENT.syncArgument("entity.target.name", this.CURRENT_TARGET_NAME);
            CraftPresence.CLIENT.syncOverride(currentTargetData != null ? currentTargetData : defaultTargetData, "entity.target.message", "entity.target.icon");
            CraftPresence.CLIENT.syncArgument("entity.target.message", currentTargetMessage);
            CraftPresence.CLIENT.syncArgument("entity.target.icon", formattedTargetIcon);
        } else {
            CraftPresence.CLIENT.removeArguments("entity.target", "data.entity.target");
        }
        if (this.CURRENT_RIDING != null) {
            CraftPresence.CLIENT.syncArgument("data.entity.riding.instance", this.CURRENT_RIDING);
            CraftPresence.CLIENT.syncArgument("data.entity.riding.class", this.CURRENT_RIDING.getClass());
            CraftPresence.CLIENT.syncArgument("entity.riding.name", this.CURRENT_RIDING_NAME);
            CraftPresence.CLIENT.syncOverride(currentRidingData != null ? currentRidingData : defaultRidingData, "entity.riding.message", "entity.riding.icon");
            CraftPresence.CLIENT.syncArgument("entity.riding.message", currentRidingMessage);
            CraftPresence.CLIENT.syncArgument("entity.riding.icon", formattedRidingIcon);
        } else {
            CraftPresence.CLIENT.removeArguments("entity.riding", "data.entity.riding");
        }
    }

    @Override
    public void getAllData() {
        if (!EntityList.func_151515_b().isEmpty()) {
            for (Object entityLocationObj : EntityList.func_151515_b()) {
                String entityLocation = (String)entityLocationObj;
                if (entityLocation == null) continue;
                String entityName = StringUtils.getOrDefault(entityLocation, "generic");
                if (!this.DEFAULT_NAMES.contains(entityName)) {
                    this.DEFAULT_NAMES.add(entityName);
                }
                if (this.ENTITY_NAMES.contains(entityName)) continue;
                this.ENTITY_NAMES.add(entityName);
            }
        }
        if (CraftPresence.SERVER.enabled) {
            for (GuiPlayerInfo playerInfo : CraftPresence.SERVER.currentPlayerList) {
                String uuidString;
                if (playerInfo == null || StringUtils.isNullOrEmpty(uuidString = playerInfo.field_78831_a)) continue;
                if (!this.ENTITY_NAMES.contains(uuidString)) {
                    this.ENTITY_NAMES.add(uuidString);
                }
                if (this.PLAYER_BINDINGS.containsKey(uuidString)) continue;
                this.PLAYER_BINDINGS.put(uuidString, uuidString);
            }
        }
        for (String entityTargetEntry : CraftPresence.CONFIG.advancedSettings.entitySettings.targetData.keySet()) {
            if (StringUtils.isNullOrEmpty(entityTargetEntry) || this.ENTITY_NAMES.contains(entityTargetEntry)) continue;
            this.ENTITY_NAMES.add(entityTargetEntry);
        }
        for (String entityRidingEntry : CraftPresence.CONFIG.advancedSettings.entitySettings.ridingData.keySet()) {
            if (StringUtils.isNullOrEmpty(entityRidingEntry) || this.ENTITY_NAMES.contains(entityRidingEntry)) continue;
            this.ENTITY_NAMES.add(entityRidingEntry);
        }
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(boolean state) {
        this.enabled = state;
    }

    @Override
    public boolean isInUse() {
        return this.isInUse;
    }

    @Override
    public void setInUse(boolean state) {
        this.isInUse = state;
    }
}

