/*
 * Decompiled with CFR 0.152.
 */
package fabric.com.gitlab.cdagaming.craftpresence.utils.gui;

import external.io.github.classgraph.ClassInfo;
import fabric.com.gitlab.cdagaming.craftpresence.CraftPresence;
import fabric.com.gitlab.cdagaming.craftpresence.config.Config;
import fabric.com.gitlab.cdagaming.craftpresence.config.element.ModuleData;
import fabric.com.gitlab.cdagaming.craftpresence.impl.Module;
import fabric.com.gitlab.cdagaming.craftpresence.utils.FileUtils;
import fabric.com.gitlab.cdagaming.craftpresence.utils.MappingUtils;
import fabric.com.gitlab.cdagaming.craftpresence.utils.StringUtils;
import fabric.com.gitlab.cdagaming.craftpresence.utils.gui.integrations.ExtendedScreen;
import java.util.List;
import java.util.Map;
import net.minecraft.class_370;
import net.minecraft.class_388;
import net.minecraft.class_409;

public class GuiUtils
implements Module {
    public final Map<String, ClassInfo> GUI_CLASSES = StringUtils.newHashMap();
    public boolean configGUIOpened = false;
    public boolean isFocused = false;
    public boolean enabled = false;
    public List<String> GUI_NAMES = StringUtils.newArrayList();
    public List<String> DEFAULT_NAMES = StringUtils.newArrayList();
    public class_388 CURRENT_SCREEN;
    private boolean isInUse = false;
    private boolean hasScanned = false;
    private String CURRENT_GUI_NAME;

    public static class_370 getDefaultFontRenderer() {
        return CraftPresence.instance.field_3814;
    }

    @Override
    public void emptyData() {
        this.hasScanned = false;
        this.DEFAULT_NAMES.clear();
        this.GUI_NAMES.clear();
        this.GUI_CLASSES.clear();
        this.clearClientData();
    }

    @Override
    public void clearClientData() {
        this.CURRENT_GUI_NAME = null;
        this.CURRENT_SCREEN = null;
        this.setInUse(false);
        CraftPresence.CLIENT.removeArguments("screen", "data.screen");
        CraftPresence.CLIENT.clearOverride("screen.message", "screen.icon");
    }

    @Override
    public void onTick() {
        boolean needsUpdate;
        this.enabled = !CraftPresence.CONFIG.hasChanged ? CraftPresence.CONFIG.advancedSettings.enablePerGui : this.enabled;
        this.isFocused = CraftPresence.instance.field_3816 != null && CraftPresence.instance.field_3765;
        boolean bl = needsUpdate = this.enabled && !this.hasScanned && this.canFetchData();
        if (needsUpdate) {
            this.scanForData();
            this.hasScanned = true;
        }
        if (this.enabled) {
            if (CraftPresence.instance.field_3816 != null) {
                this.setInUse(true);
                this.updateData();
            } else if (this.isInUse()) {
                this.clearClientData();
            }
        } else if (this.isInUse()) {
            this.emptyData();
        }
        if (this.configGUIOpened && !(CraftPresence.instance.field_3816 instanceof ExtendedScreen)) {
            this.configGUIOpened = false;
        }
    }

    @Override
    public void updateData() {
        if (CraftPresence.instance.field_3816 == null) {
            this.clearClientData();
        } else {
            class_388 newScreen = CraftPresence.instance.field_3816;
            String newScreenName = MappingUtils.getClassName(newScreen);
            if (!newScreen.equals(this.CURRENT_SCREEN) || !newScreenName.equals(this.CURRENT_GUI_NAME)) {
                this.CURRENT_SCREEN = newScreen;
                this.CURRENT_GUI_NAME = newScreenName;
                if (!this.DEFAULT_NAMES.contains(newScreenName)) {
                    this.DEFAULT_NAMES.add(newScreenName);
                }
                if (!this.GUI_NAMES.contains(newScreenName)) {
                    this.GUI_NAMES.add(newScreenName);
                }
                this.updatePresence();
            }
        }
    }

    @Override
    public void getAllData() {
        List<Class<?>> searchClasses = StringUtils.newArrayList(class_388.class, class_409.class);
        for (ClassInfo classObj : FileUtils.getClassNamesMatchingSuperType(searchClasses, CraftPresence.CONFIG.advancedSettings.includeExtraGuiClasses, new String[0]).values()) {
            String screenName = MappingUtils.getClassName(classObj);
            if (!this.DEFAULT_NAMES.contains(screenName)) {
                this.DEFAULT_NAMES.add(screenName);
            }
            if (!this.GUI_NAMES.contains(screenName)) {
                this.GUI_NAMES.add(screenName);
            }
            if (this.GUI_CLASSES.containsKey(screenName)) continue;
            this.GUI_CLASSES.put(screenName, classObj);
        }
        for (String guiEntry : CraftPresence.CONFIG.advancedSettings.guiSettings.guiData.keySet()) {
            if (StringUtils.isNullOrEmpty(guiEntry) || this.GUI_NAMES.contains(guiEntry)) continue;
            this.GUI_NAMES.add(guiEntry);
        }
    }

    @Override
    public boolean canFetchData() {
        return FileUtils.canScanClasses();
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(boolean state) {
        this.enabled = state;
    }

    @Override
    public boolean isInUse() {
        return this.isInUse;
    }

    @Override
    public void setInUse(boolean state) {
        this.isInUse = state;
    }

    @Override
    public void updatePresence() {
        ModuleData defaultData = CraftPresence.CONFIG.advancedSettings.guiSettings.guiData.get("default");
        ModuleData currentData = CraftPresence.CONFIG.advancedSettings.guiSettings.guiData.get(this.CURRENT_GUI_NAME);
        String defaultMessage = Config.isValidProperty(defaultData, "textOverride") ? defaultData.getTextOverride() : "";
        String currentMessage = Config.isValidProperty(currentData, "textOverride") ? currentData.getTextOverride() : defaultMessage;
        String defaultIcon = Config.isValidProperty(defaultData, "iconOverride") ? defaultData.getIconOverride() : this.CURRENT_GUI_NAME;
        String currentIcon = Config.isValidProperty(currentData, "iconOverride") ? currentData.getIconOverride() : defaultIcon;
        String formattedIcon = CraftPresence.CLIENT.imageOf("screen.icon", true, currentIcon, CraftPresence.CONFIG.advancedSettings.guiSettings.fallbackGuiIcon);
        CraftPresence.CLIENT.syncArgument("screen.default.icon", CraftPresence.CONFIG.advancedSettings.guiSettings.fallbackGuiIcon);
        CraftPresence.CLIENT.syncArgument("data.screen.instance", this.CURRENT_SCREEN);
        CraftPresence.CLIENT.syncArgument("screen.name", this.CURRENT_GUI_NAME);
        CraftPresence.CLIENT.syncOverride(currentData != null ? currentData : defaultData, "screen.message", "screen.icon");
        CraftPresence.CLIENT.syncArgument("screen.message", currentMessage);
        CraftPresence.CLIENT.syncArgument("screen.icon", formattedIcon);
        CraftPresence.CLIENT.syncTimestamp("data.screen.time");
    }
}

