/*
 * Decompiled with CFR 0.152.
 */
package fabric.com.gitlab.cdagaming.craftpresence.impl.discord;

import fabric.com.gitlab.cdagaming.craftpresence.utils.StringUtils;

public enum DiscordStatus {
    Disconnected,
    Ready,
    JoinGame("Join Game"),
    JoinRequest("Join Request"),
    SpectateGame("Spectate Game"),
    Invalid;

    private final String displayName;

    private DiscordStatus() {
        this.displayName = StringUtils.formatWord(this.name());
    }

    private DiscordStatus(String displayName) {
        this.displayName = displayName;
    }

    public static DiscordStatus from(String displayName) {
        for (DiscordStatus value : DiscordStatus.values()) {
            if (value.getDisplayName() == null || !value.getDisplayName().equals(displayName)) continue;
            return value;
        }
        return Invalid;
    }

    public String getDisplayName() {
        return this.displayName;
    }
}

