/*
 * Decompiled with CFR 0.152.
 */
package fabric.com.gitlab.cdagaming.craftpresence.config.gui;

import fabric.com.gitlab.cdagaming.craftpresence.CraftPresence;
import fabric.com.gitlab.cdagaming.craftpresence.ModUtils;
import fabric.com.gitlab.cdagaming.craftpresence.config.Config;
import fabric.com.gitlab.cdagaming.craftpresence.config.category.Dimension;
import fabric.com.gitlab.cdagaming.craftpresence.config.element.ModuleData;
import fabric.com.gitlab.cdagaming.craftpresence.config.element.PresenceData;
import fabric.com.gitlab.cdagaming.craftpresence.config.gui.PresenceSettingsGui;
import fabric.com.gitlab.cdagaming.craftpresence.utils.StringUtils;
import fabric.com.gitlab.cdagaming.craftpresence.utils.discord.assets.DiscordAssetUtils;
import fabric.com.gitlab.cdagaming.craftpresence.utils.gui.controls.ExtendedButtonControl;
import fabric.com.gitlab.cdagaming.craftpresence.utils.gui.controls.ExtendedTextControl;
import fabric.com.gitlab.cdagaming.craftpresence.utils.gui.controls.ScrollableListControl;
import fabric.com.gitlab.cdagaming.craftpresence.utils.gui.impl.ConfigurationGui;
import fabric.com.gitlab.cdagaming.craftpresence.utils.gui.impl.DynamicEditorGui;
import fabric.com.gitlab.cdagaming.craftpresence.utils.gui.impl.SelectorGui;
import fabric.com.gitlab.cdagaming.craftpresence.utils.gui.widgets.TextWidget;
import net.minecraft.class_388;

public class DimensionSettingsGui
extends ConfigurationGui<Dimension> {
    private final Dimension INSTANCE;
    private final Dimension DEFAULTS = this.getCurrentData().getDefaults();
    private final ModuleData defaultData;
    private ExtendedButtonControl dimensionMessagesButton;
    private ExtendedTextControl defaultMessage;

    DimensionSettingsGui(class_388 parentScreen) {
        super(parentScreen, "gui.config.title", "gui.config.title.dimension_messages");
        this.INSTANCE = this.getCurrentData().copy();
        this.defaultData = this.getCurrentData().dimensionData.get("default");
    }

    @Override
    protected void appendControls() {
        super.appendControls();
        String defaultDimensionMessage = Config.getProperty(this.defaultData, "textOverride") != null ? this.defaultData.getTextOverride() : "";
        this.defaultMessage = this.childFrame.addControl(new TextWidget(this.getFontRenderer(), this.getButtonY(0), 180, 20, "gui.config.message.default.dimension", () -> this.drawMultiLineString(StringUtils.splitTextByNewLine(ModUtils.TRANSLATOR.translate("gui.config.comment.dimension_messages.dimension_messages", CraftPresence.CLIENT.generateArgumentMessage("dimension."))))));
        this.defaultMessage.setControlMessage(defaultDimensionMessage);
        this.dimensionMessagesButton = this.childFrame.addControl(new ExtendedButtonControl(this.getScreenWidth() / 2 - 90, this.getButtonY(1), 180, 20, "gui.config.name.dimension_messages.dimension_messages", () -> this.openScreen(new SelectorGui(this.currentScreen, ModUtils.TRANSLATOR.translate("gui.config.title.selector.dimension", new Object[0]), CraftPresence.DIMENSIONS.DIMENSION_NAMES, null, null, true, true, ScrollableListControl.RenderType.None, (attributeName, currentValue) -> {
            ModuleData defaultDimensionData = this.getCurrentData().dimensionData.get("default");
            ModuleData currentDimensionData = this.getCurrentData().dimensionData.get(attributeName);
            String defaultMessage = Config.getProperty(defaultDimensionData, "textOverride") != null ? defaultDimensionData.getTextOverride() : "";
            String currentMessage = Config.getProperty(currentDimensionData, "textOverride") != null ? currentDimensionData.getTextOverride() : "";
            CraftPresence.CONFIG.hasChanged = true;
            ModuleData newData = new ModuleData();
            if (StringUtils.isNullOrEmpty(currentMessage) || currentMessage.equals(defaultMessage)) {
                newData.setTextOverride(defaultMessage);
            }
            newData.setIconOverride((String)currentValue);
            this.getCurrentData().dimensionData.put((String)attributeName, newData);
        }, (currentValue, parentScreen) -> this.openScreen(new DynamicEditorGui((class_388)parentScreen, (String)currentValue, (attributeName, screenInstance) -> {
            screenInstance.defaultData = this.getCurrentData().dimensionData.get("default");
            screenInstance.originalPrimaryMessage = Config.getProperty(screenInstance.defaultData, "textOverride") != null ? screenInstance.defaultData.getTextOverride() : "";
            screenInstance.primaryMessage = screenInstance.originalPrimaryMessage;
        }, (attributeName, screenInstance) -> {
            screenInstance.defaultData = this.getCurrentData().dimensionData.get("default");
            screenInstance.currentData = this.getCurrentData().dimensionData.get(attributeName);
            screenInstance.isPreliminaryData = screenInstance.currentData == null;
            screenInstance.mainTitle = ModUtils.TRANSLATOR.translate("gui.config.title.dimension.edit_specific_dimension", attributeName);
            screenInstance.originalPrimaryMessage = Config.getProperty(screenInstance.defaultData, "textOverride") != null ? screenInstance.defaultData.getTextOverride() : "";
            screenInstance.primaryMessage = Config.getProperty(screenInstance.currentData, "textOverride") != null ? screenInstance.currentData.getTextOverride() : screenInstance.originalPrimaryMessage;
        }, (screenInstance, attributeName, inputText) -> {
            screenInstance.currentData.setTextOverride((String)inputText);
            CraftPresence.CONFIG.hasChanged = true;
            this.getCurrentData().dimensionData.put((String)attributeName, screenInstance.currentData);
            if (!CraftPresence.DIMENSIONS.DIMENSION_NAMES.contains(attributeName)) {
                CraftPresence.DIMENSIONS.DIMENSION_NAMES.add((String)attributeName);
            }
        }, (screenInstance, attributeName, inputText) -> {
            CraftPresence.CONFIG.hasChanged = true;
            this.getCurrentData().dimensionData.remove(attributeName);
            if (!CraftPresence.DIMENSIONS.DEFAULT_NAMES.contains(attributeName)) {
                CraftPresence.DIMENSIONS.DIMENSION_NAMES.remove(attributeName);
            }
        }, (attributeName, screenInstance, isPresenceButton) -> {
            if (isPresenceButton.booleanValue()) {
                PresenceData defaultPresenceData = Config.getProperty(screenInstance.defaultData, "data") != null ? screenInstance.defaultData.getData() : new PresenceData();
                PresenceData currentPresenceData = Config.getProperty(screenInstance.currentData, "data") != null ? screenInstance.currentData.getData() : defaultPresenceData;
                this.openScreen(new PresenceSettingsGui((class_388)screenInstance, currentPresenceData, output -> screenInstance.currentData.setData((PresenceData)output)));
            } else {
                String defaultIcon = Config.getProperty(screenInstance.defaultData, "iconOverride") != null ? screenInstance.defaultData.getIconOverride() : this.getCurrentData().fallbackDimensionIcon;
                String specificIcon = Config.getProperty(screenInstance.currentData, "iconOverride") != null ? screenInstance.currentData.getIconOverride() : defaultIcon;
                this.openScreen(new SelectorGui((class_388)screenInstance, ModUtils.TRANSLATOR.translate("gui.config.title.selector.icon", new Object[0]), DiscordAssetUtils.ASSET_LIST.keySet(), specificIcon, (String)attributeName, true, false, ScrollableListControl.RenderType.DiscordAsset, (innerAttributeName, innerCurrentValue) -> screenInstance.currentData.setIconOverride((String)innerCurrentValue), null));
            }
        }, (attributeName, screenInstance) -> screenInstance.drawMultiLineString(StringUtils.splitTextByNewLine(ModUtils.TRANSLATOR.translate("gui.config.comment.dimension_messages.dimension_messages", CraftPresence.CLIENT.generateArgumentMessage("dimension.")))))))), () -> {
            if (!this.dimensionMessagesButton.isControlEnabled()) {
                this.drawMultiLineString(StringUtils.splitTextByNewLine(ModUtils.TRANSLATOR.translate("gui.config.message.hover.access", ModUtils.TRANSLATOR.translate("gui.config.name.general.detect_dimension_data", new Object[0]))));
            } else {
                this.drawMultiLineString(StringUtils.splitTextByNewLine(ModUtils.TRANSLATOR.translate("gui.config.comment.dimension_messages.dimension_messages", CraftPresence.CLIENT.generateArgumentMessage("dimension."))));
            }
        }, new String[0]));
        this.childFrame.addControl(new ExtendedButtonControl(this.getScreenWidth() / 2 - 90, this.getButtonY(2), 180, 20, "gui.config.name.dimension_messages.dimension_icon", () -> this.openScreen(new SelectorGui(this.currentScreen, ModUtils.TRANSLATOR.translate("gui.config.title.selector.icon", new Object[0]), DiscordAssetUtils.ASSET_LIST.keySet(), this.getCurrentData().fallbackDimensionIcon, null, true, false, ScrollableListControl.RenderType.DiscordAsset, (attributeName, currentValue) -> {
            CraftPresence.CONFIG.hasChanged = true;
            this.getCurrentData().fallbackDimensionIcon = currentValue;
        }, null)), () -> this.drawMultiLineString(StringUtils.splitTextByNewLine(ModUtils.TRANSLATOR.translate("gui.config.comment.dimension_messages.dimension_icon", new Object[0]))), new String[0]));
        this.proceedButton.setOnHover(() -> {
            if (!this.proceedButton.isControlEnabled()) {
                this.drawMultiLineString(StringUtils.splitTextByNewLine(ModUtils.TRANSLATOR.translate("gui.config.message.hover.empty.default", new Object[0])));
            }
        });
    }

    @Override
    protected boolean canReset() {
        return !this.getCurrentData().equals(this.DEFAULTS);
    }

    @Override
    protected boolean allowedToReset() {
        return true;
    }

    @Override
    protected boolean resetData() {
        return this.setCurrentData(this.DEFAULTS);
    }

    @Override
    protected boolean canSync() {
        return true;
    }

    @Override
    protected boolean allowedToSync() {
        return true;
    }

    @Override
    protected boolean syncData() {
        return this.setCurrentData(Config.loadOrCreate().dimensionSettings);
    }

    @Override
    protected void syncRenderStates() {
        super.syncRenderStates();
        this.proceedButton.setControlEnabled(!StringUtils.isNullOrEmpty(this.defaultMessage.getControlMessage()));
        this.dimensionMessagesButton.setControlEnabled(CraftPresence.DIMENSIONS.enabled);
    }

    @Override
    protected void applySettings() {
        String defaultDimensionMessage;
        String string = defaultDimensionMessage = Config.getProperty(this.defaultData, "textOverride") != null ? this.defaultData.getTextOverride() : "";
        if (!this.defaultMessage.getControlMessage().equals(defaultDimensionMessage)) {
            CraftPresence.CONFIG.hasChanged = true;
            ModuleData defaultDimensionData = this.getCurrentData().dimensionData.getOrDefault("default", new ModuleData());
            defaultDimensionData.setTextOverride(this.defaultMessage.getControlMessage());
            this.getCurrentData().dimensionData.put("default", defaultDimensionData);
        }
    }

    @Override
    protected Dimension getOriginalData() {
        return this.INSTANCE;
    }

    @Override
    protected Dimension getCurrentData() {
        return CraftPresence.CONFIG.dimensionSettings;
    }

    @Override
    protected boolean setCurrentData(Dimension data) {
        if (!this.getCurrentData().equals(data)) {
            this.getCurrentData().transferFrom(data);
            CraftPresence.CONFIG.hasChanged = true;
            return true;
        }
        return false;
    }
}

