/*
 * Decompiled with CFR 0.152.
 */
package fabric.com.gitlab.cdagaming.craftpresence;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import fabric.com.gitlab.cdagaming.craftpresence.ModUtils;
import fabric.com.gitlab.cdagaming.craftpresence.config.Config;
import fabric.com.gitlab.cdagaming.craftpresence.utils.CommandUtils;
import fabric.com.gitlab.cdagaming.craftpresence.utils.FileUtils;
import fabric.com.gitlab.cdagaming.craftpresence.utils.KeyUtils;
import fabric.com.gitlab.cdagaming.craftpresence.utils.MappingUtils;
import fabric.com.gitlab.cdagaming.craftpresence.utils.SystemUtils;
import fabric.com.gitlab.cdagaming.craftpresence.utils.TimeUtils;
import fabric.com.gitlab.cdagaming.craftpresence.utils.discord.DiscordUtils;
import fabric.com.gitlab.cdagaming.craftpresence.utils.entity.EntityUtils;
import fabric.com.gitlab.cdagaming.craftpresence.utils.entity.TileEntityUtils;
import fabric.com.gitlab.cdagaming.craftpresence.utils.gui.GuiUtils;
import fabric.com.gitlab.cdagaming.craftpresence.utils.server.ServerUtils;
import fabric.com.gitlab.cdagaming.craftpresence.utils.world.BiomeUtils;
import fabric.com.gitlab.cdagaming.craftpresence.utils.world.DimensionUtils;
import net.minecraft.class_1600;
import net.minecraft.class_355;
import net.minecraft.class_988;

@SuppressFBWarnings(value={"MS_CANNOT_BE_FINAL"})
public class CraftPresence {
    public static final KeyUtils KEYBINDINGS = new KeyUtils();
    public static final DiscordUtils CLIENT = new DiscordUtils();
    public static final ServerUtils SERVER = new ServerUtils();
    public static final BiomeUtils BIOMES = new BiomeUtils();
    public static final DimensionUtils DIMENSIONS = new DimensionUtils();
    public static final EntityUtils ENTITIES = new EntityUtils();
    public static final TileEntityUtils TILE_ENTITIES = new TileEntityUtils();
    public static final GuiUtils GUIS = new GuiUtils();
    public static final SystemUtils SYSTEM = new SystemUtils();
    public static class_1600 instance;
    public static class_355 session;
    public static class_988 player;
    public static Config CONFIG;
    private final Runnable initCallback;
    private boolean initialized = false;

    public CraftPresence(Runnable callback) {
        this.initCallback = callback;
        this.scheduleTick();
    }

    public CraftPresence() {
        this(null);
    }

    private void init() {
        FileUtils.detectClasses();
        MappingUtils.getClassMap();
        ModUtils.LOG.debugWarn(ModUtils.TRANSLATOR.translate(true, "craftpresence.logger.warning.debug_mode", new Object[0]), new Object[0]);
        ModUtils.LOG.debugInfo(ModUtils.TRANSLATOR.translate(true, "craftpresence.logger.info.os", SystemUtils.OS_NAME, SystemUtils.OS_ARCH, SystemUtils.IS_64_BIT), new Object[0]);
        ModUtils.UPDATER.checkForUpdates();
        CONFIG = Config.getInstance();
        CommandUtils.init();
        try {
            CraftPresence.CLIENT.CLIENT_ID = CraftPresence.CONFIG.generalSettings.clientId;
            CraftPresence.CLIENT.AUTO_REGISTER = CraftPresence.CONFIG.generalSettings.autoRegister;
            CLIENT.setup();
            CLIENT.init(true);
        }
        catch (Exception ex) {
            ModUtils.LOG.error(ModUtils.TRANSLATOR.translate("craftpresence.logger.error.load", new Object[0]), new Object[0]);
            if (CommandUtils.isVerboseMode()) {
                ex.printStackTrace();
            }
        }
        finally {
            if (this.initCallback != null) {
                this.initCallback.run();
            }
            this.initialized = true;
        }
    }

    private void scheduleTick() {
        if (!CraftPresence.SYSTEM.IS_GAME_CLOSING) {
            CommandUtils.getThreadPool().scheduleAtFixedRate(this::clientTick, 0L, 50L, TimeUtils.getTimeUnitFrom("MILLISECONDS"));
        }
    }

    private void clientTick() {
        if (!CraftPresence.SYSTEM.IS_GAME_CLOSING) {
            instance = class_1600.method_2965();
            if (this.initialized) {
                session = instance.method_5568();
                player = CraftPresence.instance.field_3805;
                CommandUtils.reloadData(false);
            } else if (instance != null && (session = instance.method_5568()) != null) {
                this.init();
            }
        }
    }
}

