/*
 * Decompiled with CFR 0.152.
 */
package com.n247s.api.eventapi.eventsystem;

import com.n247s.api.eventapi.EventApi;
import com.n247s.api.eventapi.eventsystem.CallHandler;
import com.n247s.api.eventapi.eventsystem.CustomEventSubscribe;
import com.n247s.api.eventapi.eventsystem.EventApiCallHandler;
import com.n247s.api.eventapi.eventsystem.EventType;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.List;
import org.apache.logging.log4j.Logger;

public class EventBus {
    private static final Logger log = EventApi.logger;
    protected HashMap<Class<? extends EventType>, ? super CallHandler> EventList = new HashMap();

    public boolean raiseEvent(EventType eventType) {
        try {
            Class<?> eventClass = eventType.getClass();
            if (!this.EventList.containsKey(eventClass)) {
                this.EventList.put(eventClass, new EventApiCallHandler(eventClass));
            }
            return this.EventList.get(eventClass).CallInstances(eventType);
        }
        catch (Exception e) {
            log.catching((Throwable)e);
            return false;
        }
    }

    public void bindCallHandler(CallHandler callHandler) {
        if (this.EventList.containsKey(callHandler.eventType)) {
            this.EventList.remove(callHandler.eventType);
        }
        this.EventList.put(callHandler.eventType, callHandler);
    }

    public void RegisterEventListener(Object listener) {
        Class clazz = !(listener instanceof Class) ? listener.getClass() : (Class)listener;
        Method[] methods = clazz.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            Method currentMethod = methods[i];
            if (!currentMethod.isAnnotationPresent(CustomEventSubscribe.class)) continue;
            if (currentMethod.getParameterTypes().length > 1) {
                log.catching((Throwable)new IllegalArgumentException("An CustomEventSubScribed Method Can't have more than one Parameter!"));
            }
            if (!EventType.class.isAssignableFrom(currentMethod.getParameterTypes()[0])) {
                log.catching((Throwable)new IllegalArgumentException("The Parameter isn't an EventType!"));
            }
            CustomEventSubscribe annotation = currentMethod.getAnnotation(CustomEventSubscribe.class);
            Class<?> methodEventType = currentMethod.getParameterTypes()[0];
            this.getCallHandlerFromEventType(methodEventType).RegisterEventListener(annotation.eventPriority(), listener, currentMethod);
        }
    }

    public void RegisterEventListners(List<Object> listenersList) {
        for (int i = 0; i < listenersList.size(); ++i) {
            this.RegisterEventListener(listenersList.get(i));
        }
    }

    public void removeEventListener(Object Listener) {
        Class clazz = !(Listener instanceof Class) ? Listener.getClass() : (Class)Listener;
        Method[] methodArray = clazz.getMethods();
        for (int i = 0; i < methodArray.length; ++i) {
            Method currentMethod = methodArray[i];
            if (!currentMethod.isAnnotationPresent(CustomEventSubscribe.class)) continue;
            if (currentMethod.getParameterTypes().length > 1) {
                log.catching((Throwable)new IllegalArgumentException("An CustomEventSubScribed Method Can't have more than one Parameter!"));
            }
            if (Listener instanceof Class && !Modifier.isStatic(currentMethod.getModifiers())) {
                log.catching((Throwable)new IllegalArgumentException("An CustomEventSubScribed Method Can't be non-static if you register an Class Object!"));
            }
            if (!EventType.class.isAssignableFrom(currentMethod.getParameterTypes()[0])) {
                log.catching((Throwable)new IllegalArgumentException("The Parameter of a CustomEventSubscribed method isn't an EventType!"));
            }
            CustomEventSubscribe annotation = currentMethod.getAnnotation(CustomEventSubscribe.class);
            Class<?> methodEventType = currentMethod.getParameterTypes()[0];
            this.getCallHandlerFromEventType(methodEventType).removeListener(annotation.eventPriority(), Listener);
        }
    }

    public void removeEventListeners(List<Object> listenersList) {
        for (int i = 0; i < listenersList.size(); ++i) {
            this.removeEventListener(listenersList.get(i));
        }
    }

    public CallHandler getCallHandlerFromEventType(Class<? extends EventType> eventTypeClass) {
        if (!this.EventList.containsKey(eventTypeClass)) {
            this.EventList.put(eventTypeClass, new EventApiCallHandler(eventTypeClass));
        }
        return this.EventList.get(eventTypeClass);
    }
}

