/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.creativecore.common.packet;

import com.creativemd.creativecore.common.container.ContainerSub;
import com.creativemd.creativecore.common.container.SubContainer;
import com.creativemd.creativecore.common.gui.CustomGuiHandler;
import com.creativemd.creativecore.common.gui.GuiContainerSub;
import com.creativemd.creativecore.common.gui.GuiHandler;
import com.creativemd.creativecore.common.gui.SubGui;
import com.creativemd.creativecore.common.packet.CreativeCorePacket;
import com.creativemd.creativecore.common.packet.PacketHandler;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;

public class OpenGuiPacket
extends CreativeCorePacket {
    public String name;
    public NBTTagCompound nbt;

    public OpenGuiPacket() {
    }

    public OpenGuiPacket(String name, NBTTagCompound nbt) {
        this.name = name;
        this.nbt = nbt;
    }

    @Override
    public void writeBytes(ByteBuf buf) {
        OpenGuiPacket.writeString(buf, this.name);
        OpenGuiPacket.writeNBT(buf, this.nbt);
    }

    @Override
    public void readBytes(ByteBuf buf) {
        this.name = OpenGuiPacket.readString(buf);
        this.nbt = OpenGuiPacket.readNBT(buf);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void executeClient(EntityPlayer player) {
        CustomGuiHandler handler = GuiHandler.getHandler(this.name);
        if (handler != null) {
            SubGui gui = handler.getGui(player, this.nbt);
            SubContainer container = handler.getContainer(player, this.nbt);
            if (gui != null && container != null) {
                FMLCommonHandler.instance().showGuiScreen((Object)new GuiContainerSub(player, gui, container));
            }
        }
    }

    @Override
    public void executeServer(EntityPlayer player) {
        SubContainer container;
        PacketHandler.sendPacketToPlayer(this, (EntityPlayerMP)player);
        CustomGuiHandler handler = GuiHandler.getHandler(this.name);
        if (handler != null && (container = handler.getContainer(player, this.nbt)) != null) {
            OpenGuiPacket.openContainerOnServer((EntityPlayerMP)player, new ContainerSub(player, container));
        }
    }
}

