/*
 * Decompiled with CFR 0.152.
 */
package remoteio.common.network;

import io.netty.buffer.ByteBuf;
import java.io.IOException;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTSizeTracker;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PlayerManager;
import net.minecraft.server.management.ServerConfigurationManager;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;

public class VanillaPacketHelper {
    public static void writeNBTTagCompoundToBuffer(ByteBuf byteBuf, NBTTagCompound nbtTagCompound) throws IOException {
        if (nbtTagCompound == null) {
            byteBuf.writeShort(-1);
        } else {
            byte[] abyte = CompressedStreamTools.func_74798_a((NBTTagCompound)nbtTagCompound);
            byteBuf.writeShort((int)((short)abyte.length));
            byteBuf.writeBytes(abyte);
        }
    }

    public static NBTTagCompound readNBTTagCompoundFromBuffer(ByteBuf byteBuf) throws IOException {
        short short1 = byteBuf.readShort();
        if (short1 < 0) {
            return null;
        }
        byte[] abyte = new byte[short1];
        byteBuf.readBytes(abyte);
        return CompressedStreamTools.func_152457_a((byte[])abyte, (NBTSizeTracker)new NBTSizeTracker(0x200000L));
    }

    public static void writeItemStackToBuffer(ByteBuf byteBuf, ItemStack itemStack) throws IOException {
        if (itemStack == null) {
            byteBuf.writeShort(-1);
        } else {
            byteBuf.writeShort(Item.func_150891_b((Item)itemStack.func_77973_b()));
            byteBuf.writeByte(itemStack.field_77994_a);
            byteBuf.writeShort(itemStack.func_77960_j());
            NBTTagCompound nbttagcompound = null;
            if (itemStack.func_77973_b().func_77645_m() || itemStack.func_77973_b().func_77651_p()) {
                nbttagcompound = itemStack.field_77990_d;
            }
            VanillaPacketHelper.writeNBTTagCompoundToBuffer(byteBuf, nbttagcompound);
        }
    }

    public static ItemStack readItemStackFromBuffer(ByteBuf byteBuf) throws IOException {
        ItemStack itemstack = null;
        short short1 = byteBuf.readShort();
        if (short1 >= 0) {
            byte b0 = byteBuf.readByte();
            short short2 = byteBuf.readShort();
            itemstack = new ItemStack(Item.func_150899_d((int)short1), (int)b0, (int)short2);
            itemstack.field_77990_d = VanillaPacketHelper.readNBTTagCompoundFromBuffer(byteBuf);
        }
        return itemstack;
    }

    public static void sendToAllWatchingTile(TileEntity tile, Packet packet) {
        if (!tile.func_145830_o()) {
            return;
        }
        VanillaPacketHelper.sendToAllWatchingChunk(tile.func_145831_w().func_72938_d(tile.field_145851_c, tile.field_145849_e), packet);
    }

    public static void sendToAllWatchingChunk(Chunk chunk, Packet packet) {
        ServerConfigurationManager manager = MinecraftServer.func_71276_C().func_71203_ab();
        World world = chunk.field_76637_e;
        if (world instanceof WorldServer) {
            PlayerManager playerManager = ((WorldServer)world).func_73040_p();
            for (Object obj : manager.field_72404_b) {
                EntityPlayerMP player = (EntityPlayerMP)obj;
                if (!playerManager.func_72694_a(player, chunk.field_76635_g, chunk.field_76647_h)) continue;
                player.field_71135_a.func_147359_a(packet);
            }
        }
    }

    public static void sendToAllInDimension(int dimension, Packet packet) {
        ServerConfigurationManager manager = MinecraftServer.func_71276_C().func_71203_ab();
        for (Object obj : manager.field_72404_b) {
            EntityPlayerMP player = (EntityPlayerMP)obj;
            if (player.func_130014_f_().field_73011_w.field_76574_g != dimension) continue;
            player.field_71135_a.func_147359_a(packet);
        }
    }

    public static void sendToAllInRange(int dimension, int x, int y, int z, int range, Packet packet) {
        ServerConfigurationManager manager = MinecraftServer.func_71276_C().func_71203_ab();
        for (Object obj : manager.field_72404_b) {
            EntityPlayerMP player = (EntityPlayerMP)obj;
            if (player.func_130014_f_().field_73011_w.field_76574_g != dimension || !(player.func_70011_f((double)x, (double)y, (double)z) <= (double)range)) continue;
            player.field_71135_a.func_147359_a(packet);
        }
    }
}

