/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.pipes;

import logisticspipes.LogisticsPipes;
import logisticspipes.interfaces.routing.IFluidSink;
import logisticspipes.pipes.basic.fluid.FluidRoutedPipe;
import logisticspipes.textures.Textures;
import logisticspipes.transport.PipeFluidTransportLogistics;
import logisticspipes.utils.FluidIdentifier;
import logisticspipes.utils.PlayerCollectionList;
import logisticspipes.utils.item.ItemIdentifierInventory;
import logisticspipes.utils.tuples.Pair;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.fluids.IFluidTank;

public class PipeFluidBasic
extends FluidRoutedPipe
implements IFluidSink {
    public ItemIdentifierInventory filterInv = new ItemIdentifierInventory(1, "Dummy", 1, true);
    private final PlayerCollectionList guiOpenedBy = new PlayerCollectionList();

    public PipeFluidBasic(Item item) {
        super(item);
    }

    @Override
    public Textures.TextureType getCenterTexture() {
        return Textures.LOGISTICSPIPE_LIQUID_BASIC;
    }

    @Override
    public boolean canInsertFromSideToTanks() {
        return true;
    }

    @Override
    public void onWrenchClicked(EntityPlayer entityplayer) {
        entityplayer.openGui((Object)LogisticsPipes.instance, 37, this.getWorld(), this.getX(), this.getY(), this.getZ());
    }

    @Override
    public int sinkAmount(FluidStack stack) {
        if (!this.guiOpenedBy.isEmpty()) {
            return 0;
        }
        FluidIdentifier ident = FluidIdentifier.get(stack);
        if (this.filterInv.func_70301_a(0) == null) {
            return 0;
        }
        if (!ident.equals(FluidIdentifier.get(this.filterInv.getIDStackInSlot(0).getItem()))) {
            return 0;
        }
        int onTheWay = this.countOnRoute(ident);
        int freeSpace = -onTheWay;
        for (Pair<TileEntity, ForgeDirection> pair : this.getAdjacentTanks(true)) {
            FluidTank tank = ((PipeFluidTransportLogistics)this.transport).sideTanks[pair.getValue2().ordinal()];
            freeSpace += ident.getFreeSpaceInsideTank((IFluidHandler)pair.getValue1(), pair.getValue2().getOpposite());
            if ((freeSpace += ident.getFreeSpaceInsideTank((IFluidTank)tank)) < stack.amount) continue;
            return stack.amount;
        }
        return freeSpace;
    }

    @Override
    public void writeToNBT(NBTTagCompound nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        this.filterInv.writeToNBT(nbttagcompound);
    }

    @Override
    public void readFromNBT(NBTTagCompound nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        this.filterInv.readFromNBT(nbttagcompound);
    }

    @Override
    public boolean canInsertToTanks() {
        return true;
    }

    public void guiOpenedByPlayer(EntityPlayer player) {
        this.guiOpenedBy.add(player);
    }

    public void guiClosedByPlayer(EntityPlayer player) {
        this.guiOpenedBy.remove(player);
    }

    @Override
    public boolean canReceiveFluid() {
        return false;
    }
}

