/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.alchemicalWizardry.common.summoning.meteor;

import WayofTime.alchemicalWizardry.AlchemicalWizardry;
import WayofTime.alchemicalWizardry.common.summoning.meteor.MeteorParadigmComponent;
import cpw.mods.fml.common.Optional;
import gregtech.common.blocks.GT_TileEntity_Ores;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class MeteorParadigm {
    public List<MeteorParadigmComponent> componentList = new ArrayList<MeteorParadigmComponent>();
    public ItemStack focusStack;
    public int radius;
    public int cost;
    public static Random rand = new Random();

    public MeteorParadigm(ItemStack focusStack, int radius, int cost) {
        this.focusStack = focusStack;
        this.radius = radius;
        this.cost = cost;
    }

    public void parseStringArray(String[] oreArray) {
        int i = 0;
        while (i + 1 < oreArray.length) {
            String oreName = oreArray[i];
            int oreChance = Integer.parseInt(oreArray[i + 1]);
            MeteorParadigmComponent mpc = new MeteorParadigmComponent(oreName, oreChance);
            this.componentList.add(mpc);
            i += 2;
        }
    }

    public int getTotalMeteorWeight() {
        int totalMeteorWeight = 0;
        for (MeteorParadigmComponent mpc : this.componentList) {
            if (mpc == null || !mpc.isValidBlockParadigm()) continue;
            totalMeteorWeight += mpc.getChance();
        }
        return totalMeteorWeight;
    }

    public void createMeteorImpact(World world, int x, int y, int z, boolean[] flags) {
        boolean hasTerrae = false;
        boolean hasOrbisTerrae = false;
        boolean hasCrystallos = false;
        boolean hasIncendium = false;
        boolean hasTennebrae = false;
        if (flags != null && flags.length >= 5) {
            hasTerrae = flags[0];
            hasOrbisTerrae = flags[1];
            hasCrystallos = flags[2];
            hasIncendium = flags[3];
            hasTennebrae = flags[4];
        }
        int newRadius = this.radius;
        if (hasOrbisTerrae) {
            newRadius += 2;
        } else if (hasTerrae) {
            ++newRadius;
        }
        world.func_72876_a(null, (double)x, (double)y, (double)z, (float)(newRadius * 4), AlchemicalWizardry.doMeteorsDestroyBlocks);
        float iceChance = hasCrystallos ? 1.0f : 0.0f;
        float soulChance = hasIncendium ? 1.0f : 0.0f;
        float obsidChance = hasTennebrae ? 1.0f : 0.0f;
        float totalChance = iceChance + soulChance + obsidChance;
        int totalMeteorWeight = this.getTotalMeteorWeight();
        for (int i = -newRadius; i <= newRadius; ++i) {
            for (int j = -newRadius; j <= newRadius; ++j) {
                for (int k = -newRadius; k <= newRadius; ++k) {
                    if ((float)(i * i + j * j + k * k) >= ((float)newRadius + 0.5f) * ((float)newRadius + 0.5f) || !world.func_147437_c(x + i, y + j, z + k)) continue;
                    int randNum = world.field_73012_v.nextInt(totalMeteorWeight);
                    boolean hasPlacedBlock = false;
                    for (MeteorParadigmComponent mpc : this.componentList) {
                        ItemStack blockStack;
                        if (mpc == null || !mpc.isValidBlockParadigm() || (randNum -= mpc.getChance()) >= 0 || (blockStack = mpc.getValidBlockParadigm()) == null || !(blockStack.func_77973_b() instanceof ItemBlock)) continue;
                        ((ItemBlock)blockStack.func_77973_b()).placeBlockAt(blockStack, null, world, x + i, y + j, z + k, 0, 0.0f, 0.0f, 0.0f, blockStack.func_77960_j());
                        if (AlchemicalWizardry.isGregTechLoaded) {
                            MeteorParadigm.setGTOresNaturalIfNeeded(world, x + i, y + j, z + k);
                        }
                        world.func_147471_g(x + i, y + j, z + k);
                        hasPlacedBlock = true;
                        break;
                    }
                    if (hasPlacedBlock) continue;
                    float randChance = rand.nextFloat() * totalChance;
                    if (randChance < iceChance) {
                        world.func_147465_d(x + i, y + j, z + k, Blocks.field_150432_aD, 0, 3);
                        continue;
                    }
                    if ((randChance -= iceChance) < soulChance) {
                        switch (rand.nextInt(3)) {
                            case 0: {
                                world.func_147465_d(x + i, y + j, z + k, Blocks.field_150425_aM, 0, 3);
                                break;
                            }
                            case 1: {
                                world.func_147465_d(x + i, y + j, z + k, Blocks.field_150426_aN, 0, 3);
                                break;
                            }
                            case 2: {
                                world.func_147465_d(x + i, y + j, z + k, Blocks.field_150424_aL, 0, 3);
                            }
                        }
                        continue;
                    }
                    if ((randChance -= soulChance) < obsidChance) {
                        world.func_147465_d(x + i, y + j, z + k, Blocks.field_150343_Z, 0, 3);
                        continue;
                    }
                    randChance -= obsidChance;
                    world.func_147465_d(x + i, y + j, z + k, Blocks.field_150348_b, 0, 3);
                }
            }
        }
    }

    @Optional.Method(modid="gregtech")
    private static void setGTOresNaturalIfNeeded(World world, int x, int y, int z) {
        TileEntity tileEntity = world.func_147438_o(x, y, z);
        if (tileEntity instanceof GT_TileEntity_Ores) {
            ((GT_TileEntity_Ores)tileEntity).mNatural = true;
        }
    }
}

