/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.robotics.ai;

import buildcraft.api.core.BlockIndex;
import buildcraft.api.core.BuildCraftAPI;
import buildcraft.api.robots.EntityRobotBase;
import buildcraft.core.lib.utils.IterableAlgorithmRunner;
import buildcraft.core.lib.utils.PathFinding;
import buildcraft.robotics.ai.AIRobotGoto;
import java.util.LinkedList;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class AIRobotGotoBlock
extends AIRobotGoto {
    private PathFinding pathSearch;
    private IterableAlgorithmRunner pathSearchJob;
    private LinkedList<BlockIndex> path;
    private double prevDistance = Double.MAX_VALUE;
    private float finalX;
    private float finalY;
    private float finalZ;
    private double maxDistance = 0.0;
    private BlockIndex lastBlockInPath;
    private boolean loadedFromNBT;

    public AIRobotGotoBlock(EntityRobotBase iRobot) {
        super(iRobot);
    }

    public AIRobotGotoBlock(EntityRobotBase robot, int x, int y, int z) {
        this(robot);
        this.finalX = x;
        this.finalY = y;
        this.finalZ = z;
    }

    public AIRobotGotoBlock(EntityRobotBase robot, int x, int y, int z, double iMaxDistance) {
        this(robot, x, y, z);
        this.maxDistance = iMaxDistance;
    }

    public AIRobotGotoBlock(EntityRobotBase robot, LinkedList<BlockIndex> iPath) {
        this(robot);
        this.path = iPath;
        this.finalX = this.path.getLast().x;
        this.finalY = this.path.getLast().y;
        this.finalZ = this.path.getLast().z;
        this.setNextInPath();
    }

    @Override
    public void start() {
        this.robot.undock();
    }

    @Override
    public void update() {
        if (this.loadedFromNBT) {
            this.setNextInPath();
            this.loadedFromNBT = false;
        }
        if (this.path == null && this.pathSearch == null) {
            this.pathSearch = new PathFinding(this.robot.field_70170_p, new BlockIndex((int)Math.floor(this.robot.field_70165_t), (int)Math.floor(this.robot.field_70163_u), (int)Math.floor(this.robot.field_70161_v)), new BlockIndex((int)Math.floor(this.finalX), (int)Math.floor(this.finalY), (int)Math.floor(this.finalZ)), this.maxDistance, 96.0f);
            this.pathSearchJob = new IterableAlgorithmRunner(this.pathSearch, 50);
            this.pathSearchJob.start();
        } else if (this.path != null) {
            double distance = this.robot.func_70011_f(this.nextX, this.nextY, this.nextZ);
            if (!this.robot.isMoving() || distance > this.prevDistance) {
                if (this.path.size() > 0) {
                    this.path.removeFirst();
                }
                this.setNextInPath();
            } else {
                this.prevDistance = this.robot.func_70011_f(this.nextX, this.nextY, this.nextZ);
            }
        } else if (this.pathSearchJob.isDone()) {
            this.path = this.pathSearch.getResult();
            if (this.path.size() == 0) {
                this.setSuccess(false);
                this.terminate();
                return;
            }
            this.lastBlockInPath = this.path.getLast();
            this.setNextInPath();
        }
        if (this.path != null && this.path.size() == 0) {
            this.robot.field_70159_w = 0.0;
            this.robot.field_70181_x = 0.0;
            this.robot.field_70179_y = 0.0;
            if (this.lastBlockInPath != null) {
                this.robot.field_70165_t = (float)this.lastBlockInPath.x + 0.5f;
                this.robot.field_70163_u = (float)this.lastBlockInPath.y + 0.5f;
                this.robot.field_70161_v = (float)this.lastBlockInPath.z + 0.5f;
            }
            this.terminate();
        }
    }

    private void setNextInPath() {
        if (this.path.size() > 0) {
            boolean isFirst = this.prevDistance == Double.MAX_VALUE;
            BlockIndex next = this.path.getFirst();
            this.prevDistance = Double.MAX_VALUE;
            if (isFirst || BuildCraftAPI.isSoftBlock(this.robot.field_70170_p, next.x, next.y, next.z)) {
                this.setDestination(this.robot, (float)next.x + 0.5f, (float)next.y + 0.5f, (float)next.z + 0.5f);
                this.robot.aimItemAt(next.x, next.y, next.z);
            } else {
                this.path = null;
                if (this.pathSearchJob != null) {
                    this.pathSearchJob.terminate();
                    this.robot.field_70159_w = 0.0;
                    this.robot.field_70181_x = 0.0;
                    this.robot.field_70179_y = 0.0;
                }
            }
        }
    }

    @Override
    public void end() {
        if (this.pathSearchJob != null) {
            this.pathSearchJob.terminate();
            this.robot.field_70159_w = 0.0;
            this.robot.field_70181_x = 0.0;
            this.robot.field_70179_y = 0.0;
        }
    }

    @Override
    public boolean canLoadFromNBT() {
        return true;
    }

    @Override
    public void writeSelfToNBT(NBTTagCompound nbt) {
        super.writeSelfToNBT(nbt);
        nbt.func_74776_a("finalX", this.finalX);
        nbt.func_74776_a("finalY", this.finalY);
        nbt.func_74776_a("finalZ", this.finalZ);
        nbt.func_74780_a("maxDistance", this.maxDistance);
        if (this.path != null) {
            NBTTagList pathList = new NBTTagList();
            for (BlockIndex i : this.path) {
                NBTTagCompound subNBT = new NBTTagCompound();
                i.writeTo(subNBT);
                pathList.func_74742_a((NBTBase)subNBT);
            }
            nbt.func_74782_a("path", (NBTBase)pathList);
        }
    }

    @Override
    public void loadSelfFromNBT(NBTTagCompound nbt) {
        super.loadSelfFromNBT(nbt);
        this.finalX = nbt.func_74760_g("finalX");
        this.finalY = nbt.func_74760_g("finalY");
        this.finalZ = nbt.func_74760_g("finalZ");
        this.maxDistance = nbt.func_74769_h("maxDistance");
        if (nbt.func_74764_b("path")) {
            NBTTagList pathList = nbt.func_150295_c("path", 10);
            this.path = new LinkedList();
            for (int i = 0; i < pathList.func_74745_c(); ++i) {
                this.path.add(new BlockIndex(pathList.func_150305_b(i)));
            }
        }
        this.loadedFromNBT = true;
    }
}

