/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizon.mixinextras.injector;

import com.gtnewhorizon.mixinextras.utils.CompatibilityHelper;
import com.gtnewhorizon.mixinextras.utils.InjectorUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.spongepowered.asm.lib.Type;
import org.spongepowered.asm.lib.tree.AbstractInsnNode;
import org.spongepowered.asm.lib.tree.FieldInsnNode;
import org.spongepowered.asm.lib.tree.InsnList;
import org.spongepowered.asm.lib.tree.MethodInsnNode;
import org.spongepowered.asm.lib.tree.VarInsnNode;
import org.spongepowered.asm.mixin.injection.code.Injector;
import org.spongepowered.asm.mixin.injection.struct.InjectionInfo;
import org.spongepowered.asm.mixin.injection.struct.InjectionNodes;
import org.spongepowered.asm.mixin.injection.struct.Target;

public class ModifyReceiverInjector
extends Injector {
    public ModifyReceiverInjector(InjectionInfo info) {
        super(info, "@ModifyReceiver");
    }

    @Override
    protected void inject(Target target, InjectionNodes.InjectionNode node) {
        this.checkTargetIsValid(target, node);
        this.checkTargetModifiers(target, false);
        this.modifyReceiverOfTarget(target, node);
    }

    private void checkTargetIsValid(Target target, InjectionNodes.InjectionNode node) {
        AbstractInsnNode insn = node.getOriginalTarget();
        switch (insn.getOpcode()) {
            case 180: 
            case 181: 
            case 182: 
            case 183: 
            case 185: {
                return;
            }
        }
        throw CompatibilityHelper.makeInvalidInjectionException(this.info, String.format("%s annotation is targeting an invalid insn in %s in %s", this.annotationType, target, this));
    }

    private void modifyReceiverOfTarget(Target target, InjectionNodes.InjectionNode node) {
        AbstractInsnNode currentTarget = node.getCurrentTarget();
        Type[] originalArgTypes = this.getEffectiveArgTypes(node.getOriginalTarget());
        Type[] currentArgTypes = this.getEffectiveArgTypes(currentTarget);
        InsnList insns = new InsnList();
        boolean isVirtualRedirect = InjectorUtils.isVirtualRedirect(node);
        this.injectReceiverModifier(target, originalArgTypes, currentArgTypes, isVirtualRedirect, insns);
        target.insertBefore(node, insns);
    }

    private void injectReceiverModifier(Target target, Type[] originalArgTypes, Type[] currentArgTypes, boolean isVirtualRedirect, InsnList insns) {
        Injector.InjectorData handler = new Injector.InjectorData(target, "receiver modifier");
        this.validateParams(handler, originalArgTypes[0], originalArgTypes);
        int[] argMap = this.storeArgs(target, currentArgTypes, insns, 0);
        int[] handlerArgMap = ArrayUtils.addAll((int[])argMap, (int[])target.getArgIndices());
        if (isVirtualRedirect) {
            handlerArgMap = ArrayUtils.remove((int[])handlerArgMap, (int)0);
            insns.add(new VarInsnNode(25, 0));
        }
        this.invokeHandlerWithArgs(this.methodArgs, insns, handlerArgMap);
        this.pushArgs(currentArgTypes, insns, argMap, isVirtualRedirect ? 2 : 1, argMap.length);
    }

    private Type[] getEffectiveArgTypes(AbstractInsnNode node) {
        switch (node.getOpcode()) {
            case 182: 
            case 183: 
            case 185: {
                MethodInsnNode methodInsnNode = (MethodInsnNode)node;
                return (Type[])ArrayUtils.addAll((Object[])new Type[]{Type.getObjectType(methodInsnNode.owner)}, (Object[])Type.getArgumentTypes(methodInsnNode.desc));
            }
            case 180: {
                FieldInsnNode fieldInsnNode = (FieldInsnNode)node;
                return new Type[]{Type.getObjectType(fieldInsnNode.owner)};
            }
            case 181: {
                FieldInsnNode fieldInsnNode = (FieldInsnNode)node;
                return new Type[]{Type.getObjectType(fieldInsnNode.owner), Type.getType(fieldInsnNode.desc)};
            }
        }
        throw new UnsupportedOperationException();
    }
}

