/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.logic;

import forestry.api.farming.FarmDirection;
import forestry.api.farming.IFarmHousing;
import forestry.core.fluids.Fluids;
import forestry.core.utils.BlockUtil;
import forestry.core.utils.ItemStackUtil;
import forestry.core.utils.vect.Vect;
import forestry.core.utils.vect.VectUtil;
import forestry.farming.FarmHelper;
import forestry.farming.logic.FarmLogic;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;

public abstract class FarmLogicWatered
extends FarmLogic {
    protected final ItemStack ground;
    private final ItemStack resource;
    private static final FluidStack STACK_WATER = Fluids.WATER.getFluid(1000);
    List<ItemStack> produce = new ArrayList<ItemStack>();

    protected FarmLogicWatered(IFarmHousing housing, ItemStack resource, ItemStack ground) {
        super(housing);
        this.ground = ground;
        this.resource = resource;
    }

    @Override
    public int getFertilizerConsumption() {
        return 5;
    }

    @Override
    public int getWaterConsumption(float hydrationModifier) {
        return (int)(20.0f * hydrationModifier);
    }

    protected boolean isAcceptedGround(ItemStack ground) {
        return ItemStackUtil.isIdenticalItem(this.ground, ground);
    }

    @Override
    public boolean isAcceptedResource(ItemStack itemstack) {
        return this.resource.func_77969_a(itemstack);
    }

    @Override
    public Collection<ItemStack> collect() {
        List<ItemStack> products = this.produce;
        this.produce = new ArrayList<ItemStack>();
        return products;
    }

    @Override
    public boolean cultivate(int x, int y, int z, FarmDirection direction, int extent) {
        if (this.maintainSoil(x, y, z, direction, extent)) {
            return true;
        }
        if (!this.isManual && this.maintainWater(x, y, z, direction, extent)) {
            return true;
        }
        return this.maintainCrops(x, y + 1, z, direction, extent);
    }

    private boolean maintainSoil(int x, int y, int z, FarmDirection direction, int extent) {
        World world = this.getWorld();
        ItemStack[] resources = new ItemStack[]{this.resource};
        for (int i = 0; i < extent; ++i) {
            Vect position = this.translateWithOffset(x, y, z, direction, i);
            Block soil = VectUtil.getBlock(world, position);
            ItemStack soilStack = VectUtil.getAsItemStack(world, position);
            if (this.isAcceptedGround(soilStack) || !this.housing.getFarmInventory().hasResources(resources)) continue;
            Vect platformPosition = position.add(0, -1, 0);
            Block platformBlock = VectUtil.getBlock(world, platformPosition);
            if (!FarmHelper.bricks.contains((Object)platformBlock)) break;
            if (!this.isAirBlock(soil) && !BlockUtil.isReplaceableBlock(soil)) {
                this.produce.addAll(BlockUtil.getBlockDrops(this.getWorld(), position));
                this.setBlock(position, Blocks.field_150350_a, 0);
                return this.trySetSoil(position);
            }
            if (this.isManual || this.isWaterSourceBlock(world, position)) continue;
            if (this.trySetWater(world, position)) {
                return true;
            }
            return this.trySetSoil(position);
        }
        return false;
    }

    private boolean maintainWater(int x, int y, int z, FarmDirection direction, int extent) {
        Vect position;
        Vect platformPosition;
        Block platformBlock;
        World world = this.getWorld();
        for (int i = 0; i < extent && FarmHelper.bricks.contains((Object)(platformBlock = VectUtil.getBlock(world, platformPosition = (position = this.translateWithOffset(x, y, z, direction, i)).add(0, -1, 0)))); ++i) {
            if (!this.trySetWater(world, position)) continue;
            return true;
        }
        return false;
    }

    protected boolean maintainCrops(int x, int y, int z, FarmDirection direction, int extent) {
        return false;
    }

    private boolean trySetSoil(Vect position) {
        ItemStack[] resources = new ItemStack[]{this.resource};
        if (!this.housing.getFarmInventory().hasResources(resources)) {
            return false;
        }
        this.setBlock(position, ItemStackUtil.getBlock(this.ground), this.ground.func_77960_j());
        this.housing.getFarmInventory().removeResources(resources);
        return true;
    }

    private boolean trySetWater(World world, Vect position) {
        if (this.isWaterSourceBlock(world, position) || !this.canPlaceWater(world, position)) {
            return false;
        }
        if (!this.housing.hasLiquid(STACK_WATER)) {
            return false;
        }
        this.produce.addAll(BlockUtil.getBlockDrops(world, position));
        this.setBlock(position, Blocks.field_150355_j, 0);
        this.housing.removeLiquid(STACK_WATER);
        return true;
    }

    private boolean canPlaceWater(World world, Vect position) {
        int x;
        for (x = -2; x <= 2; ++x) {
            for (int z = -2; z <= 2; ++z) {
                Vect offsetPosition = position.add(x, 0, z);
                if (!this.isWaterSourceBlock(world, offsetPosition)) continue;
                return false;
            }
        }
        for (x = -1; x <= 1; ++x) {
            Vect offsetPosition = position.add(x, 0, 0);
            if (!VectUtil.isAirBlock(world, offsetPosition)) continue;
            return false;
        }
        for (int z = -1; z <= 1; ++z) {
            Vect offsetPosition = position.add(0, 0, z);
            if (!VectUtil.isAirBlock(world, offsetPosition)) continue;
            return false;
        }
        return true;
    }
}

