/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.utils;

import cofh.api.energy.IEnergyConnection;
import cofh.api.energy.IEnergyReceiver;
import cpw.mods.fml.common.Loader;
import forestry.core.tiles.TileEngine;
import forestry.core.utils.vect.Vect;
import java.util.ArrayList;
import java.util.function.Predicate;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCocoa;
import net.minecraft.block.BlockLog;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.oredict.OreDictionary;

public abstract class BlockUtil {
    private static final int slabWoodId = OreDictionary.getOreID((String)"slabWood");
    private static Class<? extends Block> BW_MetaGenerated_WerkstoffBlocksClass;
    private static Block BWBlocks;
    private static Class<? extends Block> GTBlockMachines_Class;
    private static Block GTBlockMachines;
    private static final boolean bw;
    private static final boolean gt;

    public static ArrayList<ItemStack> getBlockDrops(World world, Vect posBlock) {
        Block block = world.func_147439_a(posBlock.x, posBlock.y, posBlock.z);
        int meta = world.func_72805_g(posBlock.x, posBlock.y, posBlock.z);
        return block.getDrops(world, posBlock.x, posBlock.y, posBlock.z, meta, 0);
    }

    public static boolean isEnergyReceiverOrEngine(ForgeDirection side, TileEntity tile) {
        if (!(tile instanceof IEnergyReceiver) && !(tile instanceof TileEngine)) {
            return false;
        }
        IEnergyConnection receptor = (IEnergyConnection)tile;
        return receptor.canConnectEnergy(side);
    }

    public static boolean tryPlantPot(World world, int x, int y, int z, Block block) {
        int direction = BlockUtil.getDirectionalMetadata(world, x, y, z);
        if (direction < 0) {
            return false;
        }
        world.func_147465_d(x, y, z, block, direction, 3);
        return true;
    }

    public static int getDirectionalMetadata(World world, int x, int y, int z) {
        for (int i = 0; i < 4; ++i) {
            if (!BlockUtil.isValidPot(world, x, y, z, i)) continue;
            return i;
        }
        return -1;
    }

    public static boolean isValidPot(World world, int x, int y, int z, int notchDirection) {
        Block block = world.func_147439_a(x += Direction.field_71583_a[notchDirection], y, z += Direction.field_71581_b[notchDirection]);
        if (block == Blocks.field_150364_r) {
            return BlockLog.func_150165_c((int)world.func_72805_g(x, y, z)) == 3;
        }
        return block.isWood((IBlockAccess)world, x, y, z);
    }

    public static int getMaturityPod(int metadata) {
        return BlockCocoa.func_149987_c((int)metadata);
    }

    public static boolean isWoodSlabBlock(Block block) {
        int[] oreIds;
        for (int oreId : oreIds = OreDictionary.getOreIDs((ItemStack)new ItemStack(block))) {
            if (oreId != slabWoodId) continue;
            return true;
        }
        return false;
    }

    public static boolean isReplaceableBlock(World world, int x, int y, int z) {
        Block block = world.func_147439_a(x, y, z);
        return BlockUtil.isReplaceableBlock(block);
    }

    public static boolean isReplaceableBlock(Block block) {
        return block == Blocks.field_150395_bd || block == Blocks.field_150329_H || block == Blocks.field_150330_I || block == Blocks.field_150431_aC || block.func_149688_o().func_76222_j();
    }

    public static MovingObjectPosition collisionRayTrace(World world, int x, int y, int z, Vec3 startVec, Vec3 endVec, float minX, float minY, float minZ, float maxX, float maxY, float maxZ) {
        startVec = startVec.func_72441_c((double)(-x), (double)(-y), (double)(-z));
        endVec = endVec.func_72441_c((double)(-x), (double)(-y), (double)(-z));
        Vec3 vec32 = startVec.func_72429_b(endVec, (double)minX);
        Vec3 vec33 = startVec.func_72429_b(endVec, (double)maxX);
        Vec3 vec34 = startVec.func_72435_c(endVec, (double)minY);
        Vec3 vec35 = startVec.func_72435_c(endVec, (double)maxY);
        Vec3 vec36 = startVec.func_72434_d(endVec, (double)minZ);
        Vec3 vec37 = startVec.func_72434_d(endVec, (double)maxZ);
        if (!BlockUtil.isVecInsideYZBounds(vec32, minY, minZ, maxY, maxZ)) {
            vec32 = null;
        }
        if (!BlockUtil.isVecInsideYZBounds(vec33, minY, minZ, maxY, maxZ)) {
            vec33 = null;
        }
        if (!BlockUtil.isVecInsideXZBounds(vec34, minX, minZ, maxX, maxZ)) {
            vec34 = null;
        }
        if (!BlockUtil.isVecInsideXZBounds(vec35, minX, minZ, maxX, maxZ)) {
            vec35 = null;
        }
        if (!BlockUtil.isVecInsideXYBounds(vec36, minX, minY, maxX, maxY)) {
            vec36 = null;
        }
        if (!BlockUtil.isVecInsideXYBounds(vec37, minX, minY, maxX, maxY)) {
            vec37 = null;
        }
        Vec3 minHit = null;
        if (vec32 != null && (minHit == null || startVec.func_72436_e(vec32) < startVec.func_72436_e(minHit))) {
            minHit = vec32;
        }
        if (vec33 != null && (minHit == null || startVec.func_72436_e(vec33) < startVec.func_72436_e(minHit))) {
            minHit = vec33;
        }
        if (vec34 != null && (minHit == null || startVec.func_72436_e(vec34) < startVec.func_72436_e(minHit))) {
            minHit = vec34;
        }
        if (vec35 != null && (minHit == null || startVec.func_72436_e(vec35) < startVec.func_72436_e(minHit))) {
            minHit = vec35;
        }
        if (vec36 != null && (minHit == null || startVec.func_72436_e(vec36) < startVec.func_72436_e(minHit))) {
            minHit = vec36;
        }
        if (vec37 != null && (minHit == null || startVec.func_72436_e(vec37) < startVec.func_72436_e(minHit))) {
            minHit = vec37;
        }
        if (minHit == null) {
            return null;
        }
        int sideHit = -1;
        if (minHit == vec32) {
            sideHit = 4;
        }
        if (minHit == vec33) {
            sideHit = 5;
        }
        if (minHit == vec34) {
            sideHit = 0;
        }
        if (minHit == vec35) {
            sideHit = 1;
        }
        if (minHit == vec36) {
            sideHit = 2;
        }
        if (minHit == vec37) {
            sideHit = 3;
        }
        return new MovingObjectPosition(x, y, z, sideHit, minHit.func_72441_c((double)x, (double)y, (double)z));
    }

    private static boolean isVecInsideYZBounds(Vec3 vec, float minY, float minZ, float maxY, float maxZ) {
        return vec != null && vec.field_72448_b >= (double)minY && vec.field_72448_b <= (double)maxY && vec.field_72449_c >= (double)minZ && vec.field_72449_c <= (double)maxZ;
    }

    private static boolean isVecInsideXZBounds(Vec3 vec, float minX, float minZ, float maxX, float maxZ) {
        return vec != null && vec.field_72450_a >= (double)minX && vec.field_72450_a <= (double)maxX && vec.field_72449_c >= (double)minZ && vec.field_72449_c <= (double)maxZ;
    }

    private static boolean isVecInsideXYBounds(Vec3 vec, float minX, float minY, float maxX, float maxY) {
        return vec != null && vec.field_72450_a >= (double)minX && vec.field_72450_a <= (double)maxX && vec.field_72448_b >= (double)minY && vec.field_72448_b <= (double)maxY;
    }

    public static ItemStack getItemStackFromBlockBelow(World world, int x, int y, int z, Predicate<TileEntity> stillInside) {
        TileEntity tile;
        int depth = 0;
        while (stillInside.test(tile = world.func_147438_o(x, y - ++depth, z))) {
        }
        Block block = world.func_147439_a(x, y - depth, z);
        if (bw && BW_MetaGenerated_WerkstoffBlocksClass.isInstance(block)) {
            return new ItemStack(BWBlocks, 1, block.func_149643_k(world, x, y - depth, z));
        }
        if (gt && GTBlockMachines_Class.isInstance(block)) {
            return new ItemStack(GTBlockMachines, 1, block.func_149643_k(world, x, y - depth, z));
        }
        return new ItemStack(block, 1, world.func_72805_g(x, y - depth, z));
    }

    static {
        bw = Loader.isModLoaded((String)"bartworks");
        gt = Loader.isModLoaded((String)"gregtech");
        if (bw) {
            try {
                BW_MetaGenerated_WerkstoffBlocksClass = Class.forName("com.github.bartimaeusnek.bartworks.system.material.BW_MetaGenerated_WerkstoffBlocks");
                BWBlocks = (Block)Class.forName("com.github.bartimaeusnek.bartworks.system.material.WerkstoffLoader").getField("BWBlocks").get(null);
            }
            catch (ClassNotFoundException | IllegalAccessException | NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        if (gt) {
            try {
                GTBlockMachines_Class = Class.forName("gregtech.common.blocks.GT_Block_Machines");
                GTBlockMachines = (Block)Class.forName("gregtech.api.GregTech_API").getField("sBlockMachines").get(null);
            }
            catch (ClassNotFoundException | IllegalAccessException | NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
    }
}

