/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.multiblock;

import forestry.api.multiblock.IMultiblockComponent;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraftforge.common.util.ForgeDirection;

public class MultiblockUtil {
    public static List<IMultiblockComponent> getNeighboringParts(World world, IMultiblockComponent part) {
        ChunkCoordinates partCoord = part.getCoordinates();
        ArrayList<ChunkCoordinates> neighbors = new ArrayList<ChunkCoordinates>(ForgeDirection.VALID_DIRECTIONS.length);
        for (ForgeDirection forgeDirection : ForgeDirection.VALID_DIRECTIONS) {
            ChunkCoordinates neighborCoord = new ChunkCoordinates(partCoord);
            neighborCoord.field_71574_a += forgeDirection.offsetX;
            neighborCoord.field_71572_b += forgeDirection.offsetY;
            neighborCoord.field_71573_c += forgeDirection.offsetZ;
            neighbors.add(neighborCoord);
        }
        ArrayList<IMultiblockComponent> neighborParts = new ArrayList<IMultiblockComponent>();
        IChunkProvider chunkProvider = world.func_72863_F();
        for (ChunkCoordinates neighbor : neighbors) {
            TileEntity te;
            if (!chunkProvider.func_73149_a(neighbor.field_71574_a >> 4, neighbor.field_71573_c >> 4) || !((te = world.func_147438_o(neighbor.field_71574_a, neighbor.field_71572_b, neighbor.field_71573_c)) instanceof IMultiblockComponent)) continue;
            neighborParts.add((IMultiblockComponent)te);
        }
        return neighborParts;
    }
}

