/*
 * Decompiled with CFR 0.152.
 */
package appeng.me;

import appeng.api.exceptions.ExistingConnectionException;
import appeng.api.exceptions.FailedConnection;
import appeng.api.exceptions.NullNodeConnectionException;
import appeng.api.exceptions.SecurityConnectionException;
import appeng.api.networking.GridFlags;
import appeng.api.networking.IGridConnection;
import appeng.api.networking.IGridNode;
import appeng.api.networking.events.MENetworkChannelsChanged;
import appeng.api.networking.pathing.IPathingGrid;
import appeng.api.util.DimensionalCoord;
import appeng.api.util.IReadOnlyCollection;
import appeng.core.AEConfig;
import appeng.core.AELog;
import appeng.core.features.AEFeature;
import appeng.me.GridException;
import appeng.me.GridNode;
import appeng.me.GridPropagator;
import appeng.me.pathfinding.IPathItem;
import appeng.util.Platform;
import appeng.util.ReadOnlyCollection;
import java.util.Arrays;
import java.util.EnumSet;
import net.minecraftforge.common.util.ForgeDirection;
import org.apache.logging.log4j.Level;

public class GridConnection
implements IGridConnection,
IPathItem {
    private static final String EXISTING_CONNECTION_MESSAGE = "Connection between node [machine=%s, %s] and [machine=%s, %s] on [%s] already exists.";
    private static final MENetworkChannelsChanged EVENT = new MENetworkChannelsChanged();
    private int channelData = 0;
    private Object visitorIterationNumber = null;
    private GridNode sideA;
    private ForgeDirection fromAtoB;
    private GridNode sideB;

    public GridConnection(IGridNode aNode, IGridNode bNode, ForgeDirection fromAtoB) throws FailedConnection {
        GridPropagator gp;
        GridNode a = (GridNode)aNode;
        GridNode b = (GridNode)bNode;
        if (Platform.securityCheck(a, b)) {
            if (AEConfig.instance.isFeatureEnabled(AEFeature.LogSecurityAudits)) {
                DimensionalCoord aCoordinates = a.getGridBlock().getLocation();
                DimensionalCoord bCoordinates = b.getGridBlock().getLocation();
                AELog.info("Security audit 1 failed at [%s] belonging to player [id=%d]", aCoordinates.toString(), a.getPlayerID());
                AELog.info("Security audit 2 failed at [%s] belonging to player [id=%d]", bCoordinates.toString(), b.getPlayerID());
            }
            throw new SecurityConnectionException();
        }
        if (a == null || b == null) {
            throw new NullNodeConnectionException();
        }
        if (a.hasConnection(b) || b.hasConnection(a)) {
            String aMachineClass = a.getGridBlock().getMachine().getClass().getSimpleName();
            String bMachineClass = b.getGridBlock().getMachine().getClass().getSimpleName();
            String aCoordinates = a.getGridBlock().getLocation().toString();
            String bCoordinates = b.getGridBlock().getLocation().toString();
            throw new ExistingConnectionException(String.format(EXISTING_CONNECTION_MESSAGE, aMachineClass, aCoordinates, bMachineClass, bCoordinates, fromAtoB));
        }
        this.sideA = a;
        this.fromAtoB = fromAtoB;
        this.sideB = b;
        if (b.getMyGrid() == null) {
            b.setGrid(a.getInternalGrid());
        } else if (a.getMyGrid() == null) {
            gp = new GridPropagator(b.getInternalGrid());
            a.beginVisit(gp);
        } else if (b.getMyGrid() == null) {
            gp = new GridPropagator(a.getInternalGrid());
            b.beginVisit(gp);
        } else if (this.isNetworkABetter(a, b)) {
            gp = new GridPropagator(a.getInternalGrid());
            b.beginVisit(gp);
        } else {
            gp = new GridPropagator(b.getInternalGrid());
            a.beginVisit(gp);
        }
        IPathingGrid p = (IPathingGrid)this.sideA.getInternalGrid().getCache(IPathingGrid.class);
        if (AEConfig.instance.debugPathFinding) {
            String aCoordinates = a.getGridBlock().getLocation().toString();
            String bCoordinates = b.getGridBlock().getLocation().toString();
            AELog.info("Repath is triggered by adding connection from [%s] to [%s]", aCoordinates, bCoordinates);
            AELog.printStackTrace(Level.INFO);
        }
        p.repath();
        this.sideA.addConnection(this);
        this.sideB.addConnection(this);
    }

    private boolean isNetworkABetter(GridNode a, GridNode b) {
        return a.getMyGrid().getPriority() > b.getMyGrid().getPriority() || a.getMyGrid().size() > b.getMyGrid().size();
    }

    @Override
    public IGridNode getOtherSide(IGridNode gridNode) {
        if (gridNode == this.sideA) {
            return this.sideB;
        }
        if (gridNode == this.sideB) {
            return this.sideA;
        }
        throw new GridException("Invalid Side of Connection");
    }

    @Override
    public ForgeDirection getDirection(IGridNode side) {
        if (this.fromAtoB == ForgeDirection.UNKNOWN) {
            return this.fromAtoB;
        }
        if (this.sideA == side) {
            return this.fromAtoB;
        }
        return this.fromAtoB.getOpposite();
    }

    @Override
    public void destroy() {
        if (AEConfig.instance.debugPathFinding) {
            String aCoordinates = this.sideA.getGridBlock().getLocation().toString();
            String bCoordinates = this.sideB.getGridBlock().getLocation().toString();
            AELog.info("Repath is triggered by destroying connection from [%s] to [%s]", aCoordinates, bCoordinates);
            AELog.printStackTrace(Level.INFO);
        }
        IPathingGrid p = (IPathingGrid)this.sideA.getInternalGrid().getCache(IPathingGrid.class);
        p.repath();
        this.sideA.removeConnection(this);
        this.sideB.removeConnection(this);
        this.sideA.validateGrid();
        this.sideB.validateGrid();
    }

    @Override
    public IGridNode a() {
        return this.sideA;
    }

    @Override
    public IGridNode b() {
        return this.sideB;
    }

    @Override
    public boolean hasDirection() {
        return this.fromAtoB != ForgeDirection.UNKNOWN;
    }

    @Override
    public int getUsedChannels() {
        return this.channelData >> 8 & 0xFF;
    }

    @Override
    public IPathItem getControllerRoute() {
        if (this.sideA.getFlags().contains((Object)GridFlags.CANNOT_CARRY)) {
            return null;
        }
        return this.sideA;
    }

    @Override
    public void setControllerRoute(IPathItem fast, boolean zeroOut) {
        if (zeroOut) {
            this.channelData &= 0xFFFFFF00;
        }
        if (this.sideB == fast) {
            GridNode tmp = this.sideA;
            this.sideA = this.sideB;
            this.sideB = tmp;
            this.fromAtoB = this.fromAtoB.getOpposite();
        }
    }

    @Override
    public boolean canSupportMoreChannels() {
        return this.getLastUsedChannels() < 128;
    }

    @Override
    public IReadOnlyCollection<IPathItem> getPossibleOptions() {
        return new ReadOnlyCollection<IPathItem>(Arrays.asList((IPathItem)((Object)this.a()), (IPathItem)((Object)this.b())));
    }

    @Override
    public void incrementChannelCount(int usedChannels) {
        this.channelData += usedChannels;
    }

    @Override
    public EnumSet<GridFlags> getFlags() {
        return EnumSet.noneOf(GridFlags.class);
    }

    @Override
    public void finalizeChannels() {
        if (this.getUsedChannels() != this.getLastUsedChannels()) {
            this.channelData &= 0xFF;
            this.channelData |= this.channelData << 8;
            if (this.sideA.getInternalGrid() != null) {
                this.sideA.getInternalGrid().postEventTo(this.sideA, EVENT);
            }
            if (this.sideB.getInternalGrid() != null) {
                this.sideB.getInternalGrid().postEventTo(this.sideB, EVENT);
            }
        }
    }

    private int getLastUsedChannels() {
        return this.channelData & 0xFF;
    }

    Object getVisitorIterationNumber() {
        return this.visitorIterationNumber;
    }

    void setVisitorIterationNumber(Object visitorIterationNumber) {
        this.visitorIterationNumber = visitorIterationNumber;
    }
}

