/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.common.world;

import com.brandon3055.brandonscore.common.utills.SimplexNoise;
import com.brandon3055.brandonscore.common.world.BlockCollection;
import com.brandon3055.draconicevolution.common.utills.LogHelper;
import java.util.Random;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.gen.NoiseGeneratorImproved;
import net.minecraft.world.gen.NoiseGeneratorOctaves;
import net.minecraft.world.gen.NoiseGeneratorSimplex;

public class WorldGenChaosIsland {
    private int spawnHeight = 128;
    private int size;
    private BlockCollection blockCollection;
    public boolean initialized = false;
    double[] noiseData;

    public void initialize(Random random) {
        this.generate(this.blockCollection, random);
        this.initialized = true;
    }

    public BlockCollection getBlocks(Random random) {
        if (!this.initialized) {
            this.initialize(random);
        }
        return this.blockCollection;
    }

    public boolean generate(BlockCollection world, Random random) {
        this.size = 400;
        this.generateCentre(world, random);
        return true;
    }

    private void generateCentre(BlockCollection blocks, Random rand) {
        int curve = 2;
        int diffStart = 20;
        int coreDiameter = 90;
        NoiseGeneratorSimplex simX = new NoiseGeneratorSimplex(rand);
        NoiseGeneratorSimplex simY = new NoiseGeneratorSimplex(rand);
        NoiseGeneratorSimplex simZ = new NoiseGeneratorSimplex(rand);
        NoiseGeneratorImproved generatorImproved = new NoiseGeneratorImproved(rand);
        generatorImproved.func_76308_a(new double[this.size * 255 * this.size], 0.0, 0.0, 0.0, this.size, 255, this.size, 10.0, 10.0, 10.0, 500.0);
        NoiseGeneratorOctaves generatorOctaves = new NoiseGeneratorOctaves(rand, 8);
        boolean f = true;
        int randOffset = rand.nextInt(10000);
        for (int x = 0; x <= this.size; ++x) {
            f = true;
            for (int z = 0; z <= this.size; ++z) {
                for (int y = 0; y <= this.size / 2; ++y) {
                    double dist = Math.sqrt(x * x + (y - this.spawnHeight) * (y - this.spawnHeight) + z * z);
                    double xf = (double)x / (double)this.size;
                    double yf = (double)y / (double)(this.size / 2);
                    double zf = (double)z / (double)this.size;
                    double center_falloff = 0.1;
                    double diameterScale = 100.0;
                    if (center_falloff < 0.0) {
                        center_falloff = 0.0;
                    }
                    double plateau_falloff = yf <= 0.8 ? 1.0 : (0.8 < yf && yf < 0.9 ? 1.0 - (yf - 0.8) * 10.0 : 0.0);
                    double density = 0.1;
                    for (int octave = 0; octave < 4; ++octave) {
                    }
                    density *= center_falloff * plateau_falloff;
                    f = false;
                }
            }
        }
    }

    public static void generate(World world, int trueX, int y, int trueZ, int offsetX, int offsetZ) {
        int x = trueX - offsetX;
        int z = trueZ - offsetZ;
        int size = 300;
        double xf = (double)x / (double)size;
        double yf = (double)y / 256.0;
        double zf = (double)z / (double)size;
        double center_falloff = 0.1;
        double diameterScale = 100.0;
        if (center_falloff < 0.0) {
            center_falloff = 0.0;
        }
        double plateau_falloff = yf <= 0.8 ? 1.0 : (0.8 < yf && yf < 0.9 ? 1.0 - (yf - 0.8) * 10.0 : 0.0);
        double density = 0.1;
        for (int octave = 0; octave < 4; ++octave) {
            density += Math.abs(SimplexNoise.noise((double)(xf * Math.pow(2.0, octave)), (double)(yf * Math.pow(2.0, octave)), (double)(zf * Math.pow(2.0, octave))));
        }
        if (y % 50 == 0) {
            LogHelper.info(density + " " + center_falloff + " " + yf);
        }
        if (density > 1.0) {
            world.func_147449_b(x + offsetX, y, z + offsetZ, Blocks.field_150377_bs);
        }
    }

    private int getDiffusionPct(int dist, int maxDist) {
        double d = (double)dist / (double)maxDist;
        int i = Math.max(1, (int)(d * 1000.0));
        return 1000 - i;
    }

    private double getDiffusionPctD(int dist, int maxDist) {
        double d = (double)dist / (double)maxDist;
        return d;
    }

    private void generateObelisks(BlockCollection world, Random rand) {
    }

    private void generateObelisk(BlockCollection world, int x1, int y1, int z1, boolean outer, Random rand) {
    }

    private void generateBelt(BlockCollection world, Random random, int innerRadius, int outerRadius) {
    }
}

