/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.common.blocks;

import com.brandon3055.draconicevolution.DraconicEvolution;
import com.brandon3055.draconicevolution.common.ModBlocks;
import com.brandon3055.draconicevolution.common.blocks.BlockCustomDrop;
import com.brandon3055.draconicevolution.common.blocks.itemblocks.DraconiumChestItemBlock;
import com.brandon3055.draconicevolution.common.lib.References;
import com.brandon3055.draconicevolution.common.tileentities.TileDraconiumChest;
import com.brandon3055.draconicevolution.common.utills.ICustomItemData;
import cpw.mods.fml.common.network.internal.FMLNetworkHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MathHelper;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.oredict.OreDictionary;

public class DraconiumChest
extends BlockCustomDrop {
    private static final String[] STORAGE_BLACKLIST = new String[]{"tile.thermalexpansion.strongbox", "item.thermalexpansion.satchel", "tile.draconicevolution:draconiumChest"};

    public DraconiumChest() {
        super(Material.field_151573_f);
        this.func_149663_c("draconiumChest");
        this.func_149647_a(DraconicEvolution.tabBlocksItems);
        this.func_149672_a(field_149769_e);
        this.func_149676_a(0.0625f, 0.0f, 0.0625f, 0.9375f, 0.875f, 0.9375f);
        this.func_149752_b(2000.0f);
        ModBlocks.register(this, DraconiumChestItemBlock.class);
    }

    public static boolean isStackValid(ItemStack stack) {
        for (int i = 0; i < STORAGE_BLACKLIST.length; ++i) {
            if (!stack.func_77977_a().contains(STORAGE_BLACKLIST[i])) continue;
            return false;
        }
        return true;
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float cx, float cy, float cz) {
        TileEntity tileEntity = world.func_147438_o(x, y, z);
        if (!(tileEntity instanceof TileDraconiumChest)) {
            return false;
        }
        TileDraconiumChest te = (TileDraconiumChest)tileEntity;
        if (player.func_70093_af()) {
            boolean bl = te.editMode = !te.editMode;
            if (world.field_72995_K) {
                player.func_146105_b((IChatComponent)new ChatComponentText(EnumChatFormatting.DARK_GREEN + "" + StatCollector.func_74838_a((String)"msg.draconiumChestEditmode.txt") + EnumChatFormatting.DARK_AQUA + " " + String.valueOf(te.editMode)));
            }
            if (te.editMode) {
                if (world.field_72995_K) {
                    player.func_146105_b((IChatComponent)new ChatComponentText(EnumChatFormatting.GOLD + "" + StatCollector.func_74838_a((String)"msg.draconiumChestEditL1.txt")));
                }
                if (world.field_72995_K) {
                    player.func_146105_b((IChatComponent)new ChatComponentText(EnumChatFormatting.GOLD + "" + StatCollector.func_74838_a((String)"msg.draconiumChestEditL2.txt")));
                }
                if (world.field_72995_K) {
                    player.func_146105_b((IChatComponent)new ChatComponentText(EnumChatFormatting.GOLD + "" + StatCollector.func_74838_a((String)"msg.draconiumChestEditL3.txt")));
                }
                if (world.field_72995_K) {
                    player.func_146105_b((IChatComponent)new ChatComponentText(EnumChatFormatting.GOLD + "" + StatCollector.func_74838_a((String)"msg.draconiumChestEditL4.txt")));
                }
            }
            return false;
        }
        if (te.editMode && (this.isDye(player.func_70694_bm(), "dyeRed") || this.isDye(player.func_70694_bm(), "dyeGreen") || this.isDye(player.func_70694_bm(), "dyeBlue"))) {
            int increment;
            int n = increment = cy > 0.5f ? 5 : -5;
            if (this.isDye(player.func_70694_bm(), "dyeRed")) {
                te.red += increment;
                if (te.red > 255) {
                    te.red = 255;
                }
                if (te.red < 0) {
                    te.red = 0;
                }
            }
            if (this.isDye(player.func_70694_bm(), "dyeGreen")) {
                te.green += increment;
                if (te.green > 255) {
                    te.green = 255;
                }
                if (te.green < 0) {
                    te.green = 0;
                }
            }
            if (this.isDye(player.func_70694_bm(), "dyeBlue")) {
                te.blue += increment;
                if (te.blue > 255) {
                    te.blue = 255;
                }
                if (te.blue < 0) {
                    te.blue = 0;
                }
            }
            if (world.field_72995_K) {
                player.func_146105_b((IChatComponent)new ChatComponentText(StatCollector.func_74838_a((String)"msg.draconiumChestRed.txt") + " " + te.red));
            }
            if (world.field_72995_K) {
                player.func_146105_b((IChatComponent)new ChatComponentText(StatCollector.func_74838_a((String)"msg.draconiumChestGreen.txt") + " " + te.green));
            }
            if (world.field_72995_K) {
                player.func_146105_b((IChatComponent)new ChatComponentText(StatCollector.func_74838_a((String)"msg.draconiumChestBlue.txt") + " " + te.blue));
            }
            return true;
        }
        if (te.editMode && player.func_70694_bm() != null && player.func_70694_bm().func_77973_b().equals(Items.field_151121_aF)) {
            if (player.func_70694_bm().field_77994_a != 1) {
                if (world.field_72995_K) {
                    player.func_146105_b((IChatComponent)new ChatComponentTranslation("msg.draconiumChestEdit2.txt", new Object[0]));
                }
                return true;
            }
            ItemStack paper = player.func_70694_bm();
            NBTTagCompound nbt = paper.func_77978_p();
            if (nbt == null) {
                nbt = new NBTTagCompound();
            }
            if (nbt.func_74764_b("Is Draconic Chest Saved Colour")) {
                te.red = nbt.func_74762_e("R");
                te.green = nbt.func_74762_e("G");
                te.blue = nbt.func_74762_e("B");
            } else {
                NBTTagList lore = new NBTTagList();
                lore.func_74742_a((NBTBase)new NBTTagString("Red: " + te.red));
                lore.func_74742_a((NBTBase)new NBTTagString("Green: " + te.green));
                lore.func_74742_a((NBTBase)new NBTTagString("Blue: " + te.blue));
                NBTTagCompound display = new NBTTagCompound();
                display.func_74782_a("Lore", (NBTBase)lore);
                display.func_74778_a("Name", "Draconic Chest Saved Colour");
                nbt.func_74782_a("display", (NBTBase)display);
                nbt.func_74768_a("R", te.red);
                nbt.func_74768_a("G", te.green);
                nbt.func_74768_a("B", te.blue);
                nbt.func_74757_a("Is Draconic Chest Saved Colour", true);
                paper.func_77982_d(nbt);
            }
            return true;
        }
        if (!world.field_72995_K) {
            FMLNetworkHandler.openGui((EntityPlayer)player, (Object)DraconicEvolution.instance, (int)11, (World)world, (int)x, (int)y, (int)z);
        }
        return true;
    }

    public boolean isDye(ItemStack stack, String oreName) {
        if (stack == null) {
            return false;
        }
        ArrayList items = OreDictionary.getOres((String)oreName);
        for (ItemStack ore : items) {
            if (!ore.func_77973_b().equals(stack.func_77973_b()) || stack.func_77960_j() != ore.func_77960_j()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void func_149749_a(World world, int x, int y, int z, Block block, int meta) {
        super.func_149749_a(world, x, y, z, block, meta);
    }

    @Override
    public TileEntity func_149915_a(World p_149915_1_, int p_149915_2_) {
        return new TileDraconiumChest();
    }

    public boolean func_149686_d() {
        return false;
    }

    public boolean func_149662_c() {
        return false;
    }

    public int func_149645_b() {
        return -1;
    }

    public void func_149689_a(World world, int i, int j, int k, EntityLivingBase entityliving, ItemStack itemStack) {
        TileEntity te;
        int chestFacing = 0;
        int facing = MathHelper.func_76128_c((double)((double)(entityliving.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        if (facing == 0) {
            chestFacing = 2;
        }
        if (facing == 1) {
            chestFacing = 5;
        }
        if (facing == 2) {
            chestFacing = 3;
        }
        if (facing == 3) {
            chestFacing = 4;
        }
        if ((te = world.func_147438_o(i, j, k)) != null && te instanceof TileDraconiumChest) {
            TileDraconiumChest tedc = (TileDraconiumChest)te;
            tedc.setFacing(chestFacing);
            if (itemStack.func_82837_s()) {
                tedc.setCustomName(itemStack.func_82833_r());
            }
            world.func_147471_g(i, j, k);
        }
    }

    public boolean func_149740_M() {
        return true;
    }

    public int func_149736_g(World par1World, int par2, int par3, int par4, int par5) {
        TileEntity te = par1World.func_147438_o(par2, par3, par4);
        if (te instanceof IInventory) {
            return Container.func_94526_b((IInventory)((IInventory)te));
        }
        return 0;
    }

    public boolean rotateBlock(World worldObj, int x, int y, int z, ForgeDirection axis) {
        if (worldObj.field_72995_K) {
            return false;
        }
        if (axis == ForgeDirection.UP || axis == ForgeDirection.DOWN) {
            TileEntity tileEntity = worldObj.func_147438_o(x, y, z);
            if (tileEntity instanceof TileDraconiumChest) {
                TileDraconiumChest te = (TileDraconiumChest)tileEntity;
                te.rotateAround(axis);
            }
            return true;
        }
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister par1IconRegister) {
        this.field_149761_L = par1IconRegister.func_94245_a(References.RESOURCESPREFIX + "draconiumChest");
    }

    @Override
    protected boolean dropInventory() {
        return false;
    }

    @Override
    protected boolean hasCustomDropps() {
        return true;
    }

    @Override
    protected void getCustomTileEntityDrops(TileEntity te, List<ItemStack> droppes) {
        ItemStack stack = new ItemStack((Block)ModBlocks.draconiumChest);
        if (te instanceof ICustomItemData) {
            ICustomItemData chest = (ICustomItemData)te;
            NBTTagCompound tileTag = new NBTTagCompound();
            if (!stack.func_77942_o()) {
                stack.func_77982_d(new NBTTagCompound());
            }
            chest.writeDataToItem(tileTag, stack);
            stack.func_77978_p().func_74782_a("TileCompound", (NBTBase)tileTag);
        }
        droppes.add(stack);
    }
}

