/*
 * Decompiled with CFR 0.152.
 */
package shedar.mods.ic2.nuclearcontrol.items;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.energy.EnergyNet;
import ic2.core.block.generator.tileentity.TileEntityBaseGenerator;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidTankInfo;
import shedar.mods.ic2.nuclearcontrol.api.CardState;
import shedar.mods.ic2.nuclearcontrol.api.ICardWrapper;
import shedar.mods.ic2.nuclearcontrol.api.IPanelMultiCard;
import shedar.mods.ic2.nuclearcontrol.api.IRangeTriggerable;
import shedar.mods.ic2.nuclearcontrol.api.IRemoteSensor;
import shedar.mods.ic2.nuclearcontrol.api.PanelSetting;
import shedar.mods.ic2.nuclearcontrol.api.PanelString;
import shedar.mods.ic2.nuclearcontrol.items.ItemCardBase;
import shedar.mods.ic2.nuclearcontrol.panel.CardWrapperImpl;
import shedar.mods.ic2.nuclearcontrol.tileentities.TileEntityAverageCounter;
import shedar.mods.ic2.nuclearcontrol.tileentities.TileEntityEnergyCounter;
import shedar.mods.ic2.nuclearcontrol.utils.LangHelper;
import shedar.mods.ic2.nuclearcontrol.utils.LiquidStorageHelper;
import shedar.mods.ic2.nuclearcontrol.utils.StringUtils;
import shedar.mods.ic2.nuclearcontrol.utils.TextureResolver;

public class ItemCardMultipleSensorLocation
extends ItemCardBase
implements IRemoteSensor,
IPanelMultiCard,
IRangeTriggerable {
    private static final String HINT_TEMPLATE = "x: %d, y: %d, z: %d";
    public static final int DISPLAY_ENERGY = 1;
    public static final int DISPLAY_LIQUID_NAME = 1;
    public static final int DISPLAY_LIQUID_AMOUNT = 2;
    public static final int DISPLAY_LIQUID_FREE = 4;
    public static final int DISPLAY_LIQUID_CAPACITY = 8;
    public static final int DISPLAY_LIQUID_PERCENTAGE = 16;
    private static final UUID CARD_TYPE_COUNTER = new UUID(0L, 4L);
    private static final UUID CARD_TYPE_LIQUID = UUID.fromString("210dc1f0-118c-48ee-9d08-42bfbee1ea15");
    private static final UUID CARD_TYPE_GENERATOR = UUID.fromString("210dc1f0-118c-48ee-9d08-42bfbee1ea16");
    private static final String TEXTURE_CARD_COUNTER = "cardCounter";
    private static final String TEXTURE_CARD_LIQUID = "cardLiquid";
    private static final String TEXTURE_CARD_GENERATOR = "cardGenerator";
    private IIcon iconCounter;
    private IIcon iconLiquid;
    private IIcon iconGenerator;

    public ItemCardMultipleSensorLocation() {
        super("");
    }

    public void func_94581_a(IIconRegister iconRegister) {
        this.iconCounter = iconRegister.func_94245_a(TextureResolver.getItemTexture(TEXTURE_CARD_COUNTER));
        this.iconLiquid = iconRegister.func_94245_a(TextureResolver.getItemTexture(TEXTURE_CARD_LIQUID));
        this.iconGenerator = iconRegister.func_94245_a(TextureResolver.getItemTexture(TEXTURE_CARD_GENERATOR));
    }

    public String func_77667_c(ItemStack stack) {
        int damage = stack.func_77960_j();
        switch (damage) {
            case 0: {
                return "item.itemCounterSensorLocationCard";
            }
            case 1: {
                return "item.ItemLiquidSensorLocationCard";
            }
            case 2: {
                return "item.ItemGeneratorSensorLocationCard";
            }
        }
        return "";
    }

    @Override
    public CardState update(TileEntity panel, ICardWrapper card, int range) {
        int damage = card.getItemStack().func_77960_j();
        switch (damage) {
            case 0: {
                return this.updateCounter(panel.func_145831_w(), card, range);
            }
            case 1: {
                return this.updateLiquid(panel.func_145831_w(), card, range);
            }
            case 2: {
                return this.updateGenerator(panel.func_145831_w(), card, range);
            }
        }
        return CardState.INVALID_CARD;
    }

    @Override
    public CardState update(World world, ICardWrapper card, int range) {
        int damage = card.getItemStack().func_77960_j();
        switch (damage) {
            case 0: {
                return this.updateCounter(world, card, range);
            }
            case 1: {
                return this.updateLiquid(world, card, range);
            }
            case 2: {
                return this.updateGenerator(world, card, range);
            }
        }
        return CardState.INVALID_CARD;
    }

    public CardState updateLiquid(World world, ICardWrapper card, int range) {
        ChunkCoordinates target = card.getTarget();
        if (target == null) {
            return CardState.NO_TARGET;
        }
        FluidTankInfo storage = LiquidStorageHelper.getStorageAt(world, target.field_71574_a, target.field_71572_b, target.field_71573_c);
        if (storage != null) {
            int capacity = storage.capacity;
            int amount = 0;
            int liquidId = 0;
            NBTTagCompound liquidTag = null;
            if (storage.fluid != null) {
                amount = storage.fluid.amount;
                if (storage.fluid.getFluidID() != 0 && amount > 0) {
                    liquidId = storage.fluid.getFluidID();
                    liquidTag = storage.fluid.tag;
                }
            }
            card.setInt("capacity", capacity);
            card.setInt("amount", amount);
            card.setInt("liquidId", liquidId);
            card.setTag("liquidTag", liquidTag);
            card.setDouble("range_trigger_amount", Double.valueOf(amount));
            return CardState.OK;
        }
        return CardState.NO_TARGET;
    }

    public CardState updateCounter(World world, ICardWrapper card, int range) {
        ChunkCoordinates target = card.getTarget();
        if (target == null) {
            return CardState.NO_TARGET;
        }
        TileEntity tileEntity = world.func_147438_o(target.field_71574_a, target.field_71572_b, target.field_71573_c);
        if (tileEntity != null && tileEntity instanceof TileEntityEnergyCounter) {
            TileEntityEnergyCounter counter = (TileEntityEnergyCounter)tileEntity;
            card.setDouble("energy", counter.counter);
            card.setDouble("range_trigger_amount", counter.counter);
            card.setInt("powerType", Integer.valueOf(counter.powerType));
            return CardState.OK;
        }
        if (tileEntity != null && tileEntity instanceof TileEntityAverageCounter) {
            TileEntityAverageCounter avgCounter = (TileEntityAverageCounter)tileEntity;
            card.setInt("average", avgCounter.getClientAverage());
            card.setDouble("range_trigger_amount", Double.valueOf(avgCounter.getClientAverage()));
            card.setInt("powerType", Integer.valueOf(avgCounter.powerType));
            return CardState.OK;
        }
        return CardState.NO_TARGET;
    }

    public CardState updateGenerator(World world, ICardWrapper card, int range) {
        ChunkCoordinates target = card.getTarget();
        if (target == null) {
            return CardState.NO_TARGET;
        }
        TileEntity entity = world.func_147438_o(target.field_71574_a, target.field_71572_b, target.field_71573_c);
        if (entity instanceof TileEntityBaseGenerator) {
            int production = (int)EnergyNet.instance.getNodeStats(entity).getEnergyOut();
            card.setInt("production", production);
            card.setDouble("range_trigger_amount", Double.valueOf(production));
            return CardState.OK;
        }
        return CardState.NO_TARGET;
    }

    @Override
    public List<PanelSetting> getSettingsList(ICardWrapper card) {
        int damage = card.getItemStack().func_77960_j();
        switch (damage) {
            case 0: {
                return this.getSettingsListCounter();
            }
            case 1: {
                return this.getSettingsListLiquid();
            }
            case 2: {
                return this.getSettingsListGenerator();
            }
        }
        return null;
    }

    @Override
    public UUID getCardType(ICardWrapper card) {
        int damage = card.getItemStack().func_77960_j();
        switch (damage) {
            case 0: {
                return CARD_TYPE_COUNTER;
            }
            case 1: {
                return CARD_TYPE_LIQUID;
            }
            case 2: {
                return CARD_TYPE_GENERATOR;
            }
        }
        return null;
    }

    @Override
    public List<PanelString> getStringData(int displaySettings, ICardWrapper card, boolean showLabels) {
        int damage = card.getItemStack().func_77960_j();
        switch (damage) {
            case 0: {
                return this.getStringDataCounter(displaySettings, card, showLabels);
            }
            case 1: {
                return this.getStringDataLiquid(displaySettings, card, showLabels);
            }
            case 2: {
                return this.getStringDataGenerator(displaySettings, card, showLabels);
            }
        }
        return null;
    }

    public List<PanelString> getStringDataLiquid(int displaySettings, ICardWrapper card, boolean showLabels) {
        PanelString line;
        LinkedList<PanelString> result = new LinkedList<PanelString>();
        int capacity = card.getInt("capacity");
        int amount = card.getInt("amount");
        if ((displaySettings & 1) > 0) {
            int liquidId = card.getInt("liquidId");
            String name = liquidId == 0 ? LangHelper.translate("msg.nc.None") : FluidRegistry.getFluidName((int)liquidId);
            line = new PanelString();
            line.textLeft = StringUtils.getFormatted("msg.nc.InfoPanelLiquidName", name, showLabels);
            result.add(line);
        }
        if ((displaySettings & 2) > 0) {
            line = new PanelString();
            line.textLeft = StringUtils.getFormatted("msg.nc.InfoPanelLiquidAmount", amount, showLabels);
            result.add(line);
        }
        if ((displaySettings & 4) > 0) {
            line = new PanelString();
            line.textLeft = StringUtils.getFormatted("msg.nc.InfoPanelLiquidFree", capacity - amount, showLabels);
            result.add(line);
        }
        if ((displaySettings & 8) > 0) {
            line = new PanelString();
            line.textLeft = StringUtils.getFormatted("msg.nc.InfoPanelLiquidCapacity", capacity, showLabels);
            result.add(line);
        }
        if ((displaySettings & 0x10) > 0) {
            line = new PanelString();
            line.textLeft = StringUtils.getFormatted("msg.nc.InfoPanelLiquidPercentage", capacity == 0 ? 100.0 : (double)(amount * 100 / capacity), showLabels);
            result.add(line);
        }
        return result;
    }

    public List<PanelString> getStringDataCounter(int displaySettings, ICardWrapper card, boolean showLabels) {
        LinkedList<PanelString> result = new LinkedList<PanelString>();
        if (card.hasField("average")) {
            if ((displaySettings & 1) > 0) {
                PanelString line = new PanelString();
                String key = card.getInt("powerType") == 0 ? "msg.nc.InfoPanelOutput" : "msg.nc.InfoPanelOutputMJ";
                line.textLeft = StringUtils.getFormatted(key, card.getInt("average").intValue(), showLabels);
                result.add(line);
            }
        } else if ((displaySettings & 1) > 0) {
            double energy = card.getDouble("energy");
            PanelString line = new PanelString();
            String key = card.getInt("powerType") == 0 ? "msg.nc.InfoPanelEnergyCounter" : "msg.nc.InfoPanelEnergyCounterMJ";
            line.textLeft = StringUtils.getFormatted(key, energy, showLabels);
            result.add(line);
        }
        return result;
    }

    public List<PanelString> getStringDataGenerator(int displaySettings, ICardWrapper card, boolean showLabels) {
        LinkedList<PanelString> result = new LinkedList<PanelString>();
        PanelString line = new PanelString();
        line.textLeft = StringUtils.getFormatted("msg.nc.InfoPanelOutput", card.getInt("production").intValue(), showLabels);
        result.add(line);
        return result;
    }

    public IIcon func_77617_a(int damage) {
        switch (damage) {
            case 0: {
                return this.iconCounter;
            }
            case 1: {
                return this.iconLiquid;
            }
            case 2: {
                return this.iconGenerator;
            }
        }
        return null;
    }

    public List<PanelSetting> getSettingsListCounter() {
        ArrayList<PanelSetting> result = new ArrayList<PanelSetting>(1);
        result.add(new PanelSetting(LangHelper.translate("1"), 1, CARD_TYPE_COUNTER));
        return result;
    }

    public List<PanelSetting> getSettingsListLiquid() {
        ArrayList<PanelSetting> result = new ArrayList<PanelSetting>(5);
        result.add(new PanelSetting(LangHelper.translate("1"), 1, CARD_TYPE_LIQUID));
        result.add(new PanelSetting(LangHelper.translate("2"), 2, CARD_TYPE_LIQUID));
        result.add(new PanelSetting(LangHelper.translate("3"), 4, CARD_TYPE_LIQUID));
        result.add(new PanelSetting(LangHelper.translate("4"), 8, CARD_TYPE_LIQUID));
        result.add(new PanelSetting(LangHelper.translate("5"), 16, CARD_TYPE_LIQUID));
        return result;
    }

    public List<PanelSetting> getSettingsListGenerator() {
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack itemStack, EntityPlayer player, List info, boolean advanced) {
        CardWrapperImpl helper = new CardWrapperImpl(itemStack, -1);
        ChunkCoordinates target = helper.getTarget();
        if (target != null) {
            String title = helper.getTitle();
            if (title != null && !title.isEmpty()) {
                info.add(title);
            }
            String hint = String.format(HINT_TEMPLATE, target.field_71574_a, target.field_71572_b, target.field_71573_c);
            info.add(hint);
        }
    }

    @Override
    public List<PanelSetting> getSettingsList() {
        return null;
    }

    @Override
    public UUID getCardType() {
        return null;
    }

    public void func_150895_a(Item item, CreativeTabs tab, List list) {
        list.add(new ItemStack(item, 1, 0));
        list.add(new ItemStack(item, 1, 1));
        list.add(new ItemStack(item, 1, 2));
    }
}

