/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.items;

import com.google.common.collect.EnumBiMap;
import mods.railcraft.api.core.items.IStackFilter;
import mods.railcraft.common.blocks.aesthetics.cube.EnumCube;
import mods.railcraft.common.blocks.ore.EnumOre;
import mods.railcraft.common.items.IItemMetaEnum;
import mods.railcraft.common.items.ItemIngot;
import mods.railcraft.common.items.ItemNugget;
import mods.railcraft.common.items.RailcraftItem;
import mods.railcraft.common.plugins.forge.OreDictPlugin;
import mods.railcraft.common.util.inventory.filters.OreStackFilter;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;

public enum Metal {
    STEEL("Steel"),
    IRON("Iron"),
    GOLD("Gold"),
    COPPER("Copper"),
    TIN("Tin"),
    LEAD("Lead");

    public static final Metal[] VALUES;
    private static final EnumBiMap<Metal, ItemIngot.EnumIngot> ingotMap;
    private static final EnumBiMap<Metal, ItemNugget.EnumNugget> nuggetMap;
    private static final EnumBiMap<Metal, EnumOre> poorOreMap;
    private static final EnumBiMap<Metal, EnumCube> blockMap;
    public final IStackFilter nuggetFilter;
    public final IStackFilter ingotFilter;
    public final IStackFilter blockFilter;
    private final String tag;

    private Metal(String tag) {
        this.tag = tag;
        this.nuggetFilter = new OreStackFilter(this.getNuggetTag());
        this.ingotFilter = new OreStackFilter(this.getIngotTag());
        this.blockFilter = new OreStackFilter(this.getBlockTag());
    }

    public String getNuggetTag() {
        return "nugget" + this.tag;
    }

    public ItemStack getNugget() {
        return this.getNugget(1);
    }

    public ItemStack getNugget(int qty) {
        switch (this) {
            case GOLD: {
                return new ItemStack(Items.field_151074_bl, qty);
            }
        }
        ItemStack stack = RailcraftItem.nugget.getStack(qty, (IItemMetaEnum)nuggetMap.get((Object)this));
        if (stack == null) {
            stack = OreDictPlugin.getOre(this.getNuggetTag(), qty);
        }
        return stack;
    }

    public String getIngotTag() {
        return "ingot" + this.tag;
    }

    public ItemStack getIngot() {
        return this.getIngot(1);
    }

    public ItemStack getIngot(int qty) {
        switch (this) {
            case IRON: {
                return new ItemStack(Items.field_151042_j, qty);
            }
            case GOLD: {
                return new ItemStack(Items.field_151043_k, qty);
            }
        }
        ItemStack stack = RailcraftItem.ingot.getStack(qty, (IItemMetaEnum)ingotMap.get((Object)this));
        if (stack == null || stack.func_77973_b() == Items.field_151042_j) {
            stack = OreDictPlugin.getOre(this.getIngotTag(), qty);
        }
        return stack;
    }

    public String getBlockTag() {
        return "block" + this.tag;
    }

    public ItemStack getBlock() {
        return this.getBlock(1);
    }

    public ItemStack getBlock(int qty) {
        switch (this) {
            case IRON: {
                return new ItemStack(Blocks.field_150339_S, qty);
            }
            case GOLD: {
                return new ItemStack(Blocks.field_150340_R, qty);
            }
        }
        ItemStack stack = ((EnumCube)((Object)blockMap.get((Object)this))).getItem(qty);
        if (stack == null) {
            stack = OreDictPlugin.getOre(this.getBlockTag(), qty);
        }
        return stack;
    }

    public ItemStack getPoorOre() {
        return this.getPoorOre(1);
    }

    public ItemStack getPoorOre(int qty) {
        switch (this) {
            case STEEL: {
                return null;
            }
        }
        return ((EnumOre)((Object)poorOreMap.get((Object)this))).getItem(qty);
    }

    public static Metal get(ItemNugget.EnumNugget nugget) {
        return (Metal)((Object)nuggetMap.inverse().get((Object)nugget));
    }

    public static Metal get(ItemIngot.EnumIngot ingot) {
        return (Metal)((Object)ingotMap.inverse().get((Object)ingot));
    }

    public static Metal get(EnumOre ore) {
        return (Metal)((Object)poorOreMap.inverse().get((Object)ore));
    }

    public static Metal get(EnumCube ore) {
        return (Metal)((Object)blockMap.inverse().get((Object)ore));
    }

    static {
        VALUES = Metal.values();
        ingotMap = EnumBiMap.create(Metal.class, ItemIngot.EnumIngot.class);
        nuggetMap = EnumBiMap.create(Metal.class, ItemNugget.EnumNugget.class);
        poorOreMap = EnumBiMap.create(Metal.class, EnumOre.class);
        blockMap = EnumBiMap.create(Metal.class, EnumCube.class);
        ingotMap.put((Object)STEEL, (Object)ItemIngot.EnumIngot.STEEL);
        ingotMap.put((Object)COPPER, (Object)ItemIngot.EnumIngot.COPPER);
        ingotMap.put((Object)TIN, (Object)ItemIngot.EnumIngot.TIN);
        ingotMap.put((Object)LEAD, (Object)ItemIngot.EnumIngot.LEAD);
        nuggetMap.put((Object)IRON, (Object)ItemNugget.EnumNugget.IRON);
        nuggetMap.put((Object)STEEL, (Object)ItemNugget.EnumNugget.STEEL);
        nuggetMap.put((Object)COPPER, (Object)ItemNugget.EnumNugget.COPPER);
        nuggetMap.put((Object)TIN, (Object)ItemNugget.EnumNugget.TIN);
        nuggetMap.put((Object)LEAD, (Object)ItemNugget.EnumNugget.LEAD);
        poorOreMap.put((Object)IRON, (Object)EnumOre.POOR_IRON);
        poorOreMap.put((Object)GOLD, (Object)EnumOre.POOR_GOLD);
        poorOreMap.put((Object)COPPER, (Object)EnumOre.POOR_COPPER);
        poorOreMap.put((Object)TIN, (Object)EnumOre.POOR_TIN);
        poorOreMap.put((Object)LEAD, (Object)EnumOre.POOR_LEAD);
        blockMap.put((Object)STEEL, (Object)EnumCube.STEEL_BLOCK);
        blockMap.put((Object)COPPER, (Object)EnumCube.COPPER_BLOCK);
        blockMap.put((Object)TIN, (Object)EnumCube.TIN_BLOCK);
        blockMap.put((Object)LEAD, (Object)EnumCube.LEAD_BLOCK);
    }
}

