/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.carts;

import java.util.HashSet;
import java.util.Set;
import mods.railcraft.api.carts.CartTools;
import mods.railcraft.api.core.WorldCoordinate;
import mods.railcraft.common.blocks.tracks.TrackForce;
import mods.railcraft.common.blocks.tracks.TrackTools;
import mods.railcraft.common.carts.CartMaintenanceBase;
import mods.railcraft.common.carts.EnumCart;
import mods.railcraft.common.carts.ICartType;
import mods.railcraft.common.plugins.forge.WorldPlugin;
import mods.railcraft.common.util.misc.Game;
import net.minecraft.block.Block;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class EntityCartTrackRemover
extends CartMaintenanceBase {
    private final Set<WorldCoordinate> tracksBehind = new HashSet<WorldCoordinate>();
    private final Set<WorldCoordinate> tracksRemoved = new HashSet<WorldCoordinate>();

    public EntityCartTrackRemover(World world) {
        super(world);
    }

    public EntityCartTrackRemover(World world, double d, double d1, double d2) {
        this(world);
        this.func_70107_b(d, d1 + (double)this.field_70129_M, d2);
        this.field_70159_w = 0.0;
        this.field_70181_x = 0.0;
        this.field_70179_y = 0.0;
        this.field_70169_q = d;
        this.field_70167_r = d1;
        this.field_70166_s = d2;
    }

    @Override
    public ICartType getCartType() {
        return EnumCart.TRACK_REMOVER;
    }

    protected void func_145821_a(int trackX, int trackY, int trackZ, double maxSpeed, double slopeAdjustment, Block trackBlock, int trackMeta) {
        super.func_145821_a(trackX, trackY, trackZ, maxSpeed, slopeAdjustment, trackBlock, trackMeta);
        if (Game.isNotHost(this.field_70170_p)) {
            return;
        }
        for (WorldCoordinate track : this.tracksBehind) {
            if (track.isEqual(this.field_70170_p.field_73011_w.field_76574_g, trackX, trackY, trackZ)) continue;
            this.removeTrack(track);
        }
        this.tracksBehind.removeAll(this.tracksRemoved);
        this.tracksRemoved.clear();
        this.addTravelledTrack(trackX, trackY, trackZ);
    }

    private void addTravelledTrack(int trackX, int trackY, int trackZ) {
        this.tracksBehind.add(new WorldCoordinate(this.field_70170_p.field_73011_w.field_76574_g, trackX, trackY, trackZ));
    }

    private void removeTrack(WorldCoordinate track) {
        if (WorldPlugin.getDistanceSq(track, this.field_70165_t, this.field_70163_u, this.field_70161_v) >= 9.0) {
            this.tracksRemoved.add(track);
        } else if (!TrackTools.isRailBlockAt((IBlockAccess)this.field_70170_p, track.x, track.y, track.z)) {
            this.tracksRemoved.add(track);
        } else if (TrackTools.getTrackInstanceAt((IBlockAccess)this.field_70170_p, track.x, track.y, track.z) instanceof TrackForce) {
            this.tracksRemoved.add(track);
        } else if (!CartTools.isMinecartAt(this.field_70170_p, track.x, track.y, track.z, -0.2f)) {
            Block block = WorldPlugin.getBlock((IBlockAccess)this.field_70170_p, track.x, track.y, track.z);
            this.removeOldTrack(track.x, track.y, track.z, block);
            this.blink();
            this.tracksRemoved.add(track);
        }
    }
}

