/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.machine.gamma;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import mods.railcraft.common.blocks.machine.IEnumMachine;
import mods.railcraft.common.blocks.machine.gamma.EnumMachineGamma;
import mods.railcraft.common.blocks.machine.gamma.TileItemUnloader;
import mods.railcraft.common.util.misc.MiscTools;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;
import net.minecraftforge.common.util.ForgeDirection;

public class TileItemUnloaderAdvanced
extends TileItemUnloader {
    private ForgeDirection direction = ForgeDirection.NORTH;

    @Override
    public IEnumMachine getMachineType() {
        return EnumMachineGamma.ITEM_UNLOADER_ADVANCED;
    }

    @Override
    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        nbttagcompound.func_74774_a("direction", (byte)this.direction.ordinal());
    }

    @Override
    public void func_145839_a(NBTTagCompound data) {
        super.func_145839_a(data);
        this.direction = ForgeDirection.getOrientation((int)data.func_74771_c("direction"));
    }

    @Override
    public void writePacketData(DataOutputStream data) throws IOException {
        super.writePacketData(data);
        data.writeByte(this.direction.ordinal());
    }

    @Override
    public void readPacketData(DataInputStream data) throws IOException {
        super.readPacketData(data);
        this.direction = ForgeDirection.getOrientation((int)data.readByte());
    }

    @Override
    public IIcon getIcon(int side) {
        if (this.direction.ordinal() == side) {
            return this.getMachineType().getTexture(3);
        }
        if (side != 0 && side != 1) {
            return this.getMachineType().getTexture(2);
        }
        return this.getMachineType().getTexture(1);
    }

    @Override
    public void onBlockPlacedBy(EntityLivingBase entityliving, ItemStack stack) {
        super.onBlockPlacedBy(entityliving, stack);
        this.direction = MiscTools.getSideFacingTrack(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        if (this.direction == ForgeDirection.UNKNOWN) {
            this.direction = MiscTools.getSideClosestToPlayer(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, entityliving);
        }
    }

    @Override
    public boolean rotateBlock(ForgeDirection axis) {
        this.direction = this.direction == axis ? axis.getOpposite() : axis;
        this.markBlockForUpdate();
        return true;
    }

    @Override
    public ForgeDirection getOrientation() {
        return this.direction;
    }
}

