/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks;

import mods.railcraft.common.core.RailcraftConfig;
import mods.railcraft.common.modules.ModuleManager;

public abstract class BlockFactory {
    private boolean needsInit = true;
    public final String tag;

    public BlockFactory(String tag) {
        this.tag = tag;
    }

    public final void initBlock() {
        if (this.needsInit && this.isBlockEnabled()) {
            this.needsInit = false;
            this.doBlockInit();
        }
    }

    protected boolean isBlockEnabled() {
        return RailcraftConfig.isBlockEnabled(this.tag);
    }

    protected abstract void doBlockInit();

    public final void initRecipes(ModuleManager.Module module) {
        if (!this.needsInit) {
            this.doRecipeInit(module);
        }
    }

    protected abstract void doRecipeInit(ModuleManager.Module var1);

    public final void finalizeBlocks(ModuleManager.Module module) {
        if (!this.needsInit) {
            this.doBlockFinalize(module);
        }
    }

    protected void doBlockFinalize(ModuleManager.Module module) {
    }
}

