/*
 * Decompiled with CFR 0.152.
 */
package com.darkona.adventurebackpack.reference;

import com.darkona.adventurebackpack.block.TileAdventureBackpack;
import com.darkona.adventurebackpack.reference.BackpackTypes;
import com.darkona.adventurebackpack.util.BackpackUtils;
import com.darkona.adventurebackpack.util.TipUtils;
import com.darkona.adventurebackpack.util.Utils;
import cpw.mods.fml.common.event.FMLInterModComms;
import java.util.List;
import javax.annotation.Nullable;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import mcp.mobius.waila.api.IWailaDataProvider;
import mcp.mobius.waila.api.IWailaRegistrar;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidTank;

public class WailaTileAdventureBackpack
implements IWailaDataProvider {
    public static void init() {
        FMLInterModComms.sendMessage((String)"Waila", (String)"register", (String)"com.darkona.adventurebackpack.reference.WailaTileAdventureBackpack.callbackRegister");
    }

    public static void callbackRegister(IWailaRegistrar registrar) {
        registrar.registerStackProvider((IWailaDataProvider)new WailaTileAdventureBackpack(), TileAdventureBackpack.class);
        registrar.registerHeadProvider((IWailaDataProvider)new WailaTileAdventureBackpack(), TileAdventureBackpack.class);
        registrar.registerBodyProvider((IWailaDataProvider)new WailaTileAdventureBackpack(), TileAdventureBackpack.class);
    }

    public ItemStack getWailaStack(IWailaDataAccessor accessor, IWailaConfigHandler config) {
        return this.addTypeToStack(accessor);
    }

    private ItemStack addTypeToStack(IWailaDataAccessor accessor) {
        if (accessor.getNBTData().func_74764_b("wearableData")) {
            NBTTagCompound backpackTag = accessor.getNBTData().func_74775_l("wearableData");
            BackpackTypes type = BackpackTypes.getType(backpackTag.func_74771_c("type"));
            return BackpackUtils.createBackpackStack(type);
        }
        return BackpackUtils.createBackpackStack(BackpackTypes.STANDARD);
    }

    public List<String> getWailaHead(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        WailaTileAdventureBackpack.addHeadToBackpack(currenttip, accessor);
        return currenttip;
    }

    private static void addHeadToBackpack(List<String> currenttip, IWailaDataAccessor accessor) {
        if (accessor.getNBTData().func_74764_b("wearableData")) {
            NBTTagCompound backpackTag = accessor.getNBTData().func_74775_l("wearableData");
            WailaTileAdventureBackpack.addHeadToBackpack(currenttip, backpackTag);
        }
    }

    private static void addHeadToBackpack(List<String> currenttip, NBTTagCompound backpackTag) {
        currenttip.remove(0);
        BackpackTypes type = BackpackTypes.getType(backpackTag.func_74771_c("type"));
        String skin = "";
        if (type != BackpackTypes.STANDARD) {
            skin = EnumChatFormatting.GRAY + " \"" + Utils.getColoredSkinName(type) + EnumChatFormatting.GRAY + "\"";
        }
        currenttip.add(EnumChatFormatting.WHITE + "Adventure Backpack" + skin);
    }

    public List<String> getWailaBody(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        WailaTileAdventureBackpack.addTipToBackpack(currenttip, accessor);
        return currenttip;
    }

    private static void addTipToBackpack(List<String> currenttip, IWailaDataAccessor accessor) {
        if (accessor.getNBTData().func_74764_b("wearableData")) {
            NBTTagCompound backpackTag = accessor.getNBTData().func_74775_l("wearableData");
            WailaTileAdventureBackpack.addTipToBackpack(currenttip, backpackTag);
        }
    }

    private static void addTipToBackpack(List<String> currenttip, NBTTagCompound backpackTag) {
        NBTTagList itemList = backpackTag.func_150295_c("inventory", 10);
        currenttip.add(TipUtils.l10n("backpack.slots.used") + ": " + TipUtils.inventoryTooltip(itemList));
        FluidTank tank = new FluidTank(4000);
        tank.readFromNBT(backpackTag.func_74775_l("leftTank"));
        currenttip.add(EnumChatFormatting.RESET + TipUtils.l10n("backpack.tank.left") + ": " + TipUtils.tankTooltip(tank));
        tank.readFromNBT(backpackTag.func_74775_l("rightTank"));
        currenttip.add(EnumChatFormatting.RESET + TipUtils.l10n("backpack.tank.right") + ": " + TipUtils.tankTooltip(tank));
    }

    @Nullable
    public List<String> getWailaTail(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        return null;
    }

    @Nullable
    public NBTTagCompound getNBTData(EntityPlayerMP player, TileEntity te, NBTTagCompound tag, World world, int x, int y, int z) {
        return null;
    }
}

