/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.core.recipe;

import gregtech.api.enums.GT_Values;
import gregtech.api.enums.Materials;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.util.GT_OreDictUnificator;
import gtPlusPlus.core.item.ModItems;
import gtPlusPlus.core.lib.CORE;
import gtPlusPlus.core.material.MISC_MATERIALS;
import gtPlusPlus.core.material.MaterialGenerator;
import gtPlusPlus.core.material.ORES;
import gtPlusPlus.core.recipe.common.CI;
import gtPlusPlus.core.util.minecraft.FluidUtils;
import gtPlusPlus.core.util.minecraft.ItemUtils;
import gtPlusPlus.core.util.minecraft.MaterialUtils;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class RECIPES_RareEarthProcessing {
    private static ItemStack mDustSodiumHydroxide;
    private static ItemStack mDustSalt;
    private static FluidStack mSaltWater;
    private static FluidStack mBrine;
    private static FluidStack mHydrogenChloride;

    public static void init() {
        Fluid f;
        mDustSalt = ItemUtils.getItemStackOfAmountFromOreDict("dustSalt", 1);
        if (mDustSalt == null) {
            MaterialUtils.generateSpecialDustAndAssignToAMaterial(MISC_MATERIALS.SODIUM_CHLORIDE, false);
            mDustSalt = MISC_MATERIALS.SODIUM_CHLORIDE.getDust(1);
        } else {
            MISC_MATERIALS.SODIUM_CHLORIDE.registerComponentForMaterial(OrePrefixes.dust, mDustSalt);
        }
        mSaltWater = FluidUtils.getFluidStack("saltwater", 1000);
        if (mSaltWater == null) {
            f = MISC_MATERIALS.SALT_WATER.generateFluid();
            MISC_MATERIALS.SALT_WATER.registerComponentForMaterial(FluidUtils.getFluidStack(f, 1000));
            mSaltWater = MISC_MATERIALS.SALT_WATER.getFluidStack(1000);
        } else {
            MISC_MATERIALS.SALT_WATER.registerComponentForMaterial(FluidUtils.getFluidStack(mSaltWater, 1000));
        }
        mBrine = FluidUtils.getFluidStack("brine", 1000);
        if (mBrine == null) {
            f = MISC_MATERIALS.BRINE.generateFluid();
            MISC_MATERIALS.BRINE.registerComponentForMaterial(FluidUtils.getFluidStack(f, 1000));
            mBrine = MISC_MATERIALS.BRINE.getFluidStack(1000);
        } else {
            MISC_MATERIALS.BRINE.registerComponentForMaterial(FluidUtils.getFluidStack(mBrine, 1000));
        }
        mDustSodiumHydroxide = ItemUtils.getItemStackOfAmountFromOreDict("dustSodiumHydroxide", 1);
        if (mDustSodiumHydroxide == null) {
            mDustSodiumHydroxide = ItemUtils.getItemStackOfAmountFromOreDict("dustSodiumHydroxide_GT5U", 1);
            if (mDustSodiumHydroxide == null) {
                MaterialUtils.generateSpecialDustAndAssignToAMaterial(MISC_MATERIALS.SODIUM_HYDROXIDE, false);
                mDustSodiumHydroxide = MISC_MATERIALS.SODIUM_HYDROXIDE.getDust(1);
            } else {
                MISC_MATERIALS.SODIUM_HYDROXIDE.registerComponentForMaterial(OrePrefixes.dust, mDustSodiumHydroxide);
            }
        } else {
            MISC_MATERIALS.SODIUM_HYDROXIDE.registerComponentForMaterial(OrePrefixes.dust, mDustSodiumHydroxide);
        }
        mHydrogenChloride = FluidUtils.getFluidStack("hydrogenchloride", 1000);
        if (mHydrogenChloride == null) {
            MISC_MATERIALS.HYDROGEN_CHLORIDE.generateFluid();
            mHydrogenChloride = MISC_MATERIALS.BRINE.getFluidStack(1000);
        } else {
            MISC_MATERIALS.HYDROGEN_CHLORIDE.registerComponentForMaterial(FluidUtils.getFluidStack(mHydrogenChloride, 1000));
        }
        CORE.RA.addBrewingRecipe(ItemUtils.getSimpleStack(mDustSalt, 16), MISC_MATERIALS.SALT_WATER.getFluidStack(2000), FluidUtils.getFluidStack(mBrine, 4000), 400, 120, false);
        GT_Values.RA.addElectrolyzerRecipe(CI.getNumberedCircuit(16), CI.emptyCells(4), FluidUtils.getFluidStack(mBrine, 4000), null, ItemUtils.getItemStackOfAmountFromOreDict("cellChlorine", 2), ItemUtils.getItemStackOfAmountFromOreDict("cellHydrogen", 2), ItemUtils.getSimpleStack(mDustSodiumHydroxide, 2), null, null, null, new int[]{10000, 10000, 10000}, 600, 120);
        CORE.RA.addMixerRecipe(CI.getNumberedBioCircuit(2), ItemUtils.getItemStackOfAmountFromOreDict("cellChlorine", 1), ItemUtils.getItemStackOfAmountFromOreDict("cellHydrogen", 1), null, null, null, ItemUtils.getSimpleStack(ModItems.cellHydrogenChlorideMix, 2), null, null, null, 200, 480);
        CORE.RA.addUvLaserRecipe(ItemUtils.getSimpleStack(ModItems.cellHydrogenChlorideMix, 4), ItemUtils.getItemStackOfAmountFromOreDict("cellHydrogenChloride", 4), 600, 480L);
        ORES.GREENOCKITE.vTier = 1;
        MISC_MATERIALS.RARE_EARTH_LOW.vTier = 1;
        MISC_MATERIALS.RARE_EARTH_MID.vTier = 3;
        MISC_MATERIALS.RARE_EARTH_HIGH.vTier = 5;
        ORES.GREENOCKITE.vVoltageMultiplier = 30;
        MISC_MATERIALS.RARE_EARTH_LOW.vVoltageMultiplier = 30;
        MISC_MATERIALS.RARE_EARTH_MID.vVoltageMultiplier = 480;
        MISC_MATERIALS.RARE_EARTH_HIGH.vVoltageMultiplier = 7680;
        MISC_MATERIALS.RARE_EARTH_LOW.vChemicalFormula = "??????";
        MISC_MATERIALS.RARE_EARTH_MID.vChemicalFormula = "??????";
        MISC_MATERIALS.RARE_EARTH_HIGH.vChemicalFormula = "??????";
        MISC_MATERIALS.RARE_EARTH_LOW.vChemicalSymbol = "??";
        MISC_MATERIALS.RARE_EARTH_MID.vChemicalSymbol = "??";
        MISC_MATERIALS.RARE_EARTH_HIGH.vChemicalSymbol = "??";
        MaterialGenerator.generateOreMaterial(MISC_MATERIALS.RARE_EARTH_LOW);
        MaterialGenerator.generateOreMaterial(MISC_MATERIALS.RARE_EARTH_MID);
        MaterialGenerator.generateOreMaterial(MISC_MATERIALS.RARE_EARTH_HIGH);
        ItemStack aRareEarth = GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.dust, (Object)Materials.RareEarth, (long)1L);
        Fluid aSulfuric = FluidUtils.getFluidStack("sulfuricacid", 1).getFluid();
        Fluid aHydrocholric = FluidUtils.getFluidStack("hydrogenchloride", 1).getFluid();
        Fluid aNitric = FluidUtils.getFluidStack("hydrofluoricacid", 1).getFluid();
        GT_Values.RA.addChemicalBathRecipe(ItemUtils.getSimpleStack(aRareEarth, 3), FluidUtils.getFluidStack(aSulfuric, 1000), MISC_MATERIALS.RARE_EARTH_LOW.getCrushed(2), MISC_MATERIALS.RARE_EARTH_LOW.getCrushed(2), MISC_MATERIALS.RARE_EARTH_LOW.getCrushed(2), new int[]{10000, 10000, 10000}, 600, MaterialUtils.getVoltageForTier(1));
        GT_Values.RA.addChemicalBathRecipe(ItemUtils.getSimpleStack(aRareEarth, 6), FluidUtils.getFluidStack(aHydrocholric, 2000), MISC_MATERIALS.RARE_EARTH_MID.getCrushed(4), MISC_MATERIALS.RARE_EARTH_MID.getCrushed(4), MISC_MATERIALS.RARE_EARTH_MID.getCrushed(4), new int[]{10000, 9000, 8000}, 600, MaterialUtils.getVoltageForTier(3));
        GT_Values.RA.addChemicalBathRecipe(ItemUtils.getSimpleStack(aRareEarth, 9), FluidUtils.getHydrofluoricAcid(3000), MISC_MATERIALS.RARE_EARTH_HIGH.getCrushed(6), MISC_MATERIALS.RARE_EARTH_HIGH.getCrushed(6), MISC_MATERIALS.RARE_EARTH_HIGH.getCrushed(6), new int[]{10000, 9000, 8000}, 600, MaterialUtils.getVoltageForTier(5));
        if (FluidUtils.doesHydrofluoricAcidGtExist()) {
            GT_Values.RA.addChemicalBathRecipe(ItemUtils.getSimpleStack(aRareEarth, 9), FluidUtils.getHydrofluoricAcidGT(6000), MISC_MATERIALS.RARE_EARTH_HIGH.getCrushed(6), MISC_MATERIALS.RARE_EARTH_HIGH.getCrushed(6), MISC_MATERIALS.RARE_EARTH_HIGH.getCrushed(6), new int[]{9000, 8000, 7000}, 600, MaterialUtils.getVoltageForTier(5));
        }
    }

    public static void processCopperRecipes() {
    }
}

