/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus;

import gtPlusPlus.api.objects.random.XSTR;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import org.apache.commons.io.FileUtils;

public class GenerateDictionaries {
    public static void main(String[] args) {
        File aMainDictionary = new File("proguard/DictionaryMain.txt");
        File aMethodDict = new File("proguard/method-dict.txt");
        File aClassDict = new File("proguard/class-dict.txt");
        if (Utils.doesFileExist(aMainDictionary)) {
            Utils.log("Found Main Dictionary");
            List<String> aLines = Utils.readLines(aMainDictionary);
            ArrayList<String> aLinesToWriteMethods = new ArrayList<String>();
            ArrayList<String> aLinesToWriteClasses = new ArrayList<String>();
            if (aLines != null && aLines.size() > 0) {
                String aLineAtIndex;
                Integer aIndex;
                Utils.log("Main Dictionary has > 0 keywords (" + aLines.size() + ")");
                HashSet<Integer> aUsedIndicies = new HashSet<Integer>();
                int aCount = aLines.size() / 5;
                Utils.log("Mapping " + aCount + " to each dict.");
                int i = 0;
                while (aLinesToWriteMethods.size() < aCount) {
                    aIndex = Utils.randInt(0, aLines.size() - 1);
                    if (!aUsedIndicies.contains(aIndex) && (aLineAtIndex = aLines.get(aIndex)) != null && aLineAtIndex.length() > 0) {
                        aLinesToWriteMethods.add(aLineAtIndex);
                        aUsedIndicies.add(aIndex);
                    }
                    if (i >= aCount * 5) break;
                    ++i;
                }
                i = 0;
                while (aLinesToWriteClasses.size() < aCount) {
                    aIndex = Utils.randInt(0, aLines.size() - 1);
                    if (!aUsedIndicies.contains(aIndex) && (aLineAtIndex = aLines.get(aIndex)) != null && aLineAtIndex.length() > 0) {
                        aLinesToWriteClasses.add(aLineAtIndex);
                        aUsedIndicies.add(aIndex);
                    }
                    if (i >= aCount * 5) break;
                    ++i;
                }
            }
            if (Utils.doesFileExist(aMethodDict)) {
                aMethodDict.delete();
                Utils.log("Removed old Method-Dict");
            }
            if (Utils.doesFileExist(aClassDict)) {
                aClassDict.delete();
                Utils.log("Removed old Class-Dict");
            }
            if (!Utils.doesFileExist(aMethodDict)) {
                Utils.createFile(aMethodDict);
            }
            if (!Utils.doesFileExist(aClassDict)) {
                Utils.createFile(aClassDict);
            }
            Utils.log("Writing new Dictionaries.");
            Utils.appendListToFile(aMethodDict, aLinesToWriteMethods);
            Utils.appendListToFile(aClassDict, aLinesToWriteClasses);
            Utils.log("Finished all generation of new Dictionaries.");
        }
    }

    private static final class Utils {
        private static final Charset utf8 = StandardCharsets.UTF_8;
        private static final Random rand = new XSTR();

        private Utils() {
        }

        private static final void log(String s) {
            System.out.println("[GTPP-Proguard] " + s);
        }

        public static int randInt(int min, int max) {
            return rand.nextInt(max - min + 1) + min;
        }

        public static boolean doesFileExist(File f) {
            return f != null && f.exists() && !f.isDirectory();
        }

        public static File createFile(File aFile) {
            boolean blnCreated = false;
            Utils.log("Trying to use relative path " + aFile.getPath());
            try {
                blnCreated = aFile.createNewFile();
            }
            catch (IOException ioe) {
                Utils.log("Error while creating a new empty file :" + ioe);
                return null;
            }
            return blnCreated ? aFile : null;
        }

        public static boolean appendListToFile(File file, List<String> content) {
            block4: {
                try {
                    Path p;
                    if (!Utils.doesFileExist(file) || (p = Paths.get(file.getPath(), new String[0])) == null || !Files.isWritable(p)) break block4;
                    long oldSize = Files.size(p);
                    try {
                        Files.write(p, content, utf8, StandardOpenOption.APPEND);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    long newSize = Files.size(p);
                    return newSize > oldSize;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return false;
        }

        public static List<String> readLines(File file) {
            try {
                return FileUtils.readLines((File)file, (Charset)utf8);
            }
            catch (IOException e) {
                return new ArrayList<String>();
            }
        }
    }
}

