/*
 * Decompiled with CFR 0.152.
 */
package com.djgiannuzz.thaumcraftneiplugin.nei.recipehandler;

import codechicken.lib.gui.GuiDraw;
import codechicken.nei.NEIServerUtils;
import codechicken.nei.OffsetPositioner;
import codechicken.nei.PositionedStack;
import codechicken.nei.api.IOverlayHandler;
import codechicken.nei.api.IRecipeOverlayRenderer;
import codechicken.nei.api.IStackPositioner;
import codechicken.nei.recipe.RecipeInfo;
import codechicken.nei.recipe.ShapelessRecipeHandler;
import codechicken.nei.recipe.TemplateRecipeHandler;
import com.djgiannuzz.thaumcraftneiplugin.items.ItemAspect;
import com.djgiannuzz.thaumcraftneiplugin.nei.NEIHelper;
import com.djgiannuzz.thaumcraftneiplugin.nei.overlay.ArcaneWorkbenchOverlayRenderer;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.util.StatCollector;
import org.lwjgl.opengl.GL11;
import thaumcraft.api.ThaumcraftApi;
import thaumcraft.api.ThaumcraftApiHelper;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.crafting.ShapelessArcaneRecipe;
import thaumcraft.client.gui.GuiArcaneWorkbench;
import thaumcraft.client.lib.UtilsFX;

public class ArcaneShapelessRecipeHandler
extends ShapelessRecipeHandler {
    public static final String OVERLAY_IDENTIFIER = "arcaneshapelessrecipes";
    protected ArrayList<int[]> aspectsAmount = new ArrayList();
    String username;

    public ArcaneShapelessRecipeHandler() {
        this.username = Minecraft.func_71410_x().field_71439_g.getDisplayName();
    }

    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(26, -14, 110, 13), this.getOverlayIdentifier(), new Object[0]));
    }

    public Class<? extends GuiContainer> getGuiClass() {
        return GuiArcaneWorkbench.class;
    }

    public boolean hasOverlay(GuiContainer gui, Container container, int recipe) {
        return RecipeInfo.hasDefaultOverlay((GuiContainer)gui, (String)this.getOverlayIdentifier()) || RecipeInfo.hasOverlayHandler((GuiContainer)gui, (String)this.getOverlayIdentifier());
    }

    public IRecipeOverlayRenderer getOverlayRenderer(GuiContainer gui, int recipe) {
        ArrayList<PositionedStack> ingred = new ArrayList<PositionedStack>();
        if (this.arecipes.get(recipe) != null && this.arecipes.get(recipe) instanceof ArcaneShapelessCachedRecipe) {
            ArcaneShapelessCachedRecipe arcaneRecipe = (ArcaneShapelessCachedRecipe)((Object)this.arecipes.get(recipe));
            ingred = arcaneRecipe.getPositionedStacksForOverlay();
        }
        return new ArcaneWorkbenchOverlayRenderer(ingred, (IStackPositioner)new OffsetPositioner(0, 0));
    }

    public IOverlayHandler getOverlayHandler(GuiContainer gui, int recipe) {
        return RecipeInfo.getOverlayHandler((GuiContainer)gui, (String)this.getOverlayIdentifier());
    }

    public String getOverlayIdentifier() {
        return OVERLAY_IDENTIFIER;
    }

    public String getRecipeName() {
        return StatCollector.func_74838_a((String)"recipe.type.arcaneworkbenchshapeless");
    }

    public int recipiesPerPage() {
        return 1;
    }

    public void drawExtras(int recipe) {
        NEIHelper.drawAspectsArcane(this.aspectsAmount.get(recipe));
    }

    protected static int[] getAmounts(ShapelessArcaneRecipe recipe) {
        int[] amounts = new int[Aspect.getPrimalAspects().size()];
        AspectList aspects = recipe.getAspects();
        int i = 0;
        for (Aspect aspect : Aspect.getPrimalAspects()) {
            amounts[i] = aspects.getAmount(aspect);
            ++i;
        }
        return amounts;
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals(this.getOverlayIdentifier())) {
            for (Object o : ThaumcraftApi.getCraftingRecipes()) {
                ShapelessArcaneRecipe tcRecipe;
                ArcaneShapelessCachedRecipe recipe;
                if (o == null || !(o instanceof ShapelessArcaneRecipe) || (recipe = new ArcaneShapelessCachedRecipe(tcRecipe = (ShapelessArcaneRecipe)o)) == null || !recipe.isValid() || !ThaumcraftApiHelper.isResearchComplete((String)this.username, (String)tcRecipe.getResearch())) continue;
                this.arecipes.add(recipe);
                this.aspectsAmount.add(ArcaneShapelessRecipeHandler.getAmounts(tcRecipe));
            }
        } else if (outputId.equals("item")) {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    public void loadCraftingRecipes(ItemStack result) {
        for (Object o : ThaumcraftApi.getCraftingRecipes()) {
            ShapelessArcaneRecipe tcRecipe;
            ArcaneShapelessCachedRecipe recipe;
            if (o == null || !(o instanceof ShapelessArcaneRecipe) || (recipe = new ArcaneShapelessCachedRecipe(tcRecipe = (ShapelessArcaneRecipe)o)) == null || !recipe.isValid() || !ThaumcraftApiHelper.isResearchComplete((String)this.username, (String)tcRecipe.getResearch()) || !NEIServerUtils.areStacksSameTypeCrafting((ItemStack)tcRecipe.getRecipeOutput(), (ItemStack)result)) continue;
            this.arecipes.add(recipe);
            this.aspectsAmount.add(ArcaneShapelessRecipeHandler.getAmounts(tcRecipe));
        }
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        for (Object o : ThaumcraftApi.getCraftingRecipes()) {
            ShapelessArcaneRecipe tcRecipe;
            ArcaneShapelessCachedRecipe recipe;
            if (o == null || !(o instanceof ShapelessArcaneRecipe) || (recipe = new ArcaneShapelessCachedRecipe(tcRecipe = (ShapelessArcaneRecipe)o)) == null || !recipe.isValid() || !recipe.contains(recipe.ingredients, ingredient) || !ThaumcraftApiHelper.isResearchComplete((String)this.username, (String)tcRecipe.getResearch())) continue;
            recipe.setIngredientPermutation(recipe.ingredients, ingredient);
            this.arecipes.add(recipe);
            this.aspectsAmount.add(ArcaneShapelessRecipeHandler.getAmounts(tcRecipe));
        }
    }

    public void drawBackground(int recipe) {
        int x = 34;
        int y = -15;
        UtilsFX.bindTexture((String)"textures/gui/gui_researchbook_overlay.png");
        GL11.glPushMatrix();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glEnable((int)3042);
        GL11.glTranslatef((float)x, (float)y, (float)0.0f);
        GL11.glScalef((float)1.7f, (float)1.7f, (float)1.0f);
        GuiDraw.drawTexturedModalRect((int)2, (int)23, (int)112, (int)15, (int)52, (int)52);
        GuiDraw.drawTexturedModalRect((int)20, (int)7, (int)20, (int)3, (int)16, (int)16);
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.4f);
        GL11.glEnable((int)3042);
        GL11.glTranslatef((float)x, (float)(y + 164), (float)0.0f);
        GL11.glScalef((float)2.0f, (float)2.0f, (float)1.0f);
        GuiDraw.drawTexturedModalRect((int)0, (int)0, (int)68, (int)76, (int)12, (int)12);
        GL11.glPopMatrix();
    }

    public List<PositionedStack> getIngredientStacksForOverlay(int recipe) {
        if (this.arecipes.get(recipe) instanceof ArcaneShapelessCachedRecipe) {
            return ((ArcaneShapelessCachedRecipe)((Object)this.arecipes.get(recipe))).getPositionedStacksForOverlay();
        }
        return null;
    }

    private class ArcaneShapelessCachedRecipe
    extends ShapelessRecipeHandler.CachedShapelessRecipe {
        private AspectList aspects;
        protected Object[] overlay;

        public ArcaneShapelessCachedRecipe(ShapelessArcaneRecipe recipe) {
            super((ShapelessRecipeHandler)ArcaneShapelessRecipeHandler.this, (List)recipe.getInput(), recipe.getRecipeOutput());
            this.result = new PositionedStack((Object)recipe.getRecipeOutput(), 74, 2);
            this.overlay = recipe.getInput().toArray();
            this.aspects = recipe.getAspects();
            NEIHelper.addAspectsToIngredients(this.aspects, this.ingredients, 0);
        }

        public AspectList getAspectList() {
            return this.aspects;
        }

        public boolean isValid() {
            return !this.ingredients.isEmpty() && this.result != null;
        }

        public void setIngredients(List<?> items) {
            if (!items.isEmpty()) {
                int[][] positions = new int[][]{{48, 32}, {75, 33}, {103, 33}, {49, 60}, {76, 60}, {103, 60}, {49, 87}, {76, 87}, {103, 87}};
                int shiftX = 0;
                int shiftY = 0;
                for (int x = 0; x < items.size(); ++x) {
                    if (items.get(x) == null) continue;
                    PositionedStack stack = new PositionedStack(items.get(x), positions[x][0] + shiftX, positions[x][1] + shiftY, false);
                    stack.setMaxSize(1);
                    this.ingredients.add(stack);
                }
            }
        }

        public ArrayList<PositionedStack> getPositionedStacksForOverlay() {
            ArrayList<PositionedStack> stacks = new ArrayList<PositionedStack>();
            if (this.overlay != null && this.overlay.length > 0) {
                boolean shiftX = false;
                boolean shiftY = false;
                for (int x = 0; x < this.overlay.length; ++x) {
                    if (this.overlay[x] == null || !(this.overlay[x] instanceof ItemStack) && !(this.overlay[x] instanceof ItemStack[]) && !(this.overlay[x] instanceof String) && !(this.overlay[x] instanceof List) || this.overlay[x] instanceof List && ((List)this.overlay[x]).isEmpty()) continue;
                    stacks.add(new PositionedStack(this.overlay[x], 40 + x % 3 * 24, 40 + x / 3 * 24));
                }
            }
            return stacks;
        }

        public boolean contains(Collection<PositionedStack> ingredients, ItemStack ingredient) {
            if (ingredient.func_77973_b() instanceof ItemAspect) {
                return false;
            }
            return super.contains(ingredients, ingredient);
        }
    }
}

