/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevesfactory.components;

import java.util.EnumSet;
import java.util.List;
import vswe.stevesfactory.blocks.ConnectionBlockType;
import vswe.stevesfactory.blocks.TileEntityBUD;
import vswe.stevesfactory.components.CommandExecutor;
import vswe.stevesfactory.components.ComponentMenuContainer;
import vswe.stevesfactory.components.ComponentMenuUpdateBlock;
import vswe.stevesfactory.components.ConnectionOption;
import vswe.stevesfactory.components.FlowComponent;
import vswe.stevesfactory.components.SlotInventoryHolder;
import vswe.stevesfactory.components.TriggerHelper;

public class TriggerHelperBUD
extends TriggerHelper {
    public static final int TRIGGER_BUD_BLOCK_ID = 5;

    public TriggerHelperBUD() {
        super(false, 1, 3, ConnectionBlockType.BUD);
    }

    @Override
    protected boolean isBlockPowered(FlowComponent component, int power) {
        int id = power >>> 4;
        int meta = power & 0xF;
        ComponentMenuUpdateBlock updateMenu = (ComponentMenuUpdateBlock)component.getMenus().get(5);
        if (updateMenu.useId()) {
            boolean idMatch;
            boolean bl = idMatch = id == updateMenu.getBlockId();
            if (updateMenu.isIdInverted() == idMatch) {
                return false;
            }
        }
        for (ComponentMenuUpdateBlock.MetaSetting setting : updateMenu.getMetaSettings()) {
            boolean metaMatch;
            if (!setting.inUse()) continue;
            int count = 0;
            int settingMeta = 0;
            for (int i = 0; i < setting.bits.length; ++i) {
                if (!setting.bits[i]) continue;
                settingMeta |= (meta >> i & 1) << count;
                ++count;
            }
            boolean bl = metaMatch = setting.lowerTextBox.getNumber() <= settingMeta && settingMeta <= setting.higherTextBox.getNumber();
            if (setting.inverted != metaMatch) continue;
            return false;
        }
        return true;
    }

    @Override
    public void onTrigger(FlowComponent item, EnumSet<ConnectionOption> valid) {
        List<SlotInventoryHolder> buds = CommandExecutor.getContainers(item.getManager(), item.getMenus().get(this.containerId), this.blockType);
        if (buds != null) {
            for (SlotInventoryHolder bud : buds) {
                bud.getBUD().updateData();
            }
            if (this.isSpecialPulseReceived(item, true)) {
                valid.add(ConnectionOption.BUD_PULSE_HIGH);
                valid.add(ConnectionOption.BUD_HIGH);
            } else if (this.isTriggerPowered(item, true)) {
                valid.add(ConnectionOption.BUD_HIGH);
            }
            if (this.isSpecialPulseReceived(item, false)) {
                valid.add(ConnectionOption.BUD_PULSE_LOW);
                valid.add(ConnectionOption.BUD_LOW);
            } else if (this.isTriggerPowered(item, false)) {
                valid.add(ConnectionOption.BUD_LOW);
            }
            for (SlotInventoryHolder bud : buds) {
                bud.getBUD().makeOld();
            }
        }
    }

    public void triggerBUD(FlowComponent item, TileEntityBUD tileEntityBUD) {
        List<SlotInventoryHolder> receivers = CommandExecutor.getContainers(item.getManager(), item.getMenus().get(this.containerId), this.blockType);
        if (receivers != null) {
            ComponentMenuContainer componentMenuContainer = (ComponentMenuContainer)item.getMenus().get(this.containerId);
            TileEntityBUD trigger = componentMenuContainer.getOption() == 0 ? tileEntityBUD : null;
            EnumSet<ConnectionOption> valid = EnumSet.noneOf(ConnectionOption.class);
            if (this.isTriggerPowered(item, true)) {
                valid.add(ConnectionOption.BUD);
                if (this.isPulseReceived(item, receivers, trigger, true)) {
                    valid.add(ConnectionOption.BUD_PULSE_HIGH);
                }
            } else if (this.isPulseReceived(item, receivers, trigger, false)) {
                valid.add(ConnectionOption.BUD_PULSE_LOW);
            }
            if (!valid.isEmpty()) {
                this.activateTrigger(item, valid);
            }
        }
    }
}

