/*
 * Decompiled with CFR 0.152.
 */
package squeek.spiceoflife.foodtracker;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import cpw.mods.fml.common.network.FMLNetworkEvent;
import cpw.mods.fml.relauncher.Side;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import squeek.applecore.api.food.FoodEvent;
import squeek.spiceoflife.ModConfig;
import squeek.spiceoflife.compat.PacketDispatcher;
import squeek.spiceoflife.foodtracker.FoodEaten;
import squeek.spiceoflife.foodtracker.FoodHistory;
import squeek.spiceoflife.foodtracker.MaxHealthHandler;
import squeek.spiceoflife.foodtracker.foodgroups.FoodGroupRegistry;
import squeek.spiceoflife.items.ItemFoodJournal;
import squeek.spiceoflife.network.PacketFoodEatenAllTime;
import squeek.spiceoflife.network.PacketFoodHistory;

public class FoodTracker {
    public static int getFoodHistoryLengthInRelevantUnits(EntityPlayer player) {
        return FoodHistory.get(player).getHistoryLength();
    }

    public static ItemStack getFoodLastEatenBy(EntityPlayer player) {
        return FoodHistory.get((EntityPlayer)player).getLastEatenFood().itemStack;
    }

    @SubscribeEvent
    public void onFoodEaten(FoodEvent.FoodEaten event) {
        if (event.player.field_70170_p.field_72995_K) {
            return;
        }
        FoodEaten foodEaten = new FoodEaten(event.food);
        foodEaten.foodValues = event.foodValues;
        FoodTracker.addFoodEatenByPlayer(foodEaten, event.player);
    }

    public static void addFoodEatenByPlayer(FoodEaten foodEaten, EntityPlayer player) {
        if (!player.field_70170_p.field_72995_K && player instanceof EntityPlayerMP) {
            PacketDispatcher.get().sendTo(new PacketFoodHistory(foodEaten), (EntityPlayerMP)player);
        }
        FoodHistory.get(player).addFood(foodEaten);
    }

    @SubscribeEvent
    public void onEntityConstructing(EntityEvent.EntityConstructing event) {
        if (event.entity instanceof EntityPlayer) {
            FoodHistory.get((EntityPlayer)event.entity);
        }
    }

    @SubscribeEvent
    public void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        ModConfig.sync((EntityPlayerMP)event.player);
        FoodGroupRegistry.sync((EntityPlayerMP)event.player);
        FoodHistory foodHistory = FoodHistory.get(event.player);
        foodHistory.validate();
        FoodTracker.syncFoodHistory(foodHistory);
        if (!foodHistory.wasGivenFoodJournal && ModConfig.GIVE_FOOD_JOURNAL_ON_START) {
            ItemFoodJournal.giveToPlayer(event.player);
            foodHistory.wasGivenFoodJournal = true;
        }
    }

    public static void syncFoodHistory(FoodHistory foodHistory) {
        PacketDispatcher.get().sendTo(new PacketFoodEatenAllTime(foodHistory.totalFoodsEatenAllTime), (EntityPlayerMP)foodHistory.player);
        PacketDispatcher.get().sendTo(new PacketFoodHistory(foodHistory, true), (EntityPlayerMP)foodHistory.player);
        MaxHealthHandler.updateFoodHPModifier(foodHistory.player);
    }

    @SubscribeEvent
    public void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        FoodHistory foodHistory = FoodHistory.get(event.player);
        FoodTracker.syncFoodHistory(foodHistory);
    }

    @SubscribeEvent
    public void onLivingDeathEvent(LivingDeathEvent event) {
        if (FMLCommonHandler.instance().getEffectiveSide().isClient() || !(event.entity instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)event.entity;
        FoodHistory foodHistory = FoodHistory.get(player);
        foodHistory.saveNBTData(null);
    }

    @SubscribeEvent
    public void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            return;
        }
        FoodHistory foodHistory = FoodHistory.get(event.player);
        foodHistory.loadNBTData(null);
        FoodTracker.syncFoodHistory(foodHistory);
    }

    @SubscribeEvent
    public void onClientConnectedToServer(FMLNetworkEvent.ClientConnectedToServerEvent event) {
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
            ModConfig.assumeClientOnly();
        }
    }
}

