/*
 * Decompiled with CFR 0.152.
 */
package com.github.bartimaeusnek.bartworks.common.tileentities.multis.mega;

import com.github.bartimaeusnek.bartworks.API.BorosilicateGlass;
import com.github.bartimaeusnek.bartworks.common.configs.ConfigHandler;
import com.github.bartimaeusnek.bartworks.common.tileentities.multis.mega.GT_TileEntity_MegaMultiBlockBase;
import com.github.bartimaeusnek.bartworks.util.BW_Tooltip_Reference;
import com.github.bartimaeusnek.bartworks.util.BW_Util;
import com.github.bartimaeusnek.bartworks.util.Pair;
import com.github.bartimaeusnek.bartworks.util.RecipeFinderForParallel;
import com.github.bartimaeusnek.crossmod.tectech.helper.TecTechUtils;
import com.gtnewhorizon.structurelib.alignment.constructable.ISurvivalConstructable;
import com.gtnewhorizon.structurelib.structure.IItemSource;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import cpw.mods.fml.common.Optional;
import gregtech.api.GregTech_API;
import gregtech.api.enums.GT_HatchElement;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.HeatingCoilLevel;
import gregtech.api.enums.Mods;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IHatchElement;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.interfaces.tileentity.IHasWorldObjectAndCoords;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Energy;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Input;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Output;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_MultiBlockBase;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_TieredMachineBlock;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GT_Multiblock_Tooltip_Builder;
import gregtech.api.util.GT_OverclockCalculator;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_StructureUtility;
import gregtech.api.util.GT_Utility;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;

@Optional.Interface(iface="com.github.bartimaeusnek.crossmod.tectech.TecTechEnabledMulti", modid="tectech", striprefs=true)
public class GT_TileEntity_MegaOilCracker
extends GT_TileEntity_MegaMultiBlockBase<GT_TileEntity_MegaOilCracker>
implements ISurvivalConstructable {
    private static final int CASING_INDEX = 49;
    private static final String STRUCTURE_PIECE_MAIN = "main";
    private static final IStructureDefinition<GT_TileEntity_MegaOilCracker> STRUCTURE_DEFINITION = StructureDefinition.builder().addShape("main", StructureUtility.transpose((String[][])new String[][]{{" p         p ", "ppgggggggggpp", " pgggggggggp ", " pgggpppgggp ", " pgggpMpgggp ", " pgggpppgggp ", " pgggggggggp ", "ppgggggggggpp", " p         p "}, {" p         p ", "pgggggggggggp", " g c c c c g ", " g c c c c g ", " g c c c c g ", " g c c c c g ", " g c c c c g ", "pgggggggggggp", " p         p "}, {" p         p ", "pgggggggggggp", " g c c c c g ", " p   c   c p ", " p c c c c p ", " p   c   c p ", " g c c c c g ", "pgggggggggggp", " p         p "}, {" p         p ", "pgggggggggggp", " g c c c c g ", " p c c c c p ", " l c c c c r ", " p c c c c p ", " g c c c c g ", "pgggggggggggp", " p         p "}, {" p         p ", "pgggggggggggp", " g c c c c g ", " p   c   c p ", " p c c c c p ", " p   c   c p ", " g c c c c g ", "pgggggggggggp", " p         p "}, {" p         p ", "pgggggggggggp", " g c c c c g ", " g c c c c g ", " g c c c c g ", " g c c c c g ", " g c c c c g ", "pgggggggggggp", " p         p "}, {"ppmmmm~mmmmpp", "ppppppppppppp", "ppppppppppppp", "ppppppppppppp", "ppppppppppppp", "ppppppppppppp", "ppppppppppppp", "ppppppppppppp", "ppmmmmmmmmmpp"}})).addElement('c', StructureUtility.withChannel((String)"coil", (IStructureElement)GT_StructureUtility.ofCoil(GT_TileEntity_MegaOilCracker::setCoilLevel, GT_TileEntity_MegaOilCracker::getCoilLevel))).addElement('p', StructureUtility.ofBlock((Block)GregTech_API.sBlockCasings4, (int)1)).addElement('l', GT_HatchElement.InputHatch.withAdder(GT_TileEntity_MegaOilCracker::addLeftHatchToMachineList).newAny(49, 2)).addElement('r', GT_HatchElement.OutputHatch.withAdder(GT_TileEntity_MegaOilCracker::addRightHatchToMachineList).newAny(49, 3)).addElement('m', (IStructureElement)GT_StructureUtility.buildHatchAdder(GT_TileEntity_MegaOilCracker.class).atLeast(new IHatchElement[]{GT_TileEntity_MegaMultiBlockBase.TTEnabledEnergyHatchElement.INSTANCE, GT_HatchElement.Maintenance}).casingIndex(49).dot(1).buildAndChain(GregTech_API.sBlockCasings4, 1)).addElement('M', GT_HatchElement.InputHatch.withAdder(GT_TileEntity_MegaOilCracker::addMiddleInputToMachineList).newAny(49, 4)).addElement('g', StructureUtility.withChannel((String)"glass", BorosilicateGlass.ofBoroGlass((byte)0, (byte)1, (byte)127, (te, t) -> {
        te.glasTier = t;
    }, te -> te.glasTier))).build();
    private byte glasTier;
    private HeatingCoilLevel heatLevel;
    protected final List<GT_MetaTileEntity_Hatch_Input> mMiddleInputHatches = new ArrayList<GT_MetaTileEntity_Hatch_Input>();
    protected int mInputOnSide = -1;
    protected int mOutputOnSide = -1;

    public GT_TileEntity_MegaOilCracker(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public GT_TileEntity_MegaOilCracker(String aName) {
        super(aName);
    }

    public GT_Multiblock_Tooltip_Builder createTooltip() {
        GT_Multiblock_Tooltip_Builder tt = new GT_Multiblock_Tooltip_Builder();
        tt.addMachineType("Cracker").addInfo("Controller block for the Mega Oil Cracking").addInfo("Thermally cracks heavy hydrocarbons into lighter fractions").addInfo("More efficient than the Chemical Reactor").addInfo("Gives different benefits whether it hydro or steam-cracks:").addInfo("Hydro - Consumes 20% less Hydrogen and outputs 25% more cracked fluid").addInfo("Steam - Outputs 50% more cracked fluid").addInfo("(Values compared to cracking in the Chemical Reactor)").addInfo("Place the appropriate circuit in the controller").addSeparator().beginStructureBlock(13, 7, 9, true).addController("Front bottom").addStructureInfo("The glass tier limits the Energy Input tier").addInfo("Gets 10% EU/t reduction per coil tier, up to a maximum of 50%").addEnergyHatch("Hint block", new int[]{1}).addMaintenanceHatch("Hint block", new int[]{1}).addInputHatch("Hint block", new int[]{2, 3}).addOutputHatch("Hint block", new int[]{2, 3}).addInputHatch("Steam/Hydrogen ONLY, Hint block", new int[]{4}).toolTipFinisher(BW_Tooltip_Reference.MULTIBLOCK_ADDED_BY_BARTWORKS);
        return tt;
    }

    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GT_TileEntity_MegaOilCracker(this.mName);
    }

    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, ForgeDirection side, ForgeDirection facing, int aColorIndex, boolean aActive, boolean aRedstone) {
        if (side == facing) {
            if (aActive) {
                return new ITexture[]{Textures.BlockIcons.casingTexturePages[0][49], TextureFactory.builder().addIcon(new IIconContainer[]{Textures.BlockIcons.OVERLAY_FRONT_OIL_CRACKER_ACTIVE}).extFacing().build(), TextureFactory.builder().addIcon(new IIconContainer[]{Textures.BlockIcons.OVERLAY_FRONT_OIL_CRACKER_ACTIVE_GLOW}).extFacing().glow().build()};
            }
            return new ITexture[]{Textures.BlockIcons.casingTexturePages[0][49], TextureFactory.builder().addIcon(new IIconContainer[]{Textures.BlockIcons.OVERLAY_FRONT_OIL_CRACKER}).extFacing().build(), TextureFactory.builder().addIcon(new IIconContainer[]{Textures.BlockIcons.OVERLAY_FRONT_OIL_CRACKER_GLOW}).extFacing().glow().build()};
        }
        return new ITexture[]{Textures.BlockIcons.casingTexturePages[0][49]};
    }

    public GT_Recipe.GT_Recipe_Map getRecipeMap() {
        return GT_Recipe.GT_Recipe_Map.sCrackingRecipes;
    }

    public boolean checkRecipe(ItemStack itemStack) {
        ItemStack[] tInputs = this.getStoredInputs().toArray(new ItemStack[0]);
        FluidStack[] tInputFluids = this.getStoredFluids().toArray(new FluidStack[0]);
        ArrayList<Object> outputItems = new ArrayList();
        ArrayList<Object> outputFluids = new ArrayList();
        long nominalV = Mods.TecTech.isModLoaded() ? TecTechUtils.getnominalVoltageTT(this) : BW_Util.getnominalVoltage((GT_MetaTileEntity_MultiBlockBase)this);
        byte tTier = (byte)Math.max(1, Math.min(GT_Utility.getTier((long)nominalV), GT_Values.V.length - 1));
        GT_Recipe tRecipe = this.getRecipeMap().findRecipe((IHasWorldObjectAndCoords)this.getBaseMetaTileEntity(), false, GT_Values.V[tTier], tInputFluids, new ItemStack[]{this.mInventory[1]});
        boolean found_Recipe = false;
        int processed = 0;
        if (tRecipe != null) {
            found_Recipe = true;
            long tMaxPara = Math.min((long)ConfigHandler.megaMachinesMax, nominalV / (long)tRecipe.mEUt);
            int tCurrentPara = RecipeFinderForParallel.handleParallelRecipe(tRecipe, tInputFluids, tInputs, (int)tMaxPara);
            this.updateSlots();
            if (tCurrentPara <= 0) {
                return false;
            }
            processed = tCurrentPara;
            Pair<ArrayList<FluidStack>, ArrayList<ItemStack>> Outputs = RecipeFinderForParallel.getMultiOutput(tRecipe, tCurrentPara);
            outputFluids = Outputs.getKey();
            outputItems = Outputs.getValue();
        }
        if (found_Recipe) {
            this.mEfficiency = 10000 - (this.getIdealStatus() - this.getRepairStatus()) * 1000;
            this.mEfficiencyIncrease = 10000;
            GT_OverclockCalculator calculator = new GT_OverclockCalculator().setRecipeEUt((long)tRecipe.mEUt).setParallel(processed).setDuration(tRecipe.mDuration).setEUt(nominalV).calculate();
            this.mMaxProgresstime = calculator.getDuration();
            this.lEUt = calculator.getConsumption();
            if (this.mMaxProgresstime == 0x7FFFFFFE && this.lEUt == 0x7FFFFFFEL) {
                return false;
            }
            this.lEUt = this.getCoilLevel().getTier() < 5 ? (long)((double)this.lEUt * (1.0 - 0.1 * (double)(this.getCoilLevel().getTier() + 1))) : (long)((double)this.lEUt * 0.5);
            if (this.lEUt > 0L) {
                this.lEUt = -this.lEUt;
            }
            this.mMaxProgresstime = Math.max(1, this.mMaxProgresstime);
            this.mOutputItems = new ItemStack[outputItems.size()];
            this.mOutputItems = outputItems.toArray(this.mOutputItems);
            this.mOutputFluids = new FluidStack[outputFluids.size()];
            this.mOutputFluids = outputFluids.toArray(this.mOutputFluids);
            return true;
        }
        return false;
    }

    public HeatingCoilLevel getCoilLevel() {
        return this.heatLevel;
    }

    public void setCoilLevel(HeatingCoilLevel aCoilLevel) {
        this.heatLevel = aCoilLevel;
    }

    public void construct(ItemStack aStack, boolean aHintsOnly) {
        this.buildPiece(STRUCTURE_PIECE_MAIN, aStack, aHintsOnly, 6, 6, 0);
    }

    public int survivalConstruct(ItemStack stackSize, int elementBudget, IItemSource source, EntityPlayerMP actor) {
        if (this.mMachine) {
            return -1;
        }
        int realBudget = elementBudget >= 200 ? elementBudget : Math.min(200, elementBudget * 5);
        return this.survivialBuildPiece(STRUCTURE_PIECE_MAIN, stackSize, 6, 6, 0, realBudget, source, actor, false, true);
    }

    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        this.glasTier = 0;
        this.mInputOnSide = -1;
        this.mOutputOnSide = -1;
        this.mMiddleInputHatches.clear();
        if (Mods.TecTech.isModLoaded()) {
            this.getTecTechEnergyMultis().clear();
            this.getTecTechEnergyTunnels().clear();
        }
        if (!this.checkPiece(STRUCTURE_PIECE_MAIN, 6, 6, 0)) {
            return false;
        }
        if (this.mMaintenanceHatches.size() != 1) {
            return false;
        }
        if (Mods.TecTech.isModLoaded() && this.glasTier < 8 && (!this.areLazorsLowPowa() || this.areThingsNotProperlyTiered(this.getTecTechEnergyTunnels()) || this.areThingsNotProperlyTiered(this.getTecTechEnergyMultis()))) {
            return false;
        }
        if (this.glasTier < 8 && !this.mEnergyHatches.isEmpty()) {
            for (GT_MetaTileEntity_Hatch_Energy hatchEnergy : this.mEnergyHatches) {
                if (this.glasTier >= hatchEnergy.mTier) continue;
                return false;
            }
        }
        return true;
    }

    private boolean addLeftHatchToMachineList(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        if (aTileEntity == null) {
            return false;
        }
        IMetaTileEntity aMetaTileEntity = aTileEntity.getMetaTileEntity();
        if (aMetaTileEntity == null) {
            return false;
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Input) {
            if (this.mInputOnSide == 1) {
                return false;
            }
            this.mInputOnSide = 0;
            this.mOutputOnSide = 1;
            GT_MetaTileEntity_Hatch_Input tHatch = (GT_MetaTileEntity_Hatch_Input)aMetaTileEntity;
            tHatch.updateTexture(aBaseCasingIndex);
            tHatch.mRecipeMap = this.getRecipeMap();
            return this.mInputHatches.add(tHatch);
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Output) {
            if (this.mOutputOnSide == 1) {
                return false;
            }
            this.mInputOnSide = 1;
            this.mOutputOnSide = 0;
            GT_MetaTileEntity_Hatch_Output tHatch = (GT_MetaTileEntity_Hatch_Output)aMetaTileEntity;
            tHatch.updateTexture(aBaseCasingIndex);
            return this.mOutputHatches.add(tHatch);
        }
        return false;
    }

    private boolean addRightHatchToMachineList(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        if (aTileEntity == null) {
            return false;
        }
        IMetaTileEntity aMetaTileEntity = aTileEntity.getMetaTileEntity();
        if (aMetaTileEntity == null) {
            return false;
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Input) {
            if (this.mInputOnSide == 0) {
                return false;
            }
            this.mInputOnSide = 1;
            this.mOutputOnSide = 0;
            GT_MetaTileEntity_Hatch_Input tHatch = (GT_MetaTileEntity_Hatch_Input)aMetaTileEntity;
            tHatch.updateTexture(aBaseCasingIndex);
            tHatch.mRecipeMap = this.getRecipeMap();
            return this.mInputHatches.add(tHatch);
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Output) {
            if (this.mOutputOnSide == 0) {
                return false;
            }
            this.mInputOnSide = 0;
            this.mOutputOnSide = 1;
            GT_MetaTileEntity_Hatch_Output tHatch = (GT_MetaTileEntity_Hatch_Output)aMetaTileEntity;
            tHatch.updateTexture(aBaseCasingIndex);
            return this.mOutputHatches.add(tHatch);
        }
        return false;
    }

    private boolean addMiddleInputToMachineList(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        if (aTileEntity == null) {
            return false;
        }
        IMetaTileEntity aMetaTileEntity = aTileEntity.getMetaTileEntity();
        if (aMetaTileEntity == null) {
            return false;
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Input) {
            GT_MetaTileEntity_Hatch_Input tHatch = (GT_MetaTileEntity_Hatch_Input)aMetaTileEntity;
            tHatch.updateTexture(aBaseCasingIndex);
            tHatch.mRecipeMap = this.getRecipeMap();
            return this.mMiddleInputHatches.add(tHatch);
        }
        return false;
    }

    public ArrayList<FluidStack> getStoredFluids() {
        ArrayList<FluidStack> rList = new ArrayList<FluidStack>();
        for (GT_MetaTileEntity_Hatch_Input tHatch : this.mInputHatches) {
            tHatch.mRecipeMap = this.getRecipeMap();
            if (!GT_TileEntity_MegaOilCracker.isValidMetaTileEntity((MetaTileEntity)tHatch) || tHatch.getFillableStack() == null || GT_Recipe.GT_Recipe_Map.sCrackingRecipes.isValidCatalystFluid(tHatch.getFillableStack())) continue;
            rList.add(tHatch.getFillableStack());
        }
        for (GT_MetaTileEntity_Hatch_Input tHatch : this.mMiddleInputHatches) {
            FluidStack tStack;
            tHatch.mRecipeMap = this.getRecipeMap();
            if (!GT_TileEntity_MegaOilCracker.isValidMetaTileEntity((MetaTileEntity)tHatch) || tHatch.getFillableStack() == null || !GT_Recipe.GT_Recipe_Map.sCrackingRecipes.isValidCatalystFluid(tStack = tHatch.getFillableStack())) continue;
            rList.add(tStack);
        }
        return rList;
    }

    public IStructureDefinition<GT_TileEntity_MegaOilCracker> getStructureDefinition() {
        return STRUCTURE_DEFINITION;
    }

    @Optional.Method(modid="tectech")
    private boolean areThingsNotProperlyTiered(Collection collection) {
        if (!collection.isEmpty()) {
            for (Object tecTechEnergyMulti : collection) {
                if (((GT_MetaTileEntity_TieredMachineBlock)tecTechEnergyMulti).mTier <= this.glasTier) continue;
                return true;
            }
        }
        return false;
    }
}

