/*
 * Decompiled with CFR 0.152.
 */
package chylex.hee.world.structure.island.biome.decorator;

import chylex.hee.init.BlockList;
import chylex.hee.system.util.MathUtil;
import chylex.hee.world.structure.island.biome.IslandBiomeBase;
import chylex.hee.world.structure.island.biome.IslandBiomeBurningMountains;
import chylex.hee.world.structure.island.biome.decorator.IslandBiomeDecorator;
import chylex.hee.world.structure.island.biome.feature.mountains.StructureCinderPatch;
import chylex.hee.world.structure.island.biome.feature.mountains.StructureDungeonPuzzle;
import chylex.hee.world.structure.island.biome.feature.mountains.StructureIgneousRockOre;
import chylex.hee.world.structure.island.biome.feature.mountains.StructureLavaPool;
import chylex.hee.world.structure.island.biome.feature.mountains.StructureMiningSpot;
import chylex.hee.world.structure.island.biome.feature.mountains.StructureResourcePit;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;

public class BiomeDecoratorBurningMountains
extends IslandBiomeDecorator {
    private final StructureIgneousRockOre genIgneousRockOre = new StructureIgneousRockOre();
    private final StructureCinderPatch genCinderPatch = new StructureCinderPatch();
    private final StructureDungeonPuzzle genMountainPuzzle = new StructureDungeonPuzzle();
    private final StructureLavaPool genLavaPool = new StructureLavaPool();
    private final StructureResourcePit genResourcePit = new StructureResourcePit();
    private final StructureMiningSpot genMiningSpot = new StructureMiningSpot();

    @Override
    protected final IslandBiomeBase getBiome() {
        return IslandBiomeBase.burningMountains;
    }

    public void genScorching() {
        int attempt;
        int yy;
        int zz;
        int xx;
        int a;
        int n = a = this.data.hasDeviation(IslandBiomeBurningMountains.EXCESSIVE_CINDER) ? 110 : 62;
        while (a > 0) {
            this.generateStructure(this.genCinderPatch);
            --a;
        }
        this.generateStructure(this.genMountainPuzzle);
        this.generateStructure(this.genIgneousRockOre.setAttemptAmount(110));
        int n2 = a = this.data.hasDeviation(IslandBiomeBurningMountains.SINGLE_LAVA_ONLY) ? 8000 : 6500;
        while (a > 0) {
            xx = this.getRandomXZ(this.rand, 32);
            zz = this.getRandomXZ(this.rand, 32);
            yy = 10 + this.rand.nextInt(65);
            if (this.world.getBlock(xx, yy, zz) == Blocks.field_150377_bs && (this.world.isAir(xx + 1, yy, zz) || this.world.isAir(xx - 1, yy, zz) || this.world.isAir(xx, yy, zz + 1) || this.world.isAir(xx, yy, zz - 1))) {
                this.world.setBlock(xx, yy, zz, (Block)Blocks.field_150356_k, 0, true);
            }
            --a;
        }
        if (!this.data.hasDeviation(IslandBiomeBurningMountains.SINGLE_LAVA_ONLY)) {
            int placed = 0;
            int placedMax = 4 + this.rand.nextInt(10);
            for (attempt = 0; attempt < 550 && placed < placedMax; ++attempt) {
                if (!this.generateStructure(this.genLavaPool)) continue;
                ++placed;
            }
        }
        for (int cx = 0; cx < this.world.getChunkAmountX(); ++cx) {
            for (int cz = 0; cz < this.world.getChunkAmountZ(); ++cz) {
                if (this.rand.nextInt(4) > 1) continue;
                for (int a2 = 0; a2 < 1 + this.rand.nextInt(6) + this.rand.nextInt(5); ++a2) {
                    int zz2;
                    int yy2;
                    int xx2 = cx * 16 + this.rand.nextInt(16);
                    if (this.world.getBlock(xx2, yy2 = this.world.getHighestY(xx2, zz2 = cz * 16 + this.rand.nextInt(16)), zz2) != BlockList.end_terrain) continue;
                    this.world.setBlock(xx2, yy2 + 1, zz2, BlockList.crossed_decoration, 6);
                }
            }
        }
        for (attempt = 0; attempt < 420; ++attempt) {
            xx = this.getRandomXZ(this.rand, 48);
            zz = this.getRandomXZ(this.rand, 48);
            yy = 10 + this.rand.nextInt(65);
            if (this.world.isAir(xx, yy, zz)) continue;
            int lava = 0;
            for (int lavaCheck = 0; lavaCheck < 25 && lava < 5; ++lavaCheck) {
                if (this.world.getBlock(xx + this.rand.nextInt(11) - 5, yy + this.rand.nextInt(4), zz + this.rand.nextInt(11) - 5).func_149688_o() != Material.field_151587_i) continue;
                ++lava;
            }
            block8: for (int placeAttempt = 40 + (7 - lava) * 5; placeAttempt > 0; --placeAttempt) {
                int px = xx + MathUtil.floor((this.rand.nextDouble() - 0.5) * this.rand.nextDouble() * 65.0);
                int pz = zz + MathUtil.floor((this.rand.nextDouble() - 0.5) * this.rand.nextDouble() * 65.0);
                for (int yAttempt = 0; yAttempt < 8; ++yAttempt) {
                    int py = yy + this.rand.nextInt(11) - 5;
                    if (!this.world.isAir(px, py, pz) || this.world.getBlock(px, py - 1, pz) != BlockList.end_terrain) continue;
                    this.world.setBlock(px, py, pz, BlockList.crossed_decoration, this.rand.nextInt(3) == 0 ? 10 : (this.rand.nextBoolean() ? 11 : 12));
                    continue block8;
                }
            }
        }
    }

    public void genMine() {
        int placed = 0;
        int placedMax = 3 + this.rand.nextInt(3 + this.rand.nextInt(4));
        for (int attempt = 0; attempt < 12 && placed < placedMax; ++attempt) {
            if (!this.generateStructure(this.genResourcePit)) continue;
            ++placed;
        }
        int[] flameweed = new int[]{10, 11, 12};
        for (int type = 0; type < 3; ++type) {
            block2: for (int attempt = this.rand.nextInt(300) + 750; attempt > 0; --attempt) {
                int xx = this.getRandomXZ(this.rand, 8);
                int zz = this.getRandomXZ(this.rand, 8);
                int yy = 60 - this.rand.nextInt(20 + this.rand.nextInt(32));
                for (int yAttempt = 0; yAttempt < 10; ++yAttempt) {
                    if (!this.world.isAir(xx, ++yy, zz) || this.world.getBlock(xx, yy - 1, zz) != BlockList.end_terrain) continue;
                    this.world.setBlock(xx, yy, zz, BlockList.crossed_decoration, flameweed[type]);
                    continue block2;
                }
            }
        }
        this.genMiningSpot.regenerateOreWeightList(this.rand, this.data);
        int attemptAmount = 90 + this.rand.nextInt(20);
        int placed2 = 0;
        for (int attempt = 0; attempt < attemptAmount; ++attempt) {
            if (!this.generateStructure(this.genMiningSpot)) continue;
            if (++placed2 < 50 && this.rand.nextInt(5) != 0) {
                --attempt;
                continue;
            }
            if (!this.rand.nextBoolean()) continue;
            --attemptAmount;
        }
        this.generateStructure(this.genIgneousRockOre.setAttemptAmount(165));
    }
}

