/*
 * Decompiled with CFR 0.152.
 */
package chylex.hee.tileentity;

import chylex.hee.entity.fx.FXType;
import chylex.hee.init.BlockList;
import chylex.hee.init.ItemList;
import chylex.hee.mechanics.enhancements.EnhancementEnumHelper;
import chylex.hee.mechanics.enhancements.EnhancementHandler;
import chylex.hee.mechanics.enhancements.IEnhanceableTile;
import chylex.hee.mechanics.enhancements.types.EssenceAltarEnhancements;
import chylex.hee.mechanics.essence.EssenceType;
import chylex.hee.mechanics.essence.ItemUseCache;
import chylex.hee.mechanics.essence.RuneItem;
import chylex.hee.mechanics.essence.handler.AltarActionHandler;
import chylex.hee.packets.AbstractPacket;
import chylex.hee.packets.PacketPipeline;
import chylex.hee.packets.client.C00ClearInventorySlot;
import chylex.hee.packets.client.C17AltarRuneItemEffect;
import chylex.hee.packets.client.C20Effect;
import chylex.hee.system.achievements.AchievementManager;
import chylex.hee.system.logging.Log;
import chylex.hee.system.util.BlockPosM;
import chylex.hee.system.util.MathUtil;
import chylex.hee.tileentity.TileEntityAbstractSynchronized;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.stats.StatBase;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;

public class TileEntityEssenceAltar
extends TileEntityAbstractSynchronized
implements IEnhanceableTile {
    public static final byte STAGE_BASIC = 0;
    public static final byte STAGE_HASTYPE = 1;
    public static final byte STAGE_WORKING = 2;
    private EssenceType essenceType = EssenceType.INVALID;
    private int essenceLevel;
    private byte currentStage;
    private RuneItem[] runeItems = new RuneItem[8];
    private byte runeItemIndex = (byte)-2;
    private AltarActionHandler actionHandler;
    private final Map<String, ItemUseCache> playerItemCache = new HashMap<String, ItemUseCache>();
    private List<Enum> enhancementList = new ArrayList<Enum>();

    public void loadFromDamage(int damage) {
        this.essenceType = EssenceType.getById(damage);
        if (this.essenceType != EssenceType.INVALID) {
            this.currentStage = (byte)2;
            this.createActionHandler();
            this.runeItemIndex = (byte)-1;
        }
    }

    public EssenceType getEssenceType() {
        return this.essenceType;
    }

    public int getEssenceLevel() {
        return this.essenceLevel;
    }

    public AltarActionHandler getActionHandler() {
        return this.actionHandler;
    }

    public byte getStage() {
        return this.currentStage;
    }

    public RuneItem[] getRuneItems() {
        return this.runeItems;
    }

    public ItemStack getShowedRuneItem() {
        return this.runeItemIndex < 0 || this.runeItemIndex >= this.runeItems.length ? null : (this.runeItems[this.runeItemIndex] == null ? null : this.runeItems[this.runeItemIndex].getShowcaseItem());
    }

    public byte getRuneItemIndex() {
        return this.runeItemIndex;
    }

    public void drainEssence(int amount) {
        this.essenceLevel = Math.max(this.essenceLevel - amount, 0);
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    @Override
    public List<Enum> getEnhancements() {
        return this.enhancementList;
    }

    @Override
    public ItemStack createEnhancedItemStack() {
        return EnhancementHandler.addEnhancements(new ItemStack(BlockList.essence_altar, 1, (int)this.essenceType.id), this.enhancementList);
    }

    @Override
    public NBTTagCompound writeTileToNBT(NBTTagCompound nbt) {
        nbt.func_74774_a("stage", this.currentStage);
        nbt.func_74774_a("essenceTypeId", this.essenceType.id);
        nbt.func_74768_a("essence", this.essenceLevel);
        NBTTagList runeTag = new NBTTagList();
        for (int a = 0; a < this.runeItems.length; ++a) {
            runeTag.func_74742_a((NBTBase)new NBTTagByte(this.runeItems[a] == null ? (byte)-1 : this.runeItems[a].indexInArray));
        }
        nbt.func_74782_a("runeItems", (NBTBase)runeTag);
        nbt.func_74774_a("runeIndex", this.runeItemIndex);
        nbt.func_74778_a("enhancements", EnhancementEnumHelper.serialize(this.enhancementList));
        if (this.actionHandler != null) {
            this.actionHandler.onTileWriteToNBT(nbt);
        }
        return nbt;
    }

    @Override
    public void readTileFromNBT(NBTTagCompound nbt) {
        this.currentStage = nbt.func_74771_c("stage");
        this.essenceType = EssenceType.getById(nbt.func_74771_c("essenceTypeId"));
        this.essenceLevel = nbt.func_74762_e("essence");
        NBTTagList runeTag = nbt.func_150295_c("runeItems", 1);
        for (int a = 0; a < Math.min(this.runeItems.length, runeTag.func_74745_c()); ++a) {
            String str = runeTag.func_150307_f(a);
            byte data = Byte.parseByte(str.endsWith("b") ? str.substring(0, str.length() - 1) : str);
            if (data == -1) continue;
            this.runeItems[a] = this.essenceType.itemsNeeded[data];
        }
        this.runeItemIndex = nbt.func_74771_c("runeIndex");
        this.enhancementList = EnhancementEnumHelper.deserialize(nbt.func_74779_i("enhancements"), EssenceAltarEnhancements.class);
        if (this.currentStage == 2) {
            this.createActionHandler();
            this.actionHandler.onTileReadFromNBT(nbt);
        }
    }

    public void func_145845_h() {
        if (this.currentStage == 2) {
            if (!this.field_145850_b.field_72995_K) {
                this.actionHandler.onUpdate();
            } else {
                this.actionHandler.onClientUpdate();
            }
        }
    }

    private void createActionHandler() {
        try {
            this.actionHandler = this.essenceType.actionHandlerClass.getConstructor(TileEntityEssenceAltar.class).newInstance(this);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            Log.throwable(e, "Unable to create AltarActionHandler!", new Object[0]);
        }
    }

    private void addOrRenewCache(EntityPlayer player, ItemStack is) {
        ItemUseCache cache = this.playerItemCache.get(player.func_70005_c_());
        if (cache == null || is.func_77973_b() != cache.item || is.func_77960_j() != cache.damage) {
            this.playerItemCache.put(player.func_70005_c_(), new ItemUseCache(is));
        } else {
            cache.renewTime();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void onRightClick(EntityPlayer player) {
        int giveAmount;
        ItemStack is = player.field_71071_by.func_70448_g();
        if (is == null) {
            ItemUseCache cache = this.playerItemCache.get(player.func_70005_c_());
            if (cache == null) {
                return;
            }
            if (cache.getElapsedTime() > 1500000000L) {
                this.playerItemCache.remove(player.func_70005_c_());
                return;
            }
            boolean found = false;
            for (int a = 0; a < player.field_71071_by.func_70302_i_(); a = (int)((byte)(a + 1))) {
                ItemStack invIs = player.field_71071_by.func_70301_a(a);
                if (invIs == null || invIs.func_77973_b() != cache.item || invIs.func_77960_j() != cache.damage) continue;
                player.field_71071_by.field_70462_a[player.field_71071_by.field_70461_c] = is = invIs;
                player.field_71071_by.func_70299_a(a, null);
                PacketPipeline.sendToPlayer(player, new C00ClearInventorySlot(a));
                found = true;
                break;
            }
            if (!found) {
                this.playerItemCache.remove(player.func_70005_c_());
                return;
            }
        }
        if (is == null) {
            return;
        }
        int n = player.field_71075_bZ.field_75098_d ? (player.func_70093_af() ? 1 : 32) : (giveAmount = Math.min(is.field_77994_a, player.func_70093_af() ? 1 : 32));
        if (is.func_77973_b() == ItemList.essence) {
            if (this.currentStage == 0) {
                this.essenceType = EssenceType.getById(is.func_77960_j() + 1);
                this.currentStage = 1;
                giveAmount = 1;
                this.runeItemIndex = 0;
                ArrayList<RuneItem> availableItems = new ArrayList<RuneItem>(this.essenceType.itemsNeeded.length * 2);
                for (RuneItem item : this.essenceType.itemsNeeded) {
                    availableItems.add(item);
                    availableItems.add(item);
                }
                for (int a = 0; a < this.runeItems.length; ++a) {
                    this.runeItems[a] = (RuneItem)availableItems.remove(this.field_145850_b.field_73012_v.nextInt(availableItems.size()));
                }
                PacketPipeline.sendToAllAround(this, 64.0, (AbstractPacket)new C20Effect(FXType.Basic.ESSENCE_ALTAR_SMOKE, this));
            } else {
                if (this.currentStage != 2 || is.func_77960_j() != this.essenceType.id - 1) return;
                this.essenceLevel += giveAmount;
            }
        } else if (this.currentStage == 1) {
            if (this.runeItems[this.runeItemIndex] == null || !this.runeItems[this.runeItemIndex].selector.isValid(is)) return;
            PacketPipeline.sendToAllAround(this, 32.0, (AbstractPacket)new C17AltarRuneItemEffect(this, this.runeItems[this.runeItemIndex].indexInArray));
            giveAmount = 1;
            this.runeItems[this.runeItemIndex] = null;
            this.runeItemIndex = (byte)(this.runeItemIndex + 1);
            if (this.runeItemIndex >= this.runeItems.length) {
                this.currentStage = (byte)2;
                this.createActionHandler();
                this.runeItemIndex = (byte)-1;
                ++this.essenceLevel;
                byte by = this.essenceType.id;
                this.field_145847_g = by;
                BlockPosM.tmp(this.field_145851_c, this.field_145848_d, this.field_145849_e).setMetadata(this.field_145850_b, by);
                if (this.essenceType == EssenceType.DRAGON) {
                    player.func_71064_a((StatBase)AchievementManager.DRAGON_ESSENCE, 1);
                }
            }
        } else {
            if (this.currentStage != 2) return;
            if (!this.actionHandler.onRightClick(player, is) || player.field_71075_bZ.field_75098_d) return;
            --is.field_77994_a;
            return;
        }
        this.addOrRenewCache(player, is);
        if (!player.field_71075_bZ.field_75098_d) {
            is.field_77994_a -= giveAmount;
        }
        this.synchronize();
    }

    public void onBlockDestroy() {
        if (this.currentStage == 1) {
            this.field_145850_b.func_72838_d((Entity)TileEntityEssenceAltar.createItem(this, new ItemStack(ItemList.essence, 1, (int)this.essenceType.getItemDamage())));
        }
        int essence16 = MathUtil.floor((float)this.essenceLevel / 16.0f);
        ItemStack is16 = new ItemStack(ItemList.essence, 16, (int)this.essenceType.getItemDamage());
        for (int a = 0; a < essence16; ++a) {
            this.field_145850_b.func_72838_d((Entity)TileEntityEssenceAltar.createItem(this, is16.func_77946_l()));
        }
        if (this.essenceLevel - 16 * essence16 > 0) {
            this.field_145850_b.func_72838_d((Entity)TileEntityEssenceAltar.createItem(this, new ItemStack(ItemList.essence, this.essenceLevel - 16 * essence16, (int)this.essenceType.getItemDamage())));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return AxisAlignedBB.func_72330_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, (double)(this.field_145851_c + 1), (double)(this.field_145848_d + 3), (double)(this.field_145849_e + 1));
    }

    private static EntityItem createItem(TileEntity tile, ItemStack is) {
        EntityItem item = new EntityItem(tile.func_145831_w(), (double)tile.field_145851_c + 0.5, (double)tile.field_145848_d + 1.175, (double)tile.field_145849_e + 0.5, is);
        item.field_145804_b = 5;
        item.field_70179_y = 0.0;
        item.field_70159_w = 0.0;
        item.field_70181_x = 0.0 + 0.02;
        return item;
    }
}

