/*
 * Decompiled with CFR 0.152.
 */
package chylex.hee.system.util;

import cpw.mods.fml.common.registry.GameRegistry;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import org.apache.commons.lang3.ArrayUtils;

public class ItemPattern {
    private String prefix = "";
    private String name = "*";
    private boolean nameWildcard = true;
    private short[] damageValues = ArrayUtils.EMPTY_SHORT_ARRAY;
    private NBTTagCompound nbt;

    public ItemPattern setItemName(String prefix, String name) {
        this.prefix = prefix;
        this.name = name;
        this.nameWildcard = name.equals("*");
        if (!this.nameWildcard && prefix.isEmpty()) {
            prefix = "minecraft";
        }
        return this;
    }

    public ItemPattern setDamageValues(int[] values) {
        if (values != null) {
            this.damageValues = new short[values.length];
            for (int a = 0; a < values.length; ++a) {
                this.damageValues[a] = (short)values[a];
            }
        }
        return this;
    }

    public ItemPattern setNBT(NBTTagCompound nbt) {
        if (nbt == null) {
            this.nbt = null;
        } else if (!nbt.func_82582_d()) {
            this.nbt = nbt;
        }
        return this;
    }

    public boolean matches(ItemStack is) {
        if (!this.nameWildcard || !this.prefix.isEmpty()) {
            GameRegistry.UniqueIdentifier id = GameRegistry.findUniqueIdentifierFor((Item)is.func_77973_b());
            if (!this.prefix.equals(id.modId) || !this.nameWildcard && !this.name.equals(id.name)) {
                return false;
            }
        }
        if (this.damageValues.length != 0 && !ArrayUtils.contains((short[])this.damageValues, (short)((short)is.func_77960_j()))) {
            return false;
        }
        return this.nbt == null || is.func_77942_o() && this.nbt.equals((Object)is.func_77978_p());
    }

    public boolean matchesAnyDamage() {
        return this.damageValues.length == 0;
    }

    public ArrayList<ItemStack> retainMatching(Collection<ItemStack> coll) {
        ArrayList<ItemStack> retained = new ArrayList<ItemStack>();
        for (ItemStack is : coll) {
            if (!this.matches(is)) continue;
            retained.add(is);
        }
        return retained;
    }
}

