/*
 * Decompiled with CFR 0.152.
 */
package chylex.hee.mechanics.curse;

import chylex.hee.entity.fx.FXType;
import chylex.hee.init.ItemList;
import chylex.hee.mechanics.curse.ICurseCaller;
import chylex.hee.mechanics.curse.ICurseHandler;
import chylex.hee.packets.AbstractPacket;
import chylex.hee.packets.PacketPipeline;
import chylex.hee.packets.client.C21EffectEntity;
import chylex.hee.packets.client.C22EffectLine;
import chylex.hee.system.util.BlockPosM;
import chylex.hee.system.util.ColorUtil;
import chylex.hee.system.util.MathUtil;
import chylex.hee.system.util.ReflectionUtils;
import gnu.trove.list.array.TIntArrayList;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.monster.EntityGhast;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.world.IBlockAccess;

public enum CurseType {
    TELEPORTATION(0, new ICurseHandler(){

        @Override
        public boolean tickEntity(EntityLivingBase entity, ICurseCaller caller) {
            NBTTagCompound nbt = entity.getEntityData();
            if (!nbt.func_74764_b("HEE_C0_t")) {
                nbt.func_74774_a("HEE_C0_t", (byte)0);
                return false;
            }
            byte timer = nbt.func_74771_c("HEE_C0_t");
            boolean hasTeleported = false;
            if (timer == 0) {
                Random rand = entity.func_70681_au();
                timer = (byte)(20 + rand.nextInt(60));
                double prevX = entity.field_70165_t;
                double prevY = entity.field_70163_u;
                double prevZ = entity.field_70161_v;
                for (int attempt = 0; attempt < 200; ++attempt) {
                    double tpX = prevX + (rand.nextDouble() - 0.5) * 64.0;
                    double tpY = prevY + (double)rand.nextInt(64) - 32.0;
                    double tpZ = prevZ + (rand.nextDouble() - 0.5) * 64.0;
                    BlockPosM pos = BlockPosM.tmp(tpX, tpY, tpZ);
                    if (entity.field_70170_p.func_72899_e(pos.x, pos.y, pos.z)) {
                        boolean foundTopBlock = false;
                        while (!foundTopBlock && pos.y > 0) {
                            if (pos.moveDown().getMaterial((IBlockAccess)entity.field_70170_p).func_76230_c()) {
                                foundTopBlock = true;
                                continue;
                            }
                            tpY -= 1.0;
                        }
                        if (foundTopBlock) {
                            entity.func_70634_a(tpX, tpY, tpZ);
                            if (entity.field_70170_p.func_72945_a((Entity)entity, entity.field_70121_D).isEmpty() && !entity.field_70170_p.func_72953_d(entity.field_70121_D)) {
                                hasTeleported = true;
                            }
                        }
                    }
                    if (hasTeleported) {
                        if (!entity.field_70170_p.field_72995_K) {
                            PacketPipeline.sendToAllAround((Entity)entity, 256.0, (AbstractPacket)new C22EffectLine(FXType.Line.ENDERMAN_TELEPORT, prevX, prevY, prevZ, tpX, tpY, tpZ));
                            PacketPipeline.sendToAllAround((Entity)entity, 256.0, (AbstractPacket)new C21EffectEntity(FXType.Entity.SIMPLE_TELEPORT_NOSOUND, prevX, prevY, prevZ, entity.field_70130_N, entity.field_70131_O));
                        }
                        break;
                    }
                    entity.func_70107_b(prevX, prevY, prevZ);
                }
            } else {
                timer = (byte)(timer - 1);
            }
            nbt.func_74774_a("HEE_C0_t", timer);
            return hasTeleported;
        }

        @Override
        public void end(EntityLivingBase entity, ICurseCaller caller) {
            entity.getEntityData().func_82580_o("HEE_C0_t");
        }
    }),
    CONFUSION(1, new ICurseHandler(){

        @Override
        public boolean tickEntity(EntityLivingBase entity, ICurseCaller caller) {
            NBTTagCompound nbt = entity.getEntityData();
            int cooldown = nbt.func_74771_c("HEE_C1_c");
            if (cooldown > 0) {
                cooldown = (byte)(cooldown - 1);
            }
            if (entity instanceof EntityCreature) {
                EntityLiving newTarget;
                EntityCreature creature = (EntityCreature)entity;
                Entity target = creature.func_70777_m();
                if (target == null) {
                    target = creature.func_70638_az();
                }
                if ((target == null || target instanceof EntityPlayer) && (newTarget = this.getMob((EntityLiving)creature, 16.0)) != null) {
                    cooldown = 60;
                    creature.func_70784_b((Entity)newTarget);
                    creature.func_70624_b((EntityLivingBase)newTarget);
                }
            } else if (entity instanceof EntityGhast) {
                EntityLiving newTarget;
                EntityGhast ghast = (EntityGhast)entity;
                Entity target = (Entity)ReflectionUtils.getFieldValue(ghast, "targetedEntity");
                if ((target == null || target instanceof EntityPlayer) && (newTarget = this.getMob((EntityLiving)ghast, 64.0)) != null) {
                    cooldown = 60;
                    ReflectionUtils.setFieldValue(ghast, "targetedEntity", newTarget);
                }
            } else {
                return true;
            }
            nbt.func_74774_a("HEE_C1_c", (byte)cooldown);
            return cooldown == 60;
        }

        private EntityLiving getMob(EntityLiving me, double dist) {
            ArrayList<EntityLiving> mobs = new ArrayList<EntityLiving>();
            for (EntityLiving entity : me.field_70170_p.func_72872_a(EntityLiving.class, me.field_70121_D.func_72314_b(dist, dist / 2.0, dist))) {
                if (entity == me || (double)me.func_70032_d((Entity)entity) > dist) continue;
                mobs.add(entity);
            }
            return mobs.isEmpty() ? null : (EntityLiving)mobs.get(me.func_70681_au().nextInt(mobs.size()));
        }

        @Override
        public void end(EntityLivingBase entity, ICurseCaller caller) {
            entity.getEntityData().func_82580_o("HEE_C1_t");
        }
    }),
    TRANQUILITY(2, new ICurseHandler(){
        private AttributeModifier noNavigation = new AttributeModifier("HEE NoNavigationCurse", -1.0, 2);

        @Override
        public boolean tickEntity(EntityLivingBase entity, ICurseCaller caller) {
            if (!(entity instanceof EntityLiving)) {
                return true;
            }
            if (entity.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111127_a(this.noNavigation.func_111167_a()) == null) {
                entity.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111121_a(this.noNavigation);
            }
            if (entity instanceof EntityCreature) {
                EntityCreature creature = (EntityCreature)entity;
                if (creature.func_70777_m() != null) {
                    creature.func_70784_b(null);
                }
                if (creature.func_70638_az() != null) {
                    creature.func_70624_b(null);
                }
            } else if (entity instanceof EntityGhast) {
                ReflectionUtils.setFieldValue(entity, "targetedEntity", null);
            }
            return entity.field_70173_aa % 20 == 0;
        }

        @Override
        public void end(EntityLivingBase entity, ICurseCaller caller) {
            if (entity instanceof EntityLiving) {
                entity.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111124_b(this.noNavigation);
            }
        }
    }),
    SLOWNESS(3, new ICurseHandler(){

        @Override
        public boolean tickEntity(EntityLivingBase entity, ICurseCaller caller) {
            PotionEffect eff = entity.func_70660_b(Potion.field_76421_d);
            if (eff == null || eff.func_76458_c() < 1 || eff.func_76459_b() < 25) {
                entity.func_70690_d(new PotionEffect(Potion.field_76421_d.func_76396_c(), 125, 1, true));
                return true;
            }
            return false;
        }

        @Override
        public void end(EntityLivingBase entity, ICurseCaller caller) {
            entity.func_70690_d(new PotionEffect(Potion.field_76421_d.func_76396_c(), 125, 1, true));
        }
    }),
    WEAKNESS(4, new ICurseHandler(){

        @Override
        public boolean tickEntity(EntityLivingBase entity, ICurseCaller caller) {
            PotionEffect eff = entity.func_70660_b(Potion.field_76437_t);
            if (eff == null || eff.func_76458_c() < 1 || eff.func_76459_b() < 25) {
                entity.func_70690_d(new PotionEffect(Potion.field_76437_t.func_76396_c(), 125, 1, true));
                return true;
            }
            return false;
        }

        @Override
        public void end(EntityLivingBase entity, ICurseCaller caller) {
            entity.func_70690_d(new PotionEffect(Potion.field_76437_t.func_76396_c(), 125, 1, true));
        }
    }),
    BLINDNESS(5, new ICurseHandler(){

        @Override
        public boolean tickEntity(EntityLivingBase entity, ICurseCaller caller) {
            PotionEffect eff = entity.func_70660_b(Potion.field_76440_q);
            if (eff == null || eff.func_76459_b() < 25) {
                entity.func_70690_d(new PotionEffect(Potion.field_76440_q.func_76396_c(), 125, 0, true));
                return true;
            }
            return false;
        }

        @Override
        public void end(EntityLivingBase entity, ICurseCaller caller) {
            entity.func_70690_d(new PotionEffect(Potion.field_76440_q.func_76396_c(), 125, 1, true));
        }
    }),
    DEATH(6, new ICurseHandler(){

        @Override
        public boolean tickEntity(EntityLivingBase entity, ICurseCaller caller) {
            if (entity.field_70737_aN == 0) {
                entity.func_70097_a(DamageSource.field_76376_m, 1.5f);
                return true;
            }
            return false;
        }

        @Override
        public void end(EntityLivingBase entity, ICurseCaller caller) {
        }
    }),
    DECAY(7, new ICurseHandler(){

        @Override
        public boolean tickEntity(EntityLivingBase entity, ICurseCaller caller) {
            Random rand = entity.func_70681_au();
            NBTTagCompound nbt = entity.getEntityData();
            byte timer = nbt.func_74771_c("HEE_C7_t");
            if (timer == 0) {
                timer = (byte)(21 + rand.nextInt(20));
            } else if ((timer = (byte)(timer - 1)) == 1) {
                if (entity instanceof EntityPlayer) {
                    EntityPlayer player = (EntityPlayer)entity;
                    TIntArrayList indexes = new TIntArrayList();
                    for (int a = -4; a < player.field_71071_by.field_70462_a.length; ++a) {
                        indexes.add(a);
                    }
                    while (!indexes.isEmpty()) {
                        int index = indexes.get(rand.nextInt(indexes.size()));
                        indexes.remove(index);
                        ItemStack is = index < 0 ? player.field_71071_by.field_70460_b[4 + index] : player.field_71071_by.field_70462_a[index];
                        if (is == null || !is.func_77984_f()) continue;
                        is.func_77964_b(is.func_77960_j() + 1 + rand.nextInt(3));
                        player.func_70669_a(is);
                        if (is.func_77960_j() < is.func_77958_k()) break;
                        if (index < 0) {
                            player.field_71071_by.field_70460_b[4 + index] = null;
                        } else {
                            player.field_71071_by.field_70462_a[index] = null;
                        }
                        break;
                    }
                } else if (entity instanceof EntityLiving) {
                    EntityLiving living = (EntityLiving)entity;
                    ItemStack[] equipment = living.func_70035_c();
                    TIntArrayList indexes = new TIntArrayList();
                    for (int a = 0; a < equipment.length; ++a) {
                        indexes.add(a);
                    }
                    while (!indexes.isEmpty()) {
                        int index = indexes.get(rand.nextInt(indexes.size()));
                        indexes.remove(index);
                        if (equipment[index] == null || !equipment[index].func_77984_f()) continue;
                        equipment[index].func_77964_b(equipment[index].func_77952_i() + 1 + rand.nextInt(3));
                        living.func_70669_a(equipment[index]);
                        if (equipment[index].func_77952_i() < equipment[index].func_77958_k()) break;
                        ((EntityLiving)entity).func_70062_b(index, null);
                        break;
                    }
                }
                timer = (byte)(timer - 1);
                nbt.func_74774_a("HEE_C7_t", timer);
                return true;
            }
            nbt.func_74774_a("HEE_C7_t", timer);
            return false;
        }

        @Override
        public void end(EntityLivingBase entity, ICurseCaller caller) {
            entity.getEntityData().func_82580_o("HEE_C7_t");
        }
    }),
    VAMPIRE(8, new ICurseHandler(){

        @Override
        public boolean tickEntity(EntityLivingBase entity, ICurseCaller caller) {
            if (entity.field_70173_aa % 20 == 0) {
                if (entity.field_70170_p.func_72935_r() && entity.func_70013_c(1.0f) > 0.5f && entity.field_70170_p.func_72937_j(MathUtil.floor(entity.field_70165_t), MathUtil.floor(entity.field_70163_u), MathUtil.floor(entity.field_70161_v))) {
                    entity.field_70172_ad = 0;
                    entity.func_70097_a(DamageSource.field_76370_b, 1.0f);
                    entity.func_70015_d(8);
                }
                return true;
            }
            return false;
        }

        @Override
        public void end(EntityLivingBase entity, ICurseCaller caller) {
        }
    }),
    REBOUND(9, new ICurseHandler(){

        @Override
        public boolean tickEntity(EntityLivingBase entity, ICurseCaller caller) {
            NBTTagCompound nbt = entity.getEntityData();
            nbt.func_74772_a("HEE_C9_l", entity.field_70170_p.func_82737_E());
            if (nbt.func_74767_n("HEE_C9_a")) {
                nbt.func_82580_o("HEE_C9_a");
                return true;
            }
            return false;
        }

        @Override
        public void end(EntityLivingBase entity, ICurseCaller caller) {
            entity.getEntityData().func_82580_o("HEE_C9_l");
        }
    }),
    LOSS(10, new ICurseHandler(){

        @Override
        public boolean tickEntity(EntityLivingBase entity, ICurseCaller caller) {
            Random rand = entity.func_70681_au();
            NBTTagCompound nbt = entity.getEntityData();
            byte timer = nbt.func_74771_c("HEE_C10_t");
            if (timer == 0) {
                timer = (byte)(61 + rand.nextInt(60));
            } else if ((timer = (byte)(timer - 1)) == 1) {
                if (entity instanceof EntityPlayer) {
                    EntityPlayer player = (EntityPlayer)entity;
                    TIntArrayList indexes = new TIntArrayList();
                    for (int a = -4; a < player.field_71071_by.field_70462_a.length; ++a) {
                        indexes.add(a);
                    }
                    while (!indexes.isEmpty()) {
                        ItemStack is;
                        int index = indexes.get(rand.nextInt(indexes.size()));
                        indexes.remove(index);
                        ItemStack itemStack = is = index < 0 ? player.field_71071_by.field_70460_b[4 + index] : player.field_71071_by.field_70462_a[index];
                        if (is == null) continue;
                        player.func_146097_a(is, false, true);
                        if (index < 0) {
                            player.field_71071_by.field_70460_b[4 + index] = null;
                        } else {
                            player.field_71071_by.field_70462_a[index] = null;
                        }
                        break;
                    }
                } else if (entity instanceof EntityLiving) {
                    EntityLiving living = (EntityLiving)entity;
                    ItemStack[] equipment = living.func_70035_c();
                    TIntArrayList indexes = new TIntArrayList();
                    for (int a = 0; a < equipment.length; ++a) {
                        indexes.add(a);
                    }
                    while (!indexes.isEmpty()) {
                        int index = indexes.get(rand.nextInt(indexes.size()));
                        indexes.remove(index);
                        float[] equipmentDropChances = (float[])ReflectionUtils.getFieldValue(living, "equipmentDropChances");
                        if (equipment[index] == null || MathUtil.floatEquals(equipmentDropChances[index], 0.0f)) continue;
                        ItemStack is = equipment[index];
                        if (equipmentDropChances[index] <= 1.0f && is.func_77984_f()) {
                            int maxDmg = Math.max(is.func_77958_k() - 25, 1);
                            int dmg = is.func_77958_k() - rand.nextInt(rand.nextInt(maxDmg) + 1);
                            if (dmg > maxDmg) {
                                dmg = maxDmg;
                            }
                            is.func_77964_b(Math.max(dmg, 1));
                        }
                        living.func_70099_a(is, 0.0f);
                        living.func_70062_b(index, null);
                        break;
                    }
                }
                timer = (byte)(timer - 1);
                nbt.func_74774_a("HEE_C10_t", timer);
                return true;
            }
            nbt.func_74774_a("HEE_C10_t", timer);
            return false;
        }

        @Override
        public void end(EntityLivingBase entity, ICurseCaller caller) {
            entity.getEntityData().func_82580_o("HEE_C10_t");
        }
    });

    public final byte damage;
    public final ICurseHandler handler;
    private ItemStack[] items = new ItemStack[4];
    private byte usesBlockMin;
    private byte usesBlockMax;
    private byte usesEntityMin;
    private byte usesEntityMax;
    private byte usesPlayerMin;
    private byte usesPlayerMax;
    private int color1;
    private int color2;

    public static CurseType getFromDamage(int damage) {
        damage &= 0xFF;
        for (CurseType type : CurseType.values()) {
            if (damage != type.damage) continue;
            return type;
        }
        return null;
    }

    public static boolean isEternal(int damage) {
        return (damage & 0x100) != 0;
    }

    private CurseType(int damage, ICurseHandler handler) {
        this.damage = (byte)damage;
        this.handler = handler;
    }

    private CurseType setRecipe(Object o1, Object o2, Object o3, Object o4) {
        Object[] array = new Object[]{o1, o2, o3, o4};
        for (int a = 0; a < 4; ++a) {
            if (array[a] instanceof Block) {
                this.items[a] = new ItemStack((Block)array[a]);
                continue;
            }
            if (array[a] instanceof Item) {
                this.items[a] = new ItemStack((Item)array[a]);
                continue;
            }
            if (array[a] instanceof ItemStack) {
                this.items[a] = (ItemStack)array[a];
                continue;
            }
            throw new IllegalArgumentException("Invalid recipe object, accepting only Block, Item and ItemStack, got " + array[a].getClass());
        }
        return this;
    }

    private CurseType setColor1h(int hue) {
        return this.setColor1(hue, 75, 90);
    }

    private CurseType setColor1g(int value) {
        return this.setColor1(0, 0, value);
    }

    private CurseType setColor1(int hue, int saturation, int value) {
        float[] rgb = ColorUtil.hsvToRgb((float)hue / 360.0f, (float)saturation / 100.0f, (float)value / 100.0f);
        this.color1 = MathUtil.floor(rgb[0] * 255.0f) << 16 | MathUtil.floor(rgb[1] * 255.0f) << 8 | MathUtil.floor(rgb[2] * 255.0f);
        return this;
    }

    private CurseType setColor2h(int hue) {
        return this.setColor2(hue, 75, 90);
    }

    private CurseType setColor2g(int value) {
        return this.setColor2(0, 0, value);
    }

    private CurseType setColor2(int hue, int saturation, int value) {
        float[] rgb = ColorUtil.hsvToRgb((float)hue / 360.0f, (float)saturation / 100.0f, (float)value / 100.0f);
        this.color2 = MathUtil.floor(rgb[0] * 255.0f) << 16 | MathUtil.floor(rgb[1] * 255.0f) << 8 | MathUtil.floor(rgb[2] * 255.0f);
        return this;
    }

    private CurseType setUses(EnumCurseUse useType, int minUses, int maxUses) {
        switch (useType) {
            case BLOCK: {
                this.usesBlockMin = (byte)minUses;
                this.usesBlockMax = (byte)maxUses;
                break;
            }
            case ENTITY: {
                this.usesEntityMin = (byte)minUses;
                this.usesEntityMax = (byte)maxUses;
                break;
            }
            case PLAYER: {
                this.usesPlayerMin = (byte)minUses;
                this.usesPlayerMax = (byte)maxUses;
                break;
            }
        }
        return this;
    }

    public int getColor(int pass) {
        return pass == 0 ? this.color1 : (pass == 1 ? this.color2 : 0xFFFFFF);
    }

    public ItemStack getRecipeItem(int index) {
        return this.items[index];
    }

    public int getUses(EnumCurseUse useType, Random rand) {
        switch (useType) {
            case BLOCK: {
                return this.usesBlockMin + rand.nextInt(this.usesBlockMax - this.usesBlockMin + 1);
            }
            case ENTITY: {
                return this.usesEntityMin + rand.nextInt(this.usesEntityMax - this.usesEntityMin + 1);
            }
            case PLAYER: {
                return this.usesPlayerMin + rand.nextInt(this.usesPlayerMax - this.usesPlayerMin + 1);
            }
        }
        return 0;
    }

    static {
        TELEPORTATION.setRecipe(Items.field_151079_bi, Items.field_151079_bi, Items.field_151079_bi, Items.field_151079_bi).setUses(EnumCurseUse.BLOCK, 22, 34).setUses(EnumCurseUse.ENTITY, 7, 12).setUses(EnumCurseUse.PLAYER, 3, 6).setColor1h(290).setColor2h(270);
        CONFUSION.setRecipe(Items.field_151145_ak, new ItemStack(Items.field_151100_aR, 1, 0), ItemList.instability_orb, Items.field_151065_br).setUses(EnumCurseUse.BLOCK, 11, 15).setUses(EnumCurseUse.ENTITY, 6, 10).setColor1h(180).setColor2h(0);
        TRANQUILITY.setRecipe(Items.field_151145_ak, new ItemStack(Items.field_151100_aR, 1, 0), Items.field_151007_F, Items.field_151116_aA).setUses(EnumCurseUse.BLOCK, 34, 48).setUses(EnumCurseUse.ENTITY, 75, 105).setColor1h(180).setColor2h(210);
        SLOWNESS.setRecipe(Items.field_151102_aT, Items.field_151102_aT, Items.field_151071_bq, Items.field_151071_bq).setUses(EnumCurseUse.BLOCK, 35, 42).setUses(EnumCurseUse.ENTITY, 16, 21).setUses(EnumCurseUse.PLAYER, 5, 8).setColor1g(50).setColor2h(35);
        WEAKNESS.setRecipe(Items.field_151065_br, Items.field_151065_br, Items.field_151071_bq, Items.field_151071_bq).setUses(EnumCurseUse.BLOCK, 35, 42).setUses(EnumCurseUse.ENTITY, 16, 21).setUses(EnumCurseUse.PLAYER, 5, 8).setColor1g(50).setColor2h(0);
        BLINDNESS.setRecipe(Items.field_151145_ak, Items.field_151071_bq, new ItemStack(Items.field_151100_aR, 1, 0), new ItemStack(Items.field_151100_aR, 1, 0)).setUses(EnumCurseUse.BLOCK, 30, 39).setUses(EnumCurseUse.ENTITY, 12, 16).setUses(EnumCurseUse.PLAYER, 3, 5).setColor1g(50).setColor2h(150);
        DEATH.setRecipe(Items.field_151072_bj, ItemList.ectoplasm, ItemList.silverfish_blood, Items.field_151103_aS).setUses(EnumCurseUse.BLOCK, 28, 36).setUses(EnumCurseUse.ENTITY, 12, 16).setUses(EnumCurseUse.PLAYER, 6, 9).setColor1g(40).setColor2g(57);
        DECAY.setRecipe(ItemList.stardust, ItemList.stardust, Items.field_151042_j, ItemList.instability_orb).setUses(EnumCurseUse.BLOCK, 18, 25).setUses(EnumCurseUse.ENTITY, 14, 19).setUses(EnumCurseUse.PLAYER, 9, 14).setColor1h(46).setColor2g(52);
        VAMPIRE.setRecipe(Items.field_151114_aO, Items.field_151128_bU, ItemList.igneous_rock, ItemList.silverfish_blood).setUses(EnumCurseUse.BLOCK, 15, 22).setUses(EnumCurseUse.ENTITY, 8, 13).setUses(EnumCurseUse.PLAYER, 6, 9).setColor1h(55).setColor2h(9);
        REBOUND.setRecipe(Items.field_151061_bv, Items.field_151074_bl, Items.field_151145_ak, Items.field_151074_bl).setUses(EnumCurseUse.BLOCK, 20, 26).setUses(EnumCurseUse.ENTITY, 15, 22).setUses(EnumCurseUse.PLAYER, 12, 16).setColor1h(0).setColor2h(200);
        LOSS.setRecipe(ItemList.instability_orb, Items.field_151122_aG, Items.field_151137_ax, Items.field_151166_bC).setUses(EnumCurseUse.BLOCK, 14, 19).setUses(EnumCurseUse.ENTITY, 10, 12).setUses(EnumCurseUse.PLAYER, 8, 11).setColor1h(300).setColor2g(50);
    }

    public static enum EnumCurseUse {
        BLOCK,
        ENTITY,
        PLAYER;

    }
}

