/*
 * Decompiled with CFR 0.152.
 */
package chylex.hee.block;

import chylex.hee.entity.fx.EntityEnergyClusterFX;
import chylex.hee.init.BlockList;
import chylex.hee.mechanics.causatum.CausatumMeters;
import chylex.hee.mechanics.causatum.CausatumUtils;
import chylex.hee.system.logging.Stopwatch;
import chylex.hee.system.savedata.WorldDataHandler;
import chylex.hee.system.savedata.types.EnergySavefile;
import chylex.hee.system.util.BlockPosM;
import chylex.hee.system.util.MathUtil;
import chylex.hee.tileentity.TileEntityEnergyCluster;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.particle.EffectRenderer;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;

public class BlockEnergyCluster
extends BlockContainer {
    public static final Block.SoundType soundTypeEnergyCluster = new Block.SoundType("holycrapthisisloud", 5.0f, 1.6f){

        public String func_150498_e() {
            return "dig.glass";
        }

        public String func_150495_a() {
            return "dig.glass";
        }

        public String func_150496_b() {
            return "dig.glass";
        }
    };

    public BlockEnergyCluster() {
        super(Material.field_151592_s);
        this.func_149676_a(0.3f, 0.3f, 0.3f, 0.7f, 0.7f, 0.7f);
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileEntityEnergyCluster(world);
    }

    public void func_149749_a(World world, int x, int y, int z, Block block, int meta) {
        TileEntityEnergyCluster tile = (TileEntityEnergyCluster)world.func_147438_o(x, y, z);
        if (tile == null || tile.shouldNotExplode) {
            return;
        }
        super.func_149749_a(world, x, y, z, block, meta);
        BlockEnergyCluster.destroyCluster(tile);
    }

    public void func_149670_a(World world, int x, int y, int z, Entity entity) {
        if (entity instanceof EntityArrow || entity instanceof EntityThrowable) {
            BlockPosM.tmp(x, y, z).setAir(world);
        }
    }

    public AxisAlignedBB func_149668_a(World world, int x, int y, int z) {
        return null;
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public int func_149645_b() {
        return -1;
    }

    public Item func_149650_a(int meta, Random rand, int fortune) {
        return null;
    }

    public int func_149745_a(Random rand) {
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addHitEffects(World world, MovingObjectPosition target, EffectRenderer effectRenderer) {
        for (int a = 0; a < 4; ++a) {
            effectRenderer.func_78873_a((EntityFX)new EntityEnergyClusterFX(world, (double)target.field_72311_b + 0.5, (double)target.field_72312_c + 0.5, (double)target.field_72309_d + 0.5, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0));
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addDestroyEffects(World world, int x, int y, int z, int meta, EffectRenderer effectRenderer) {
        for (int a = 0; a < 4; ++a) {
            effectRenderer.func_78873_a((EntityFX)new EntityEnergyClusterFX(world, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0));
        }
        return true;
    }

    public static void destroyCluster(TileEntityEnergyCluster tile) {
        Stopwatch.time("BlockEnergyCluster - destroyCluster");
        World world = tile.func_145831_w();
        int x = tile.field_145851_c;
        int y = tile.field_145848_d;
        int z = tile.field_145849_e;
        int energyMeta = Math.min(15, 3 + (int)(tile.data.getEnergyLevel() * 0.8f));
        double dist = 4.4 + (double)energyMeta * 0.1;
        int idist = MathUtil.ceil(dist);
        world.func_72885_a(null, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, 2.8f + (float)(energyMeta - 3) * 0.225f, true, true);
        ((EnergySavefile)WorldDataHandler.get(EnergySavefile.class)).getFromBlockCoords(world, x, z, true).addEnergy(tile.data.getEnergyLevel() * 0.2f);
        BlockPosM tmpPos = BlockPosM.tmp();
        for (int xx = x - idist; xx <= x + idist; ++xx) {
            for (int zz = z - idist; zz <= z + idist; ++zz) {
                for (int yy = y - idist; yy <= y + idist; ++yy) {
                    if (!(MathUtil.distance(xx - x, yy - y, zz - z) <= dist) || !world.func_147437_c(xx, yy, zz)) continue;
                    tmpPos.set(xx, yy, zz).setBlock(world, BlockList.corrupted_energy_high, energyMeta);
                }
            }
        }
        for (EntityPlayer player : world.func_72872_a(EntityPlayer.class, AxisAlignedBB.func_72330_a((double)((double)x + 0.5), (double)((double)y + 0.5), (double)((double)z + 0.5), (double)((double)x + 0.5), (double)((double)y + 0.5), (double)((double)z + 0.5)).func_72314_b(6.0, 6.0, 6.0))) {
            if (!(player.func_70011_f((double)x + 0.5, (double)y + 0.5, (double)z + 0.5) <= 6.0)) continue;
            CausatumUtils.increase(player, CausatumMeters.END_ENERGY, 20.0f);
        }
        Stopwatch.finish("BlockEnergyCluster - destroyCluster");
    }
}

