/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.theme;

import greymerk.roguelike.theme.IBlockSet;
import greymerk.roguelike.theme.ITheme;
import greymerk.roguelike.worldgen.IBlockFactory;
import greymerk.roguelike.worldgen.IStair;

public class ThemeBase
implements ITheme {
    protected IBlockSet primary;
    protected IBlockSet secondary;

    public ThemeBase(IBlockSet primary, IBlockSet secondary) {
        this.primary = primary;
        this.secondary = secondary;
    }

    public ThemeBase(ThemeBase base, IBlockSet primary, IBlockSet secondary) {
        this.primary = primary == null ? base.primary : primary;
        this.secondary = secondary == null ? base.secondary : secondary;
    }

    public ThemeBase() {
    }

    @Override
    public IBlockFactory getPrimaryWall() {
        return this.primary.getFill();
    }

    @Override
    public IStair getPrimaryStair() {
        return this.primary.getStair();
    }

    @Override
    public IBlockFactory getPrimaryPillar() {
        return this.primary.getPillar();
    }

    @Override
    public IBlockFactory getSecondaryPillar() {
        return this.secondary.getPillar();
    }

    @Override
    public IBlockFactory getSecondaryWall() {
        return this.secondary.getFill();
    }

    @Override
    public IStair getSecondaryStair() {
        return this.secondary.getStair();
    }

    @Override
    public IBlockFactory getPrimaryFloor() {
        return this.primary.getFloor();
    }

    @Override
    public IBlockFactory getSecondaryFloor() {
        return this.secondary.getFloor();
    }
}

