/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.computronics.oc.driver;

import com.google.common.base.Throwables;
import cpw.mods.fml.common.Optional;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Arrays;
import li.cil.oc.api.Network;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.Environment;
import li.cil.oc.api.network.EnvironmentHost;
import li.cil.oc.api.network.Message;
import li.cil.oc.api.network.Node;
import li.cil.oc.api.network.Visibility;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import pl.asie.computronics.Computronics;
import pl.asie.computronics.api.audio.AudioPacket;
import pl.asie.computronics.api.audio.AudioPacketDFPWM;
import pl.asie.computronics.api.audio.IAudioReceiver;
import pl.asie.computronics.api.audio.IAudioSource;
import pl.asie.computronics.audio.AudioUtils;
import pl.asie.computronics.audio.tts.TextToSpeech;
import pl.asie.computronics.oc.driver.ManagedEnvironmentWithComponentConnector;
import pl.asie.computronics.reference.Config;
import pl.asie.computronics.util.OCUtils;

public class RobotUpgradeSpeech
extends ManagedEnvironmentWithComponentConnector
implements IAudioSource,
TextToSpeech.ICanSpeak {
    protected final EnvironmentHost host;
    private final IAudioReceiver internalSpeaker = new IAudioReceiver(){

        @Override
        public boolean connectsAudio(ForgeDirection side) {
            return true;
        }

        @Override
        public World getSoundWorld() {
            return RobotUpgradeSpeech.this.host.world();
        }

        @Override
        public Vec3 getSoundPos() {
            return Vec3.func_72443_a((double)RobotUpgradeSpeech.this.host.xPosition(), (double)RobotUpgradeSpeech.this.host.yPosition(), (double)RobotUpgradeSpeech.this.host.zPosition());
        }

        @Override
        public int getSoundDistance() {
            return Config.SOUND_RADIUS;
        }

        @Override
        public void receivePacket(AudioPacket packet, ForgeDirection direction) {
            packet.addReceiver(this);
        }

        @Override
        public String getID() {
            return RobotUpgradeSpeech.this.host instanceof TileEntity ? AudioUtils.positionId(RobotUpgradeSpeech.this.host.xPosition(), RobotUpgradeSpeech.this.host.yPosition(), RobotUpgradeSpeech.this.host.zPosition()) : "";
        }
    };
    protected boolean isValid = false;
    private long lastCodecTime;
    private int codecId = -1;
    protected int packetSize = 1024;
    protected int soundVolume = 127;
    private boolean locked = false;
    private ByteArrayInputStream storage;

    public RobotUpgradeSpeech(EnvironmentHost host) {
        this.host = host;
        this.setNode(Network.newNode((Environment)this, (Visibility)Visibility.Neighbors).withComponent("speech").withConnector().create());
    }

    public boolean canUpdate() {
        return true;
    }

    public void update() {
        super.update();
        AudioPacket pkt = null;
        long time = System.nanoTime();
        if (time - 250000000L > this.lastCodecTime) {
            this.lastCodecTime += 250000000L;
            pkt = this.createMusicPacket(this);
        }
        if (pkt != null) {
            this.internalSpeaker.receivePacket(pkt, ForgeDirection.UNKNOWN);
            pkt.sendPacket();
        }
    }

    @Override
    public boolean isValid() {
        return this.isValid;
    }

    public void onConnect(Node node) {
        super.onConnect(node);
        if (node == this.node()) {
            this.isValid = true;
        }
    }

    public void onDisconnect(Node node) {
        super.onDisconnect(node);
        if (node == this.node()) {
            this.isValid = false;
            this.stopTalking();
        }
    }

    public void onMessage(Message message) {
        super.onMessage(message);
        if ((message.name().equals("computer.stopped") || message.name().equals("computer.started")) && this.node().isNeighborOf(message.source())) {
            if (this.locked || this.storage != null) {
                this.stopTalking();
            }
            this.isValid = message.name().equals("computer.started");
        }
    }

    @Override
    public void startTalking(byte[] data) {
        if (this.host.world().field_72995_K) {
            return;
        }
        this.storage = new ByteArrayInputStream(data);
        this.codecId = Computronics.instance.audio.newPlayer();
        Computronics.instance.audio.getPlayer(this.codecId);
        this.lastCodecTime = System.nanoTime();
    }

    private void stopTalking() {
        if (this.host.world() != null && this.host.world().field_72995_K) {
            return;
        }
        AudioUtils.removePlayer(Computronics.instance.managerId, this.codecId);
        this.locked = false;
        this.storage = null;
    }

    private Object[] sendNewText(String text) throws IOException {
        if (Computronics.tts == null) {
            return new Object[]{false, "text-to-speech system not available"};
        }
        this.locked = true;
        Computronics.tts.say(this, text);
        return new Object[]{true};
    }

    private AudioPacket createMusicPacket(IAudioSource source) {
        if (this.storage == null) {
            return null;
        }
        byte[] pktData = new byte[this.packetSize];
        int amount = this.storage.read(pktData, 0, pktData.length);
        if (amount > 0) {
            return new AudioPacketDFPWM(source, (byte)this.soundVolume, this.packetSize * 8 * 4, amount == this.packetSize ? pktData : Arrays.copyOf(pktData, amount));
        }
        this.stopTalking();
        return null;
    }

    public void load(NBTTagCompound tag) {
        super.load(tag);
        if (this.soundVolume != 127) {
            tag.func_74774_a("vo", (byte)this.soundVolume);
        }
    }

    public void save(NBTTagCompound tag) {
        super.save(tag);
        this.soundVolume = tag.func_74764_b("vo") ? (int)tag.func_74771_c("vo") : 127;
    }

    public void setVolume(float volume) {
        if (volume < 0.0f) {
            volume = 0.0f;
        }
        if (volume > 1.0f) {
            volume = 1.0f;
        }
        this.soundVolume = (int)Math.floor(volume * 127.0f);
    }

    @Callback(doc="function(text:string):boolean; Say the specified message. Returns true on success, false and an error message otherwise.")
    @Optional.Method(modid="OpenComputers")
    public Object[] say(Context context, Arguments args) {
        if (this.locked || this.storage != null) {
            return new Object[]{false, "already processing"};
        }
        String text = args.checkString(0);
        if (text.length() > Config.TTS_MAX_LENGTH) {
            return new Object[]{false, "text too long"};
        }
        try {
            return this.sendNewText(text);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("could not send string");
        }
        catch (Exception e) {
            e.printStackTrace();
            Throwables.propagate((Throwable)e);
            return new Object[]{false};
        }
    }

    @Callback(doc="function():boolean; Stops the currently spoken phrase. Returns true on success, false and an error message otherwise.")
    @Optional.Method(modid="OpenComputers")
    public Object[] stop(Context context, Arguments args) {
        if (this.locked || this.storage != null) {
            this.stopTalking();
            return new Object[]{true};
        }
        return new Object[]{false, "not talking"};
    }

    @Callback(doc="function():boolean; Returns true if the device is currently processing text.", direct=true)
    @Optional.Method(modid="OpenComputers")
    public Object[] isProcessing(Context context, Arguments args) {
        return new Object[]{this.locked || this.storage != null};
    }

    @Callback(doc="function(speed:number); Sets the volume of the speech box. Needs to be beween 0 and 1")
    @Optional.Method(modid="OpenComputers")
    public Object[] setVolume(Context context, Arguments args) {
        this.setVolume((float)args.checkDouble(0));
        return new Object[0];
    }

    @Override
    public boolean connectsAudio(ForgeDirection side) {
        return false;
    }

    @Override
    public int getSourceId() {
        return this.codecId;
    }

    @Override
    @Optional.Method(modid="OpenComputers")
    protected OCUtils.Device deviceInfo() {
        return new OCUtils.Device("multimedia", "Text-To-Speech Interface", "DFKI GmbH", "Mary", new String[0]);
    }
}

